/*
 * Decompiled with CFR 0.152.
 */
import com.sonyericsson.capuchin.FlashCanvas;
import com.sonyericsson.capuchin.FlashDataRequest;
import com.sonyericsson.capuchin.FlashDataRequestListener;
import com.sonyericsson.capuchin.FlashImage;
import com.sonyericsson.capuchin.FlashPlayer;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.microedition.global.ResourceManager;
import javax.microedition.io.Connector;
import javax.microedition.io.file.FileConnection;
import javax.microedition.lcdui.Display;
import javax.microedition.midlet.MIDlet;

public class Florin
extends MIDlet
implements FlashDataRequestListener {
    private FlashPlayer flashPlayer;
    private FlashImage flashImage;
    private FlashCanvas flashCanvas;
    private static final int maxFlashChars = 1500;
    private ResourceManager res;
    private String lang;
    private int numResourcesLoaded = 0;
    private static final String DEFAULT_LANGUAGE = "en";
    private static final int TOTAL_NUM_RESOURCES = 182;
    private static final int RESOURCE_BUFFER = 200;
    private StringBuffer textFile;

    public Florin() {
        this.setCurrentLanguage();
        this.res = ResourceManager.getManager((String)"Checkbook", (String)this.lang);
        try {
            InputStream is = ((Object)((Object)this)).getClass().getResourceAsStream("//florin.swf");
            this.flashImage = FlashImage.createImage((InputStream)is, null);
            this.flashImage.setFlashDataRequestListener((FlashDataRequestListener)this);
            this.flashCanvas = new FlashCanvas(this.flashImage);
            this.flashPlayer = FlashPlayer.createFlashPlayer((FlashImage)this.flashImage, (FlashCanvas)this.flashCanvas);
            this.flashCanvas.setFullScreenMode(true);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public synchronized void dataRequested(FlashDataRequest request) {
        String[] args = request.getArgs();
        String commandName = args[0];
        if (commandName.equals("quit")) {
            this.destroyApp(true);
        } else if (commandName.equals("checkDiskSpace")) {
            try {
                FileConnection fc = (FileConnection)Connector.open((String)"file:///c:/other/florin/");
                String availableSpace = "" + fc.availableSize();
                fc.close();
                request.setProperty("space", availableSpace);
                request.setProperty("success", "1");
                request.complete();
            }
            catch (IOException e) {
                request.setProperty("space", "0");
                request.setProperty("success", "0");
                request.complete();
            }
        } else if (commandName.equals("getLocale")) {
            request.setProperty("locale", this.getCurrentLanguage());
            request.setProperty("success", "1");
            request.complete();
        } else if (commandName.equals("getText")) {
            String isFinished;
            request.setProperty("text", this.getAppText());
            if (this.numResourcesLoaded < 182) {
                isFinished = "0";
            } else {
                isFinished = "1";
                this.numResourcesLoaded = 0;
            }
            request.setProperty("numResourcesLoaded", this.numResourcesLoaded);
            request.setProperty("isFinished", isFinished);
            request.setProperty("success", "1");
            request.complete();
        } else {
            String success = new String();
            String url = args[1];
            if (commandName.equals("exist")) {
                success = this.doesFileExist(url);
            } else if (commandName.equals("create")) {
                success = this.createFile(url);
            } else if (commandName.equals("write")) {
                String str = args[2];
                success = this.writeToFile(url, str);
            } else if (commandName.equals("read")) {
                this.textFile = this.readFile(url);
                String flashStr = this.textFile.toString();
                if (this.textFile.length() > 1500) {
                    String tempflashStr = flashStr.substring(0, 1500);
                    int pos = tempflashStr.lastIndexOf(44);
                    flashStr = tempflashStr.substring(0, pos);
                    success = "-";
                    this.textFile.delete(0, pos);
                } else {
                    success = this.textFile.length() > 0 ? "" + this.textFile.length() : "0";
                }
                request.setProperty("dataStr", flashStr);
            } else if (commandName.equals("readMore")) {
                String flashStr = this.textFile.toString();
                if (this.textFile.length() > 1500) {
                    String tempflashStr = flashStr.substring(0, 1500);
                    int pos = tempflashStr.lastIndexOf(44);
                    flashStr = tempflashStr.substring(0, pos);
                    success = "-";
                    this.textFile.delete(0, pos);
                } else {
                    success = this.textFile.length() > 0 ? "" + this.textFile.length() : "0";
                }
                request.setProperty("dataStr", flashStr);
            } else if (commandName.equals("append")) {
                String str = args[2];
                success = this.appendFile(url, str);
            } else if (commandName.equals("clear")) {
                this.deleteFile(url);
                success = this.createFile(url);
            } else if (commandName.equals("delete")) {
                success = this.deleteFile(url);
            } else if (commandName.equals("mkdir")) {
                success = this.makeDirectory(url);
            } else if (commandName.equals("rmdir")) {
                success = this.deleteFile(url);
            }
            request.setProperty("success", success);
            request.complete();
        }
    }

    public String doesFileExist(String url) {
        FileConnection fc;
        block3: {
            try {
                fc = (FileConnection)Connector.open((String)url);
                if (!fc.exists()) break block3;
                fc.close();
                return "1";
            }
            catch (IOException e) {
                return "0";
            }
        }
        fc.close();
        return "0";
    }

    private void setCurrentLanguage() {
        this.lang = System.getProperty("microedition.locale");
        if (!this.getIsLanguageSupported(this.lang)) {
            this.lang = DEFAULT_LANGUAGE;
        }
    }

    private boolean getIsLanguageSupported(String lang) {
        String[] supportedLanguages = ResourceManager.getSupportedLocales((String)"Checkbook");
        int numLanguages = supportedLanguages.length;
        int i = 0;
        while (i < numLanguages) {
            if (lang.equals(supportedLanguages[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private String getAppText() {
        int maxLength = 10000;
        int startIndex = this.numResourcesLoaded;
        int count = this.numResourcesLoaded + 200;
        StringBuffer text = new StringBuffer(maxLength);
        int i = startIndex;
        while (i < count) {
            if (this.numResourcesLoaded >= 182) break;
            String test = this.res.getString(i + 1);
            if (1500 < text.length() + 1 + test.length()) break;
            if (this.numResourcesLoaded > 0) {
                text.append("|");
            }
            text.append(test);
            ++this.numResourcesLoaded;
            ++i;
        }
        return text.toString();
    }

    public String createFile(String url) {
        FileConnection fc;
        block3: {
            try {
                fc = (FileConnection)Connector.open((String)url);
                if (fc.exists()) break block3;
                fc.create();
                fc.close();
                return "1";
            }
            catch (IOException e) {
                return "0";
            }
        }
        fc.close();
        return "0";
    }

    public String writeToFile(String url, String str) {
        try {
            FileConnection fc = (FileConnection)Connector.open((String)url);
            if (!fc.exists()) {
                fc.create();
            }
            OutputStream os = fc.openOutputStream();
            os.write(str.getBytes());
            os.flush();
            os.close();
            fc.close();
            return "1";
        }
        catch (IOException e) {
            return "0";
        }
    }

    public String appendFile(String url, String str) {
        FileConnection fc;
        block3: {
            try {
                fc = (FileConnection)Connector.open((String)url);
                if (!fc.exists()) break block3;
                OutputStream os = fc.openOutputStream();
                StringBuffer buf = this.readFile(url);
                buf.append(str);
                os.write(buf.toString().getBytes());
                os.flush();
                os.close();
                fc.close();
                return "1";
            }
            catch (IOException e) {
                return "0";
            }
        }
        fc.close();
        return "0";
    }

    public StringBuffer readFile(String url) {
        try {
            FileConnection fc = (FileConnection)Connector.open((String)url);
            if (fc.exists()) {
                byte b;
                InputStream is = fc.openInputStream();
                StringBuffer buf = new StringBuffer();
                while ((b = (byte)is.read()) != -1) {
                    buf.append((char)b);
                }
                is.close();
                fc.close();
                return buf;
            }
            fc.close();
            return null;
        }
        catch (IOException e) {
            return null;
        }
    }

    public String deleteFile(String url) {
        FileConnection fc;
        block3: {
            try {
                fc = (FileConnection)Connector.open((String)url);
                if (!fc.exists()) break block3;
                fc.delete();
                fc.close();
                return "1";
            }
            catch (IOException e) {
                return "0";
            }
        }
        fc.close();
        return "0";
    }

    public String doesDirectoryExist(String url) {
        FileConnection fc;
        block3: {
            try {
                fc = (FileConnection)Connector.open((String)url);
                if (!fc.exists()) break block3;
                fc.close();
                return "1";
            }
            catch (IOException e) {
                return "0";
            }
        }
        fc.close();
        return "0";
    }

    public String makeDirectory(String url) {
        FileConnection fc;
        block3: {
            try {
                fc = (FileConnection)Connector.open((String)url);
                if (fc.exists()) break block3;
                fc.mkdir();
                fc.setHidden(true);
                fc.close();
                return "1";
            }
            catch (IOException e) {
                return "0";
            }
        }
        fc.close();
        return "0";
    }

    public String getCurrentLanguage() {
        return this.lang;
    }

    protected void startApp() {
        if (this.flashPlayer != null) {
            Display.getDisplay((MIDlet)this).setCurrent(this.flashPlayer.getDisplayable());
        }
    }

    protected void destroyApp(boolean arg0) {
        this.notifyDestroyed();
    }

    protected void pauseApp() {
    }
}

