MI             &g<!DOCTYPE config SYSTEM "config.dtd">
<config info="FRANCE CONFIGURATION FILE TAO CA1" >

	<!-- Options -->
	<options searchDialler="false"
		myNumber="false"
		maxSidebarMenus="12"
		maxShortcutItems="7"
		maxVips="5" 
		maxEmailAccounts="5">

		<iconPaths>
			<sidebarMenus>/Icons/SideBarMenus/</sidebarMenus>
			<dataDisplayArea>/Icons/SideBar/DataDisplayArea/</dataDisplayArea>
			<indicators>/Icons/SideBar/Indicators/</indicators>
		</iconPaths>

		<dataIcon type="EMAIL" indicatorHint="downright">Email.png</dataIcon>
		<dataIcon type="EVENT" indicatorHint="downright">Event.png</dataIcon>
		<dataIcon type="IMCONVERSATION" indicatorHint="downright">IM.png</dataIcon>
		<dataIcon type="MISSEDCALL" indicatorHint="topleft">MissedCall.png</dataIcon>
		<dataIcon type="MISSEDVISIO" indicatorHint="topleft">MissedVideoCall.png</dataIcon>
		<dataIcon type="MMS" indicatorHint="downright">MMS.png</dataIcon>
		<dataIcon type="SMS" indicatorHint="downright">SMS.png</dataIcon>


    <shortcutRSK id="back" language_id="197">
      <defaultAction type="custom">back</defaultAction>
    </shortcutRSK>

	</options>
	
	
	<!-- List of sidebar menus -->
	<sidebar>
		<!-- menus displayed on the sidebar !! ORDERED !! MUST NOT EXCEED max_sidebar_menus options -->
		<displayed>
			<menuId>orangeWorld</menuId>
			<menuId>call_log</menuId>
			<menuId>contacts</menuId>
			<menuId>messaging</menuId>
			<menuId>appShop</menuId>
			<menuId>orangeMusic</menuId> 
			<menuId>orangeTV</menuId>
			<menuId>simTK</menuId>
			<menuId>my_communities</menuId>
		</displayed>
		
		<!-- menus available for add -->
		<available>
		  <menuId>musicPlayer</menuId>
			<menuId>calendar</menuId>
		  <menuId>email</menuId>
			<menuId>mediaMenu</menuId>
			<menuId>alarm</menuId>
			<menuId>profile</menuId>
			<menuId>connections</menuId>
		</available>
	</sidebar>
	
	<!-- List of all handlers -->
	<handlers>
		<!-- one handler created for each data type (handler= type name) -->
		<type>SMS</type>
		<type>MMS</type>
		<type>EMAIL</type>
		<type>IMCONVERSATION</type>
		<type>EVENT</type>
		<type>MISSEDCALL</type>
		<type>MISSEDVISIO</type>

		<!-- multi-type handlers -->
		<handler id="all">
			<type>SMS</type>
			<type>MMS</type>
			<type>EMAIL</type>
			<type>IMCONVERSATION</type>
			<type>MISSEDCALL</type>
			<type>MISSEDVISIO</type>
		</handler>
		<handler id="missedAllCalls">
			<type>MISSEDCALL</type>
			<type>MISSEDVISIO</type>			
		</handler>
		<handler id="unifiedWithoutEmail">
			<type>SMS</type>
			<type>MMS</type>
		</handler>
	</handlers>

	<!-- Orange WORLD -->
	<menu id="orangeWorld" language_id="1">
		<iconUnselected>hs3_orangeworld_unselected.png</iconUnselected>		
		<item id="orangeWorld" language_id="1">
			<defaultAction type="url">http://www.orange.fr</defaultAction>
		</item>
		<item id="music" language_id="9">
			<defaultAction type="url">http://musique.mob3.orange.fr</defaultAction>
		</item>
		<item id="games" language_id="32">
			<defaultAction type="url">http://jeux.mob3.orange.fr</defaultAction>
		</item>
		<item id="tv_video" language_id="31">
			<defaultAction type="url">http://tvvideo.mob3.orange.fr</defaultAction>
		</item>
		<item id="sonslogos" language_id="53">
			<defaultAction type="url">http://sonlogos.mob3.orange.fr</defaultAction>
		</item>
		<item id="gallery" language_id="37">
			<defaultAction type="url">http://gallery.mob3.orange.fr</defaultAction>
		</item>
	</menu>

	<!-- CALL LOG -->
	<menu id="call_log" language_id="5" locked="true">
		<iconUnselected>hs3_callhistory_unselected.png</iconUnselected>
		<item id="voicemail" language_id="65">
			<defaultAction type="call">888</defaultAction>
		</item>
		<item id="missedCalls" language_id="67" custom="handler">
			<defaultAction type="launch">calls:missed</defaultAction>
			<action id="call_log_sc" language_id="64" nbData="0" type="launch">calls</action>
			<action id="missedCalls" language_id="67" nbData="1" type="custom">data</action>
			<handlerId>missedAllCalls</handlerId><!-- Handler name MUST refers to those ones listed between <handlersList></handlersList> tags above -->
			<indicator>MISSEDCALL</indicator>
			<indicator>MISSEDVISIO</indicator>
		</item>		
		<item id="call_plan" language_id="68">
			<defaultAction type="call">#123#</defaultAction>  <!-- FR -->
		</item>
	</menu>

	<!-- CONTACTS -->
	<menu id="contacts" language_id="4" locked="true">
		<iconUnselected>hs3_contact_unselected.png</iconUnselected>
		<item id="contact_list" language_id="61">
			<defaultAction type="launch">contacts</defaultAction>
		</item>
		<item id="vipContact" language_id="63" custom="vip">
			<defaultAction type="custom"></defaultAction>
		</item>		
	</menu>

	<!-- MESSAGES -->
	<menu id="messaging" language_id="6" locked="true">
		<iconUnselected>hs3_messages_unselected.png</iconUnselected>
		<item id="writeMessage" language_id="69">
			<defaultAction type="launch">message:new</defaultAction>
		</item>
		<item id="inbox" language_id="71" custom="handler">
			<defaultAction type="launch">message:inbox</defaultAction>
			<action nbData="1" id="view_message" language_id="72" type="custom">data</action>
			<handlerId>unifiedWithoutEmail</handlerId>			
			<indicator>SMS</indicator>
			<indicator>MMS</indicator>		
		</item>
		<item id="orangeMessenger" language_id="19">
			<defaultAction type="java_launch">Messenger</defaultAction>
		</item>	
	</menu>

	<!-- Application Shop -->
	<menu id="appShop" language_id="18">
		<iconUnselected>hs3_appshop_unselected.png</iconUnselected>
		<item id="appShop" language_id="18">
			<defaultAction type="java_launch">App Shop</defaultAction>
		</item>
	</menu>

	<!-- Orange MUSIC -->
	<menu id="orangeMusic" language_id="8">
		<iconUnselected>hs3_music_unselected.png</iconUnselected>
		<item id="musicStore" language_id="77">
			<defaultAction type="url">http://musique.mob3.orange.fr</defaultAction>
		</item>
		<item id="myMusic" language_id="76">
			<defaultAction type="launch">music:playlist</defaultAction>
		</item>
	</menu>

	<!-- Orange TV -->
	<menu id="orangeTV" language_id="15">
		<iconUnselected>hs3_tv_unselected.png</iconUnselected>
		<item id="orangeTV" language_id="15">
			<defaultAction type="java_launch">Orange TV player</defaultAction>
		</item>
	</menu>

	<!-- SIM Toolkit -->
	<menu id="simTK" language_id="27">
		<iconUnselected>hs3_simtk_unselected.png</iconUnselected>
		<item id="simTK" language_id="27">
			<defaultAction type="launch">simtk</defaultAction>
		</item>
	</menu>

	<!-- My Communities -->
	<menu id="my_communities" language_id="36">
	  <iconUnselected>hs3_sociallife_unselected.png</iconUnselected>
		<item id="my_communities" language_id="36">
			<defaultAction type="url">http://mobile.orange.fr/0/accueil/Retour?SA=MOCDEVICE</defaultAction>
		</item>
	</menu>
	
	<!-- Music Player -->
	<menu id="musicPlayer" language_id="10">
		<iconUnselected>hs3_music_playing_unselected.png</iconUnselected>
		<item id="musicPlayer" language_id="10" custom="mplayer">
			<defaultAction type="custom" />
		</item>
	</menu>

	<!-- CALENDAR -->
	<menu id="calendar" language_id="3">
		<iconUnselected>hs3_calendar_unselected.png</iconUnselected>
		<item id="today" language_id="59" custom="handler" time="true" >
			<defaultAction type="launch">calendar</defaultAction>
			<action nbData="0" id="calendar" language_id="3" type="launch">calendar</action>
			<action nbData="1" id="today" language_id="59" type="custom">data</action>
			<handlerId>EVENT</handlerId>	
			<indicator>EVENT</indicator>
		</item>
		<item id="addAppointment" language_id="60">
			<defaultAction type="launch">calendar:new</defaultAction>
		</item>
	</menu>
		
	<!-- EMAIL -->
	<menu id="email" language_id="13">
		<iconUnselected>hs3_emails_unselected.png</iconUnselected>
		<item id="write_email" language_id="82" >
			<defaultAction type="launch">email:new</defaultAction>						
		</item>
		<item id="EmailInbox" language_id="81" custom="handler" >
			<defaultAction type="launch">email:inbox</defaultAction>
			<action nbData="1" id="view_message" language_id="72" type="custom">data</action>
			<handlerId>EMAIL</handlerId>
			<indicator>EMAIL</indicator>
		</item>
		<item id="email" language_id="13" custom="email" >
			<defaultAction type="launch">email:accounts</defaultAction>
		</item>	
	</menu>
	
	<!-- MEDIA -->
	<menu id="mediaMenu" language_id="7" >
		<iconUnselected>hs3_gen_media_unselected.png</iconUnselected>
		<item id="takePicture" language_id="73">
			<defaultAction type="launch">camera</defaultAction>
		</item>
		<item id="mediaMenu" language_id="7">
			<defaultAction type="launch">multimedia</defaultAction>
		</item>
	</menu>
	
	<!-- Alarm -->
	<menu id="alarm" language_id="12">
		<iconUnselected>hs3_alarm_unselected.png</iconUnselected>		
		<item id="alarm" language_id="12" custom="alarm">
			<defaultAction type="launch">alarm</defaultAction>
		</item>
	</menu>
	
	<!-- Profile -->
	<menu id="profile" language_id="11">
		<iconUnselected>hs3_profile_unselected.png</iconUnselected>
		<item id="set_profile" language_id="78">
			<defaultAction type="launch">profile</defaultAction>
		</item>	
	</menu>
  
	<!-- CONNECTIONS -->
	<menu id="connections" language_id="24">
		<iconUnselected>hs3_connection_unselected.png</iconUnselected>
		<item id="bluetooth" language_id="87" custom="connection">
			<defaultAction type="launch">bluetooth</defaultAction>			
		</item>
		<item id="flight_mode" language_id="88" custom="connection">
			<defaultAction type="launch">flightmode</defaultAction>			
		</item>
	</menu>
  
</config>