/*
 * Decompiled with CFR 0.152.
 */
package com.myweather.util;

import com.myweather.util.CurrentCityParser;
import com.myweather.valueobject.AdInfo;
import com.myweather.valueobject.ChargeInfo;
import com.myweather.valueobject.CityInfo;
import com.myweather.valueobject.ForecastDay;
import com.myweather.valueobject.LifeStyle;
import de.enough.polish.util.Debug;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.microedition.io.Connector;
import javax.microedition.io.HttpConnection;

public class ConnectionUtil {
    public static boolean appNotAuthorized = false;

    public static HttpConnection getHttpConnection(String url, String method, Hashtable headers) throws Exception {
        HttpConnection httpConn = null;
        try {
            System.out.println("url = " + url);
            if (method == null || method.equals("GET") || method.equals("HEAD")) {
                httpConn = (HttpConnection)Connector.open((String)url);
            } else {
                httpConn = (HttpConnection)Connector.open((String)url);
                httpConn.setRequestMethod(method);
            }
            ConnectionUtil.setHttpHeaders(httpConn, headers);
            System.out.println("open conn end ");
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
            throw e;
        }
        return httpConn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized CityInfo getCityInfo(HttpConnection conn, String url, byte[] inBuffer, int off, int len, Hashtable headers) {
        CityInfo cityInfo = null;
        boolean ifCreateConn = false;
        try {
            if (conn == null) {
                conn = inBuffer == null ? ConnectionUtil.getHttpConnection(url, "POST", headers) : ConnectionUtil.getHttpConnection(url, "POST", headers);
                ifCreateConn = true;
            }
            if (inBuffer != null) {
                OutputStream out = conn.openOutputStream();
                out.write(inBuffer, off, len);
            }
            int responseCode = conn.getResponseCode();
            InputStream input = conn.openInputStream();
            cityInfo = CurrentCityParser.parseCity(input);
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
            cityInfo = new CityInfo();
        }
        finally {
            if (ifCreateConn) {
                ConnectionUtil.closeHttpConnectionQuietly(conn);
            }
        }
        return cityInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized ChargeInfo getChargeInfo(HttpConnection conn, String url, byte[] inBuffer, int off, int len, Hashtable headers) {
        ChargeInfo chargeInfo = null;
        boolean ifCreateConn = false;
        try {
            if (conn == null) {
                conn = inBuffer == null ? ConnectionUtil.getHttpConnection(url, "POST", headers) : ConnectionUtil.getHttpConnection(url, "POST", headers);
                ifCreateConn = true;
            }
            if (inBuffer != null) {
                OutputStream out = conn.openOutputStream();
                out.write(inBuffer, off, len);
            }
            int responseCode = conn.getResponseCode();
            System.out.println("charge responseCode = " + responseCode);
            InputStream input = conn.openInputStream();
            chargeInfo = CurrentCityParser.parseChargeCode(input);
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
            chargeInfo = new ChargeInfo();
        }
        finally {
            if (ifCreateConn) {
                ConnectionUtil.closeHttpConnectionQuietly(conn);
            }
        }
        return chargeInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized ForecastDay getForeCastDay(HttpConnection conn, String url, byte[] inBuffer, int off, int len, Hashtable headers) {
        ForecastDay forecastDay = null;
        boolean ifCreateConn = false;
        try {
            if (conn == null) {
                conn = inBuffer == null ? ConnectionUtil.getHttpConnection(url, "POST", headers) : ConnectionUtil.getHttpConnection(url, "POST", headers);
                ifCreateConn = true;
            }
            if (inBuffer != null) {
                OutputStream out = conn.openOutputStream();
                out.write(inBuffer, off, len);
            }
            int responseCode = conn.getResponseCode();
            System.out.println("responseCode = " + responseCode);
            InputStream input = conn.openInputStream();
            forecastDay = CurrentCityParser.parseForeCastDay(input);
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
            forecastDay = new ForecastDay();
        }
        finally {
            if (ifCreateConn) {
                ConnectionUtil.closeHttpConnectionQuietly(conn);
            }
        }
        return forecastDay;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized LifeStyle getLifeStyle(HttpConnection conn, String url, byte[] inBuffer, int off, int len, Hashtable headers) {
        LifeStyle lifeStyle = null;
        boolean ifCreateConn = false;
        try {
            if (conn == null) {
                conn = inBuffer == null ? ConnectionUtil.getHttpConnection(url, "POST", headers) : ConnectionUtil.getHttpConnection(url, "POST", headers);
                ifCreateConn = true;
            }
            if (inBuffer != null) {
                OutputStream out = conn.openOutputStream();
                out.write(inBuffer, off, len);
            }
            int responseCode = conn.getResponseCode();
            System.out.println("responseCode = " + responseCode);
            InputStream input = conn.openInputStream();
            lifeStyle = CurrentCityParser.parseLifeStyle(input);
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
            lifeStyle = new LifeStyle();
        }
        finally {
            if (ifCreateConn) {
                ConnectionUtil.closeHttpConnectionQuietly(conn);
            }
        }
        return lifeStyle;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized AdInfo getAdInfo(HttpConnection conn, String url, byte[] inBuffer, int off, int len, Hashtable headers) {
        AdInfo adInfo = null;
        boolean ifCreateConn = false;
        try {
            if (conn == null) {
                conn = inBuffer == null ? ConnectionUtil.getHttpConnection(url, "POST", headers) : ConnectionUtil.getHttpConnection(url, "POST", headers);
                ifCreateConn = true;
            }
            if (inBuffer != null) {
                OutputStream out = conn.openOutputStream();
                out.write(inBuffer, off, len);
            }
            int responseCode = conn.getResponseCode();
            System.out.println("charge responseCode = " + responseCode);
            InputStream input = conn.openInputStream();
            adInfo = CurrentCityParser.parseAdInfo(input);
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
            adInfo = new AdInfo();
        }
        finally {
            if (ifCreateConn) {
                ConnectionUtil.closeHttpConnectionQuietly(conn);
            }
        }
        return adInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized String getMessage(HttpConnection conn, String url, byte[] inBuffer, int off, int len, Hashtable headers) {
        boolean ifCreateConn = false;
        String message = "";
        try {
            if (conn == null) {
                conn = inBuffer == null ? ConnectionUtil.getHttpConnection(url, "POST", headers) : ConnectionUtil.getHttpConnection(url, "POST", headers);
                ifCreateConn = true;
            }
            if (inBuffer != null) {
                OutputStream out = conn.openOutputStream();
                out.write(inBuffer, off, len);
            }
            int responseCode = conn.getResponseCode();
            System.out.println("charge responseCode = " + responseCode);
            InputStream input = conn.openInputStream();
            message = CurrentCityParser.getMessage(input);
        }
        catch (Exception e) {
            Debug.debug("error", "com.myweather.util.ConnectionUtil", 249, e.getMessage());
        }
        finally {
            if (ifCreateConn) {
                ConnectionUtil.closeHttpConnectionQuietly(conn);
            }
        }
        return message;
    }

    public static void setHttpHeaders(HttpConnection conn, Hashtable headers) throws Exception {
        if (headers != null && !headers.isEmpty()) {
            Enumeration enu = headers.keys();
            while (enu.hasMoreElements()) {
                String key = (String)enu.nextElement();
                conn.setRequestProperty(key, (String)headers.get(key));
            }
        }
    }

    public static void closeHttpConnectionQuietly(HttpConnection conn) {
        if (conn != null) {
            try {
                conn.close();
                conn = null;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

