/*
 * Decompiled with CFR 0.152.
 */
package de.enough.polish.ui;

import de.enough.polish.ui.Choice;
import de.enough.polish.ui.ChoiceItem;
import de.enough.polish.ui.Container;
import de.enough.polish.ui.Item;
import de.enough.polish.ui.ItemCommandListener;
import de.enough.polish.ui.List;
import de.enough.polish.ui.Screen;
import de.enough.polish.ui.Style;
import de.enough.polish.util.ArrayList;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Image;

public class ChoiceGroup
extends Container
implements Choice,
ItemCommandListener {
    public static final Command MARK_COMMAND = new Command("Mark", 8, 9);
    public static final Command UNMARK_COMMAND = new Command("Unmark", 8, 10);
    private int selectedIndex;
    private boolean isMultiple;
    protected int choiceType;
    private boolean isImplicit;
    private Command selectCommand;
    private ItemCommandListener additionalItemCommandListener;
    private boolean isSelectCommandAdded;

    public ChoiceGroup(String label, int choiceType) {
        this(label, choiceType, new String[0], null, null, false);
    }

    public ChoiceGroup(String label, int choiceType, Style style) {
        this(label, choiceType, new String[0], null, style, false);
    }

    public ChoiceGroup(String label, int choiceType, String[] stringElements, Image[] imageElements) {
        this(label, choiceType, stringElements, imageElements, null, false);
    }

    public ChoiceGroup(String label, int choiceType, String[] stringElements, Image[] imageElements, Style style) {
        this(label, choiceType, stringElements, imageElements, style, false);
    }

    public ChoiceGroup(String label, int choiceType, String[] stringElements, Image[] imageElements, Style style, boolean allowImplicit) {
        this(label, choiceType, ChoiceGroup.buildChoiceItems(stringElements, imageElements, choiceType, style), style, allowImplicit);
    }

    public ChoiceGroup(String label, int choiceType, ChoiceItem[] items) {
        this(label, choiceType, items, null, false);
    }

    public ChoiceGroup(String label, int choiceType, ChoiceItem[] items, Style style) {
        this(label, choiceType, items, style, false);
    }

    public ChoiceGroup(String label, int choiceType, ChoiceItem[] items, Style style, boolean allowImplicit) {
        super(label, false, style, -1);
        if (choiceType != 1) {
            if (choiceType == 2) {
                this.isMultiple = true;
            } else if (choiceType == 3 && allowImplicit) {
                this.isImplicit = true;
                this.autoFocusEnabled = true;
            } else {
                throw new IllegalArgumentException();
            }
        }
        this.choiceType = choiceType;
        if (items != null) {
            for (int i = 0; i < items.length; ++i) {
                ChoiceItem item = items[i];
                this.append(item);
            }
        }
    }

    protected static ChoiceItem[] buildChoiceItems(String[] stringElements, Image[] imageElements, int choiceType, Style style) {
        if (imageElements != null && imageElements.length != stringElements.length) {
            throw new IllegalArgumentException();
        }
        ChoiceItem[] items = new ChoiceItem[stringElements.length];
        for (int i = 0; i < stringElements.length; ++i) {
            Image img = null;
            if (imageElements != null) {
                img = imageElements[i];
            }
            items[i] = new ChoiceItem(stringElements[i], img, choiceType, style);
        }
        return items;
    }

    public String getString(int elementNum) {
        ChoiceItem item = (ChoiceItem)this.itemsList.get(elementNum);
        return item.getText();
    }

    public Image getImage(int elementNum) {
        ChoiceItem item = (ChoiceItem)this.itemsList.get(elementNum);
        return item.getImage();
    }

    public ChoiceItem getItem(int elementNum) {
        return (ChoiceItem)this.itemsList.get(elementNum);
    }

    public int append(String stringPart, Image imagePart) {
        return this.append(stringPart, imagePart, null);
    }

    public int append(String stringPart, Image imagePart, Style elementStyle) {
        ChoiceItem item = new ChoiceItem(stringPart, imagePart, this.choiceType, elementStyle);
        return this.append(item, elementStyle);
    }

    public int append(ChoiceItem item) {
        return this.append(item, null);
    }

    public int append(ChoiceItem item, Style elementStyle) {
        this.add(item);
        if (elementStyle != null) {
            item.setStyle(elementStyle);
        }
        int itemIndex = this.itemsList.size() - 1;
        if (this.choiceType == 1 && item.isSelected) {
            if (this.selectedIndex != -1) {
                ((ChoiceItem)this.get(this.selectedIndex)).select(false);
            }
            this.selectedIndex = itemIndex;
        }
        if (this.isMultiple) {
            this.selectChoiceItem(item, item.isSelected);
            item.setItemCommandListener(this);
        }
        return itemIndex;
    }

    public void insert(int elementNum, String stringPart, Image imagePart) {
        this.insert(elementNum, stringPart, imagePart, null);
    }

    public void insert(int elementNum, String stringPart, Image imagePart, Style elementStyle) {
        ChoiceItem item = new ChoiceItem(stringPart, imagePart, this.choiceType, elementStyle);
        this.add(elementNum, item);
    }

    public void insert(int elementNum, ChoiceItem item) {
        this.add(elementNum, item);
    }

    public void insert(int elementNum, ChoiceItem item, Style elementStyle) {
        if (elementStyle != null) {
            item.setStyle(elementStyle);
        }
        this.add(elementNum, item);
    }

    public void set(int elementNum, String stringPart, Image imagePart) {
        this.set(elementNum, stringPart, imagePart, null);
    }

    public void set(int elementNum, String stringPart, Image imagePart, Style elementStyle) {
        ChoiceItem item = (ChoiceItem)this.itemsList.get(elementNum);
        item.setText(stringPart);
        if (imagePart != null) {
            item.setImage(imagePart);
        }
        if (elementStyle != null) {
            item.setStyle(elementStyle);
        }
        if (this.isInitialized) {
            this.isInitialized = false;
            this.repaint();
        }
    }

    public void delete(int elementNum) {
        this.remove(elementNum);
        if (this.selectedIndex == elementNum) {
            this.selectedIndex = -1;
        } else if (elementNum < this.selectedIndex) {
            --this.selectedIndex;
        }
    }

    public void deleteAll() {
        this.clear();
        this.selectedIndex = -1;
    }

    public boolean isSelected(int elementNum) {
        ChoiceItem item = (ChoiceItem)this.itemsList.get(elementNum);
        return item.isSelected;
    }

    public int getSelectedIndex() {
        if (this.isMultiple || this.itemsList.size() == 0) {
            return -1;
        }
        if (!this.isImplicit || this.focusedIndex == -1) {
            return this.selectedIndex;
        }
        return this.focusedIndex;
    }

    public int getSelectedFlags(boolean[] selectedArray_return) {
        if (selectedArray_return.length < this.itemsList.size()) {
            throw new IllegalArgumentException();
        }
        ChoiceItem[] myItems = (ChoiceItem[])this.itemsList.toArray(new ChoiceItem[this.itemsList.size()]);
        int selectedItems = 0;
        for (int i = 0; i < myItems.length; ++i) {
            ChoiceItem item = myItems[i];
            if (item.isSelected || this.isImplicit && i == this.focusedIndex) {
                selectedArray_return[i] = true;
                ++selectedItems;
                continue;
            }
            selectedArray_return[i] = false;
        }
        return selectedItems;
    }

    public void setSelectedIndex(int elementNum, boolean selected) {
        if (this.isMultiple) {
            ChoiceItem item = (ChoiceItem)this.itemsList.get(elementNum);
            this.selectChoiceItem(item, selected);
        } else {
            if (!selected) {
                return;
            }
            if (this.selectedIndex != -1) {
                ChoiceItem oldSelected = (ChoiceItem)this.itemsList.get(this.selectedIndex);
                oldSelected.select(false);
            }
            if (elementNum != -1) {
                ChoiceItem newSelected = (ChoiceItem)this.itemsList.get(elementNum);
                newSelected.select(true);
                if (this.isFocused) {
                    if (this.isInitialized) {
                        this.focus(elementNum, newSelected, 0);
                    } else {
                        this.autoFocusEnabled = true;
                        this.autoFocusIndex = elementNum;
                    }
                }
            }
            this.selectedIndex = elementNum;
        }
        if (this.isInitialized) {
            this.isInitialized = false;
            this.repaint();
        }
    }

    public void setSelectedFlags(boolean[] selectedArray) {
        if (selectedArray == null || selectedArray.length == 0) {
            return;
        }
        if (selectedArray.length < this.itemsList.size()) {
            throw new IllegalArgumentException();
        }
        if (this.isMultiple) {
            ChoiceItem[] myItems = (ChoiceItem[])this.itemsList.toArray(new ChoiceItem[this.itemsList.size()]);
            for (int i = 0; i < myItems.length; ++i) {
                ChoiceItem item = myItems[i];
                boolean isSelected = selectedArray[i];
                this.selectChoiceItem(item, isSelected);
            }
        } else {
            int index = 0;
            for (int i = 0; i < selectedArray.length; ++i) {
                if (!selectedArray[i]) continue;
                index = i;
                break;
            }
            if (index > this.itemsList.size()) {
                index = 0;
            }
            this.setSelectedIndex(index, true);
        }
        if (this.isInitialized) {
            this.isInitialized = false;
            this.repaint();
        }
    }

    public void setFitPolicy(int fitPolicy) {
    }

    public int getFitPolicy() {
        return 1;
    }

    public void setFont(int elementNum, Font font) {
        ChoiceItem item = (ChoiceItem)this.itemsList.get(elementNum);
        item.setPreferredFont(font);
    }

    public Font getFont(int elementNum) {
        ChoiceItem item = (ChoiceItem)this.itemsList.get(elementNum);
        Font font = item.preferredFont;
        if (font == null) {
            font = item.font;
        }
        return font;
    }

    protected String createCssSelector() {
        return "choicegroup";
    }

    public boolean isPopupClosed() {
        boolean result = false;
        return result;
    }

    protected boolean handleKeyPressed(int keyCode, int gameAction) {
        if (this.itemsList.size() == 0) {
            return super.handleKeyPressed(keyCode, gameAction);
        }
        boolean gameActionIsFire = this.getScreen().isGameActionFire(keyCode, gameAction);
        boolean processed = false;
        processed = super.handleKeyPressed(keyCode, gameAction);
        if (!processed) {
            int index;
            ChoiceItem choiceItem = (ChoiceItem)this.focusedItem;
            if (gameActionIsFire && choiceItem != null) {
                choiceItem.notifyItemPressedStart();
                return true;
            }
            if (keyCode >= 49 && keyCode <= 57 && (index = keyCode - 49) < this.itemsList.size()) {
                ChoiceItem item = this.getItem(index);
                if (item.appearanceMode != 0) {
                    this.setSelectedIndex(index, true);
                    if (this.isImplicit) {
                        Screen scr = this.getScreen();
                        if (scr != null) {
                            Command selectCmd = this.selectCommand;
                            if (selectCmd == null) {
                                selectCmd = List.SELECT_COMMAND;
                            }
                            scr.callCommandListener(selectCmd);
                        }
                    } else {
                        this.notifyStateChanged();
                    }
                    this.notifyItemPressedStart();
                    return true;
                }
            }
        }
        return processed;
    }

    protected void selectChoiceItem(ChoiceItem item, boolean isSelected) {
        item.select(isSelected);
        if (this.isMultiple) {
            if (isSelected) {
                item.removeCommand(MARK_COMMAND);
                item.setDefaultCommand(UNMARK_COMMAND);
            } else {
                item.removeCommand(UNMARK_COMMAND);
                item.setDefaultCommand(MARK_COMMAND);
            }
        }
    }

    protected boolean handleKeyReleased(int keyCode, int gameAction) {
        boolean gameActionIsFire = this.getScreen().isGameActionFire(keyCode, gameAction);
        if (gameActionIsFire) {
            ChoiceItem choiceItem = (ChoiceItem)this.focusedItem;
            if (choiceItem != null) {
                boolean isAlreadySelected = choiceItem.isSelected;
                if (this.isMultiple) {
                    this.selectChoiceItem(choiceItem, !isAlreadySelected);
                } else if (!isAlreadySelected) {
                    this.setSelectedIndex(this.focusedIndex, true);
                }
                if (!isAlreadySelected && this.choiceType != 3) {
                    this.notifyStateChanged();
                }
                if (choiceItem.isPressed) {
                    Screen scr;
                    choiceItem.notifyItemPressedEnd();
                    if (this.isImplicit && (scr = this.getScreen()) != null) {
                        Command selectCmd = this.selectCommand;
                        if (selectCmd == null) {
                            selectCmd = List.SELECT_COMMAND;
                        }
                        scr.callCommandListener(selectCmd);
                    }
                }
                if (isAlreadySelected) {
                    return false;
                }
            }
            return true;
        }
        return super.handleKeyReleased(keyCode, gameAction);
    }

    protected void setSelectCommand(Command command) {
        this.selectCommand = command;
    }

    public void setDefaultCommand(Command cmd) {
        if (this.choiceType == 2) {
            this.removeCommand(MARK_COMMAND);
        } else {
            this.removeCommand(List.SELECT_COMMAND);
            if (this.selectCommand != null) {
                this.removeCommand(this.selectCommand);
            }
        }
        if (this.additionalItemCommandListener == null) {
            this.additionalItemCommandListener = this.itemCommandListener;
        }
        this.addCommand(cmd);
        this.selectCommand = cmd;
        this.defaultCommand = cmd;
        this.itemCommandListener = this;
    }

    public void setStyle(Style style, boolean ignoreBackground) {
        super.setStyle(style, ignoreBackground);
        if (this.choiceType != 2 && this.choiceType == 1 && this.containerView == null) {
            this.addCommand(List.SELECT_COMMAND);
        }
        this.itemCommandListener = this;
    }

    public void commandAction(Command c, Item item) {
        if (item == this) {
            this.handleCommand(c);
        }
    }

    protected boolean handleCommand(Command cmd) {
        if (cmd == List.SELECT_COMMAND || cmd == MARK_COMMAND || cmd == this.selectCommand) {
            if (this.focusedIndex != -1) {
                this.setSelectedIndex(this.focusedIndex, true);
                if (this.choiceType != 3) {
                    this.notifyStateChanged();
                }
                return !this.isImplicit;
            }
        } else if (cmd == UNMARK_COMMAND) {
            if (this.focusedIndex != -1) {
                this.setSelectedIndex(this.focusedIndex, false);
                if (this.choiceType != 3) {
                    this.notifyStateChanged();
                }
                return true;
            }
        } else if (this.additionalItemCommandListener != null) {
            this.additionalItemCommandListener.commandAction(cmd, this);
            return true;
        }
        return super.handleCommand(cmd);
    }

    public void setItemCommandListener(ItemCommandListener l) {
        this.additionalItemCommandListener = l;
    }

    public void setItemsList(ArrayList itemsList) {
        this.selectedIndex = -1;
        super.setItemsList(itemsList);
    }
}

