/*
 * Decompiled with CFR 0.152.
 */
package de.enough.polish.ui;

import de.enough.polish.ui.AccessibleCanvas;
import de.enough.polish.ui.Alert;
import de.enough.polish.ui.Screen;
import de.enough.polish.ui.StyleSheet;
import de.enough.polish.util.Debug;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Graphics;

public class MasterCanvas
extends Canvas {
    public static MasterCanvas instance;
    protected AccessibleCanvas currentCanvas;
    protected Displayable currentDisplayable;
    private int screenWidth;
    private int screenHeight;

    private MasterCanvas() {
        super.setFullScreenMode(true);
    }

    protected void hideNotify() {
        if (this.currentCanvas != null) {
            this.currentCanvas.hideNotify();
        }
    }

    protected void showNotify() {
        this.setFullScreenMode(true);
        if (this.currentCanvas != null) {
            this.currentCanvas.showNotify();
            if (this.screenHeight != 0) {
                this.currentCanvas.sizeChanged(this.screenWidth, this.screenHeight);
            }
        }
    }

    protected void keyPressed(int keyCode) {
        if (this.currentCanvas != null) {
            this.currentCanvas.keyPressed(keyCode);
        }
    }

    protected void keyRepeated(int keyCode) {
        if (this.currentCanvas != null) {
            this.currentCanvas.keyRepeated(keyCode);
        }
    }

    protected void keyReleased(int keyCode) {
        if (this.currentCanvas != null) {
            this.currentCanvas.keyReleased(keyCode);
        }
    }

    protected void sizeChanged(int width, int height) {
        this.screenHeight = height;
        this.screenWidth = width;
        if (this.currentCanvas != null) {
            this.currentCanvas.sizeChanged(width, height);
        }
    }

    public static int getScreenHeight() {
        int h = 0;
        if (instance != null && (h = MasterCanvas.instance.screenHeight) == 0) {
            h = instance.getHeight();
        }
        return h;
    }

    public static int getScreenWidth() {
        int w = 0;
        if (instance != null && (w = MasterCanvas.instance.screenWidth) == 0) {
            w = instance.getWidth();
        }
        return w;
    }

    protected void paint(Graphics g) {
        if (this.currentCanvas != null) {
            this.currentCanvas.paint(g);
        }
    }

    public static void setCurrent(Display display, Displayable nextDisplayable) {
        if (nextDisplayable == null) {
            display.setCurrent(null);
            return;
        }
        if (instance != null && MasterCanvas.instance.currentCanvas == nextDisplayable) {
            instance.repaint();
            return;
        }
        if (!(nextDisplayable instanceof AccessibleCanvas)) {
            if (instance != null && MasterCanvas.instance.currentCanvas != null && MasterCanvas.instance.currentDisplayable != nextDisplayable) {
                MasterCanvas.instance.currentCanvas.hideNotify();
                MasterCanvas.instance.currentCanvas = null;
                MasterCanvas.instance.currentDisplayable = null;
            }
            display.setCurrent(nextDisplayable);
            return;
        }
        AccessibleCanvas oldCanvas = null;
        if (instance == null) {
            instance = new MasterCanvas();
        } else {
            oldCanvas = MasterCanvas.instance.currentCanvas;
        }
        AccessibleCanvas canvas = (AccessibleCanvas)nextDisplayable;
        if (nextDisplayable instanceof Alert && MasterCanvas.instance.currentDisplayable != nextDisplayable) {
            Alert alert = (Alert)nextDisplayable;
            if (alert.nextDisplayable == null) {
                Displayable displayable = alert.nextDisplayable = MasterCanvas.instance.currentDisplayable != null ? MasterCanvas.instance.currentDisplayable : display.getCurrent();
            }
        }
        if (instance.isShown()) {
            canvas.showNotify();
            if (MasterCanvas.instance.screenHeight != 0) {
                canvas.sizeChanged(MasterCanvas.instance.screenWidth, MasterCanvas.instance.screenHeight);
            }
        }
        MasterCanvas.instance.currentCanvas = canvas;
        MasterCanvas.instance.currentDisplayable = nextDisplayable;
        if (oldCanvas != null) {
            oldCanvas.hideNotify();
        }
        if (StyleSheet.currentScreen != nextDisplayable && !(nextDisplayable instanceof Screen)) {
            StyleSheet.currentScreen = null;
        }
        if (!instance.isShown()) {
            display.setCurrent((Displayable)instance);
        } else {
            instance.repaint();
        }
    }

    public static Displayable getCurrent(Display display) {
        if (instance != null) {
            return MasterCanvas.instance.currentDisplayable;
        }
        return display.getCurrent();
    }

    public static void repaintAccessibleCanvas(AccessibleCanvas canvas) {
        if (canvas == null) {
            Debug.debug("warn", "de.enough.polish.ui.MasterCanvas", 418, "MasterCanvas: repaintAccessibleCanvas got [null] canvas.");
            return;
        }
        if (instance != null) {
            instance.repaint();
        } else {
            ((Canvas)canvas).repaint();
        }
    }

    public static void repaintCanvas(Canvas canvas) {
        if (canvas == null) {
            Debug.debug("warn", "de.enough.polish.ui.MasterCanvas", 437, "MasterCanvas: repaintCanvas got [null] canvas.");
            return;
        }
        if (!(canvas instanceof AccessibleCanvas)) {
            canvas.repaint();
        } else if (instance != null) {
            instance.repaint();
        } else {
            canvas.repaint();
        }
    }

    public static void repaintCanvas(Canvas canvas, int x, int y, int width, int height) {
        if (canvas == null) {
            Debug.debug("warn", "de.enough.polish.ui.MasterCanvas", 462, "MasterCanvas: repaintCanvas got [null] canvas.");
            return;
        }
        if (!(canvas instanceof AccessibleCanvas)) {
            canvas.repaint(x, y, width, height);
        } else if (instance != null) {
            instance.repaint(x, y, width, height);
        } else {
            canvas.repaint(x, y, width, height);
        }
    }

    public static boolean isAccessibleCanvasShown(AccessibleCanvas canvas) {
        if (instance != null) {
            return canvas == MasterCanvas.instance.currentCanvas;
        }
        return ((Canvas)canvas).isShown();
    }

    public static boolean isCanvasShown(Canvas canvas) {
        if (instance != null && instance.isShown()) {
            return canvas == MasterCanvas.instance.currentDisplayable;
        }
        return canvas.isShown();
    }

    public static boolean isDisplayableShown(Displayable displayable) {
        if (instance != null && instance.isShown()) {
            return displayable == MasterCanvas.instance.currentDisplayable;
        }
        return displayable.isShown();
    }
}

