/*
 * Decompiled with CFR 0.152.
 */
package de.enough.polish.ui;

import de.enough.polish.ui.Item;
import de.enough.polish.ui.Style;
import javax.microedition.lcdui.Graphics;

public class ScrollBar
extends Item {
    private static final int MODE_AREA = 0;
    private static final int MODE_ITEM = 1;
    private static final int MODE_PAGE = 2;
    protected int sliderColor;
    protected int sliderWidth = 2;
    protected boolean hideSlider = true;
    protected int sliderY;
    protected int sliderHeight;
    protected int scrollBarHeight;
    private int startOpacity = 255;
    private boolean isVisible;
    protected boolean overlap;
    private int screenAvailableContentHeight;
    private int screenActualContentHeight;
    private boolean isPointerDraggedHandled;
    private boolean isPointerPressedHandled;

    public ScrollBar() {
    }

    public ScrollBar(Style style) {
        super(style);
    }

    public int initScrollBar(int screenWidth, int screenAvailableHeight, int screenContentHeight, int contentYOffset, int selectionStart, int selectionHeight, int focusedIndex, int numberOfItems) {
        this.screenActualContentHeight = screenContentHeight;
        this.screenAvailableContentHeight = screenAvailableHeight;
        if (screenAvailableHeight >= screenContentHeight) {
            this.isVisible = false;
            return 0;
        }
        int lastSliderY = this.sliderY;
        int lastSliderHeight = this.sliderHeight;
        this.isVisible = true;
        this.scrollBarHeight = screenAvailableHeight;
        this.sliderY = -contentYOffset * screenAvailableHeight / screenContentHeight;
        this.sliderHeight = screenAvailableHeight * screenAvailableHeight / screenContentHeight;
        if (!this.isInitialized || this.scrollBarHeight != this.itemHeight) {
            this.init(screenWidth, screenWidth);
        }
        this.itemHeight = this.scrollBarHeight;
        if (lastSliderY != this.sliderY || lastSliderHeight != this.sliderHeight) {
            this.opacityRgbData = null;
            this.opacity = this.startOpacity;
        }
        return this.itemWidth;
    }

    public void resetAnimation() {
        this.opacity = this.startOpacity;
    }

    public boolean animate() {
        boolean animated = false;
        int[] rgbData = this.opacityRgbData;
        if (this.overlap && rgbData != null && this.opacity > 0) {
            this.opacity -= 10;
            if (this.opacity <= 0) {
                this.opacity = 0;
            } else {
                int alpha = this.opacity << 24;
                for (int i = 0; i < rgbData.length; ++i) {
                    rgbData[i] = rgbData[i] & 0xFFFFFF | alpha;
                }
            }
            animated = true;
        }
        return animated | super.animate();
    }

    protected void initContent(int firstLineWidth, int lineWidth) {
        this.contentWidth = this.sliderWidth;
        this.contentHeight = this.scrollBarHeight - (this.paddingTop + this.paddingBottom + this.marginTop + this.marginBottom + (this.borderWidth << 1));
    }

    public void paint(int x, int y, int leftBorder, int rightBorder, Graphics g) {
        if (!this.isVisible) {
            return;
        }
        super.paint(x, y, leftBorder, rightBorder, g);
    }

    protected void paintContent(int x, int y, int leftBorder, int rightBorder, Graphics g) {
        g.setColor(this.sliderColor);
        g.fillRect(x, y + this.sliderY, this.sliderWidth, this.sliderHeight);
    }

    protected String createCssSelector() {
        return "scrollbar";
    }

    public void setStyle(Style style) {
        Boolean fadeOutBool;
        Integer opacityInt;
        Integer sliderColorInt;
        super.setStyle(style);
        Integer sliderWidthInt = style.getIntProperty(119);
        if (sliderWidthInt != null) {
            this.sliderWidth = sliderWidthInt;
        }
        if ((sliderColorInt = style.getIntProperty(120)) != null) {
            this.sliderColor = sliderColorInt;
        }
        if ((opacityInt = style.getIntProperty(31)) != null) {
            this.startOpacity = opacityInt;
        }
        if ((fadeOutBool = style.getBooleanProperty(303)) != null) {
            this.overlap = fadeOutBool;
        }
    }
}

