/*
 * Decompiled with CFR 0.152.
 */
package de.enough.polish.ui;

import de.enough.polish.ui.ChoiceGroup;
import de.enough.polish.ui.ChoiceItem;
import de.enough.polish.ui.ClippingRegion;
import de.enough.polish.ui.Container;
import de.enough.polish.ui.IconItem;
import de.enough.polish.ui.Item;
import de.enough.polish.ui.List;
import de.enough.polish.ui.MasterCanvas;
import de.enough.polish.ui.Screen;
import de.enough.polish.ui.Style;
import de.enough.polish.util.ArrayList;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class TabbedList
extends Screen {
    private static final int TAB_POSITION_TOP = 0;
    private static final int TAB_POSITION_BOTTOM = 1;
    public static Command SELECT_COMMAND = List.SELECT_COMMAND;
    private final Container tabTitles;
    private final ArrayList tabContainers;
    private int defaultListType;
    private int currentTabIndex;
    private int tabTitlePosition = 1;
    private Command selectCommand = SELECT_COMMAND;

    public TabbedList(String title, int defaultListType) {
        this(title, defaultListType, null);
    }

    public TabbedList(String title, int defaultListType, Style style) {
        super(title, false, style);
        this.defaultListType = defaultListType;
        this.tabTitles = new Container(true);
        this.tabTitles.screen = this;
        this.tabContainers = new ArrayList();
        if (SELECT_COMMAND != null) {
            this.addCommand(SELECT_COMMAND);
        }
    }

    public int appendTab(javax.microedition.lcdui.Item item) {
        return -1;
    }

    public int appendTab(String text, Image icon) {
        return this.appendTab(new IconItem(text, icon), this.defaultListType, null);
    }

    public int appendTab(String text, Image icon, Style style) {
        return this.appendTab(new IconItem(text, icon, style), this.defaultListType, null);
    }

    public int appendTab(Item item) {
        return this.appendTab(item, this.defaultListType, null);
    }

    public int appendTab(Item item, Style style) {
        return this.appendTab(item, this.defaultListType, style);
    }

    public int appendTab(Item item, int tabListType, Style style) {
        this.tabTitles.add(item);
        if (style != null) {
            item.setStyle(style);
        }
        ChoiceGroup tabContainer = new ChoiceGroup(null, tabListType, null, null, true);
        tabContainer.screen = this;
        this.tabContainers.add(tabContainer);
        if (this.container == null) {
            this.container = tabContainer;
        }
        return this.tabTitles.size() - 1;
    }

    public void deleteTab(int tabIndex) {
        this.tabContainers.remove(tabIndex);
        this.tabTitles.remove(tabIndex);
        if (tabIndex == this.currentTabIndex && this.tabContainers.size() != 0) {
            if (tabIndex == this.tabContainers.size()) {
                --tabIndex;
            }
            this.setCurrentTab(tabIndex);
        }
    }

    public void setCurrentTab(int tabIndex) {
        if (this.container != null) {
            this.container.hideNotify();
        }
        this.tabTitles.focus(tabIndex);
        ChoiceGroup group = this.getTab(tabIndex);
        this.container = group;
        this.currentTabIndex = tabIndex;
        group.setScrollHeight(this.contentHeight);
        if (group.style == null) {
            group.setStyle(this.style, true);
        }
        group.isFocused = true;
        group.showNotify();
        MasterCanvas.repaintCanvas(this);
    }

    public void setTabStyle(int tabIndex) {
    }

    public void setTabStyle(int tabIndex, Style style) {
        ((Item)this.tabContainers.get(tabIndex)).setStyle(style);
    }

    public ChoiceGroup getTab(int tabIndex) {
        return (ChoiceGroup)this.tabContainers.get(tabIndex);
    }

    public int getTabNumber() {
        return this.tabTitles.size();
    }

    public void setSelectCommand(Command selectCommand) {
        if (this.selectCommand != null) {
            this.removeCommand(this.selectCommand);
        }
        if (selectCommand != null) {
            this.addCommand(selectCommand);
        }
        this.selectCommand = selectCommand;
    }

    protected void calculateContentArea(int x, int y, int width, int height) {
        super.calculateContentArea(x, y, width, height);
        if (this.tabTitlePosition == 0) {
            this.tabTitles.relativeY = this.contentY;
            this.contentY += this.tabTitles.getItemHeight(this.contentWidth, this.contentWidth);
        } else {
            this.tabTitles.relativeY = this.contentY + this.contentHeight - this.tabTitles.getItemHeight(this.contentWidth, this.contentWidth);
        }
        this.contentHeight -= this.tabTitles.itemHeight;
        this.tabTitles.relativeX = this.contentX;
        if (this.container != null) {
            this.container.setScrollHeight(this.contentHeight);
        }
    }

    protected boolean handleKeyPressed(int keyCode, int gameAction) {
        boolean handled;
        if ((gameAction == 2 || gameAction == 5) && (handled = this.tabTitles.handleKeyPressed(keyCode, gameAction))) {
            this.setCurrentTab(this.tabTitles.getFocusedIndex());
            return true;
        }
        handled = super.handleKeyPressed(keyCode, gameAction);
        if (!handled && this.isGameActionFire(keyCode, gameAction) && ((ChoiceGroup)this.container).choiceType == 3) {
            Command command = this.selectCommand;
            if (command == null && (command = SELECT_COMMAND) == null) {
                command = List.SELECT_COMMAND;
            }
            this.callCommandListener(command);
            handled = true;
        }
        return handled;
    }

    protected void paintScreen(Graphics g) {
        this.tabTitles.paint(this.tabTitles.relativeX, this.tabTitles.relativeY, this.contentX, this.contentX + this.contentWidth, g);
        super.paintScreen(g);
    }

    public void setStyle(Style style) {
        super.setStyle(style);
    }

    public void animate(long currentTime, ClippingRegion repaintRegion) {
        super.animate(currentTime, repaintRegion);
        this.tabTitles.animate(currentTime, repaintRegion);
    }

    protected Item[] getRootItems() {
        return new Item[]{this.tabTitles};
    }

    public void hideNotify() {
        super.hideNotify();
        this.tabTitles.hideNotify();
    }

    protected String createCssSelector() {
        return "tabbedlist";
    }

    public int size(int tabIndex) {
        return this.getTab(tabIndex).size();
    }

    public String getString(int tabIndex, int elementNum) {
        return this.getTab(tabIndex).getString(elementNum);
    }

    public Image getImage(int tabIndex, int elementNum) {
        return this.getTab(tabIndex).getImage(elementNum);
    }

    public int append(int tabIndex, String stringPart, Image imagePart) {
        return this.append(tabIndex, new ChoiceItem(stringPart, imagePart, this.defaultListType, null), null);
    }

    public int append(int tabIndex, String stringPart, Image imagePart, Style style) {
        return this.append(tabIndex, new ChoiceItem(stringPart, imagePart, this.defaultListType, style), null);
    }

    private int append(int tabIndex, ChoiceItem item) {
        return this.append(tabIndex, item, null);
    }

    private int append(int tabIndex, ChoiceItem item, Style style) {
        ChoiceGroup group = this.getTab(tabIndex);
        item.setChoiceType(group.choiceType);
        return group.append(item, style);
    }

    public void insert(int tabIndex, int elementNum, String stringPart, Image imagePart) {
        this.insert(tabIndex, elementNum, new ChoiceItem(stringPart, imagePart, this.defaultListType, null), null);
    }

    public void insert(int tabIndex, int elementNum, String stringPart, Image imagePart, Style style) {
        this.insert(tabIndex, elementNum, new ChoiceItem(stringPart, imagePart, this.defaultListType, style), null);
    }

    public void insert(int tabIndex, int elementNum, ChoiceItem item, Style style) {
        this.getTab(tabIndex).insert(elementNum, item, style);
    }

    public void delete(int tabIndex, int elementNum) {
        this.getTab(tabIndex).delete(elementNum);
    }

    public void deleteAll(int tabIndex) {
        this.getTab(tabIndex).deleteAll();
    }

    public void set(int tabIndex, int elementNum, String stringPart, Image imagePart) {
        this.set(tabIndex, elementNum, new ChoiceItem(stringPart, imagePart, this.defaultListType, null), null);
    }

    public void set(int tabIndex, int elementNum, String stringPart, Image imagePart, Style elementStyle) {
        this.set(tabIndex, elementNum, new ChoiceItem(stringPart, imagePart, this.defaultListType, elementStyle), null);
    }

    public void set(int tabIndex, int elementNum, ChoiceItem item) {
        this.set(tabIndex, elementNum, item, null);
    }

    public void set(int tabIndex, int elementNum, ChoiceItem item, Style elementStyle) {
        ChoiceGroup group = this.getTab(tabIndex);
        item.setChoiceType(group.choiceType);
        group.set(elementNum, item, elementStyle);
    }

    public boolean isSelected(int tabIndex, int elementNum) {
        return this.getTab(tabIndex).isSelected(elementNum);
    }

    public int getSelectedIndex(int tabIndex) {
        return this.getTab(tabIndex).getSelectedIndex();
    }

    public int getSelectedFlags(int tabIndex, boolean[] selectedArray_return) {
        return this.getTab(tabIndex).getSelectedFlags(selectedArray_return);
    }

    public void setSelectedIndex(int tabIndex, int elementNum, boolean selected) {
        this.getTab(tabIndex).setSelectedIndex(elementNum, selected);
    }

    public void setSelectedFlags(int tabIndex, boolean[] selectedArray) {
        this.getTab(tabIndex).setSelectedFlags(selectedArray);
    }

    public int getCurrentTabIndex() {
        return this.currentTabIndex;
    }
}

