/*
 * Decompiled with CFR 0.152.
 */
package de.enough.polish.ui.backgrounds;

import de.enough.polish.io.Serializer;
import de.enough.polish.ui.Background;
import de.enough.polish.ui.Color;
import de.enough.polish.ui.Point;
import de.enough.polish.util.DrawUtil;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import javax.microedition.lcdui.Graphics;

public class PolygonBackground
extends Background {
    public static final int MODE_NO_SCALE = 0;
    public static final int MODE_SCALE = 1;
    public static final int MODE_SCALE_PROPORTIONAL = 2;
    public static final int MODE_SCALE_PROPORTIONAL_EXPAND = 3;
    private int color;
    private Color colorObj;
    private Point[] points;
    private int scalingMode;
    private int[] xPoints;
    private int[] yPoints;
    private int referenceWidth;
    private int referenceHeight;
    private int lastY;
    private int lastX;
    private int lastWidth;
    private int lastHeight;
    private int anchor;

    public PolygonBackground(int color, Point[] points, int referenceWidth, int referenceHeight, int scalingMode, int anchor) {
        this(null, points, referenceWidth, referenceHeight, scalingMode, anchor);
        this.color = color;
    }

    public PolygonBackground(Color color, Point[] points, int referenceWidth, int referenceHeight, int scalingMode, int anchor) {
        this.colorObj = color;
        this.points = points;
        this.referenceWidth = referenceWidth;
        this.referenceHeight = referenceHeight;
        this.scalingMode = scalingMode;
        this.anchor = anchor;
    }

    private int[] getPoints(int start, Point[] myPoints, int[] scalarPoints, int available, int max, boolean isX) {
        int reference;
        int n = reference = isX ? this.referenceWidth : this.referenceHeight;
        if (scalarPoints == null) {
            scalarPoints = new int[myPoints.length];
        }
        for (int i = 0; i < scalarPoints.length; ++i) {
            int value = isX ? myPoints[i].x : myPoints[i].y;
            scalarPoints[i] = max == 0 ? start + value : start + value * max / reference;
        }
        return scalarPoints;
    }

    public void paint(int x, int y, int width, int height, Graphics g) {
        if (this.colorObj != null) {
            this.color = this.colorObj.getColor();
            this.colorObj = null;
        }
        if (x != this.lastX || y != this.lastY || width != this.lastWidth || height != this.lastHeight || this.xPoints == null) {
            int maxWidth = width;
            int maxHeight = height;
            switch (this.scalingMode) {
                case 0: {
                    maxWidth = 0;
                    maxHeight = 0;
                    break;
                }
                case 1: {
                    break;
                }
                case 2: {
                    maxHeight = maxWidth = Math.min(width, height);
                    break;
                }
                case 3: {
                    maxHeight = maxWidth = Math.max(width, height);
                }
            }
            int startX = x;
            if ((this.anchor & 1) == 1) {
                startX = maxWidth == 0 ? (startX += width - this.referenceWidth >> 1) : (startX += width - maxWidth >> 1);
            } else if ((this.anchor & 8) == 8) {
                startX = maxWidth == 0 ? (startX += width - this.referenceWidth) : (startX += width - maxWidth);
            }
            int startY = y;
            if ((this.anchor & 2) == 2) {
                startY = maxHeight == 0 ? (startY += height - this.referenceHeight >> 1) : (startY += height - maxHeight >> 1);
            } else if ((this.anchor & 0x20) == 32) {
                startY = maxHeight == 0 ? (startY += height - this.referenceHeight) : (startY += height - maxHeight);
            }
            this.xPoints = this.getPoints(startX, this.points, this.xPoints, width, maxWidth, true);
            this.yPoints = this.getPoints(startY, this.points, this.yPoints, height, maxHeight, false);
            this.lastX = x;
            this.lastY = y;
            this.lastWidth = width;
            this.lastHeight = height;
        }
        DrawUtil.fillPolygon(this.xPoints, this.yPoints, this.color, g);
    }

    public PolygonBackground() {
    }

    public void read(DataInputStream dataInputStream) throws IOException {
        int n;
        int n2;
        super.read(dataInputStream);
        this.anchor = dataInputStream.readInt();
        this.color = dataInputStream.readInt();
        this.colorObj = (Color)Serializer.deserialize(dataInputStream);
        this.lastHeight = dataInputStream.readInt();
        this.lastWidth = dataInputStream.readInt();
        this.lastX = dataInputStream.readInt();
        this.lastY = dataInputStream.readInt();
        if (dataInputStream.readBoolean()) {
            n2 = dataInputStream.readInt();
            this.points = new Point[n2];
            n = 0;
            while (n < n2) {
                this.points[n] = (Point)Serializer.deserialize(dataInputStream);
                ++n;
            }
        }
        this.referenceHeight = dataInputStream.readInt();
        this.referenceWidth = dataInputStream.readInt();
        this.scalingMode = dataInputStream.readInt();
        if (dataInputStream.readBoolean()) {
            n2 = dataInputStream.readInt();
            this.xPoints = new int[n2];
            n = 0;
            while (n < n2) {
                this.xPoints[n] = dataInputStream.readInt();
                ++n;
            }
        }
        if (dataInputStream.readBoolean()) {
            n2 = dataInputStream.readInt();
            this.yPoints = new int[n2];
            n = 0;
            while (n < n2) {
                this.yPoints[n] = dataInputStream.readInt();
                ++n;
            }
        }
    }

    public void write(DataOutputStream dataOutputStream) throws IOException {
        int n;
        int n2;
        super.write(dataOutputStream);
        dataOutputStream.writeInt(this.anchor);
        dataOutputStream.writeInt(this.color);
        Serializer.serialize(this.colorObj, dataOutputStream);
        dataOutputStream.writeInt(this.lastHeight);
        dataOutputStream.writeInt(this.lastWidth);
        dataOutputStream.writeInt(this.lastX);
        dataOutputStream.writeInt(this.lastY);
        if (this.points == null) {
            dataOutputStream.writeBoolean(false);
        } else {
            dataOutputStream.writeBoolean(true);
            n2 = this.points.length;
            dataOutputStream.writeInt(n2);
            n = 0;
            while (n < n2) {
                Serializer.serialize(this.points[n], dataOutputStream);
                ++n;
            }
        }
        dataOutputStream.writeInt(this.referenceHeight);
        dataOutputStream.writeInt(this.referenceWidth);
        dataOutputStream.writeInt(this.scalingMode);
        if (this.xPoints == null) {
            dataOutputStream.writeBoolean(false);
        } else {
            dataOutputStream.writeBoolean(true);
            n2 = this.xPoints.length;
            dataOutputStream.writeInt(n2);
            n = 0;
            while (n < n2) {
                dataOutputStream.writeInt(this.xPoints[n]);
                ++n;
            }
        }
        if (this.yPoints == null) {
            dataOutputStream.writeBoolean(false);
        } else {
            dataOutputStream.writeBoolean(true);
            n2 = this.yPoints.length;
            dataOutputStream.writeInt(n2);
            n = 0;
            while (n < n2) {
                dataOutputStream.writeInt(this.yPoints[n]);
                ++n;
            }
        }
    }
}

