/*
 * Decompiled with CFR 0.152.
 */
package de.enough.polish.ui.backgrounds;

import de.enough.polish.ui.Background;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import javax.microedition.lcdui.Graphics;

public class RoundTabBackground
extends Background {
    private int color;
    private int arcWidth;
    private int arcHeight;

    public RoundTabBackground(int color, int arcWidth, int arcHeight) {
        this.color = color;
        this.arcWidth = arcWidth;
        this.arcHeight = arcHeight;
    }

    public void paint(int x, int y, int width, int height, Graphics g) {
        g.setColor(this.color);
        g.fillRoundRect(x, y, width, height, this.arcWidth, this.arcHeight);
        y += height / 2;
        height = (height & 1) == 1 ? height / 2 + 1 : (height /= 2);
        g.fillRect(x, y, width, height + 1);
    }

    public RoundTabBackground() {
    }

    public void read(DataInputStream dataInputStream) throws IOException {
        super.read(dataInputStream);
        this.arcHeight = dataInputStream.readInt();
        this.arcWidth = dataInputStream.readInt();
        this.color = dataInputStream.readInt();
    }

    public void write(DataOutputStream dataOutputStream) throws IOException {
        super.write(dataOutputStream);
        dataOutputStream.writeInt(this.arcHeight);
        dataOutputStream.writeInt(this.arcWidth);
        dataOutputStream.writeInt(this.color);
    }
}

