/*
 * Decompiled with CFR 0.152.
 */
package de.enough.polish.ui.screenanimations;

import de.enough.polish.ui.ScreenChangeAnimation;
import de.enough.polish.ui.Style;
import de.enough.polish.util.DrawUtil;
import javax.microedition.lcdui.Graphics;

public class BwToColorScreenChangeAnimation
extends ScreenChangeAnimation {
    private int[] currentScreenRgb;
    private int steps = 5;
    private int currentStep;

    public BwToColorScreenChangeAnimation() {
        this.useNextCanvasRgb = true;
    }

    protected void setStyle(Style style) {
        super.setStyle(style);
        this.currentScreenRgb = new int[this.screenWidth * this.screenHeight];
        for (int i = 0; i < this.currentScreenRgb.length; ++i) {
            int color = this.nextCanvasRgb[i];
            int red = 0xFF & color >>> 16;
            int green = 0xFF & color >>> 8;
            int blue = color & 0xFF;
            int brightness = (red + green + blue) / 3;
            this.currentScreenRgb[i] = brightness > 127 ? 0xFFFFFF : 0;
        }
        this.currentStep = 0;
    }

    protected boolean animate() {
        if (this.currentStep < this.steps) {
            int permille = 1000 * this.currentStep / this.steps;
            for (int i = 0; i < this.currentScreenRgb.length; ++i) {
                int currentColor = this.currentScreenRgb[i];
                int targetColor = this.nextCanvasRgb[i];
                if (currentColor == targetColor) continue;
                this.currentScreenRgb[i] = DrawUtil.getGradientColor(currentColor, targetColor, permille);
            }
            ++this.currentStep;
            return true;
        }
        this.currentScreenRgb = null;
        this.nextCanvasRgb = null;
        this.currentStep = 0;
        return false;
    }

    public void paintAnimation(Graphics g) {
        g.drawRGB(this.currentScreenRgb, 0, this.screenWidth, 0, 0, this.screenWidth, this.screenHeight, false);
    }
}

