/*
 * Decompiled with CFR 0.152.
 */
package de.enough.polish.ui.texteffects;

import de.enough.polish.io.Serializer;
import de.enough.polish.ui.Style;
import de.enough.polish.ui.TextEffect;
import de.enough.polish.util.ImageUtil;
import de.enough.polish.util.RgbImage;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;

public class RotatingTextEffect
extends TextEffect {
    private String lastText;
    private int angle;
    private transient RgbImage rotatedImage;
    private int xPos;
    private int yPos;
    private int startAngle = 0;
    private int endAngle = 360;
    private int steps = 4;
    private int[] originalRgbData;
    private int rotatedWidthHeight;
    private int originalHeight;
    private int originalWidth;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void drawString(String text, int textColor, int x, int y, int orientation, Graphics g) {
        RotatingTextEffect rotatingTextEffect = this;
        synchronized (rotatingTextEffect) {
            if (text != this.lastText) {
                Font font = g.getFont();
                this.rotate(text, textColor, font, this.startAngle);
                this.lastText = text;
                this.xPos = this.getLeftX(x, orientation, this.rotatedImage.getWidth());
                this.yPos = this.getTopY(y, orientation, this.rotatedImage.getHeight(), font.getBaselinePosition() * this.rotatedImage.getHeight() / font.getHeight());
            }
            this.rotatedImage.paint(this.xPos, this.yPos, g);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean animate() {
        if (this.originalRgbData == null) {
            return false;
        }
        RotatingTextEffect rotatingTextEffect = this;
        synchronized (rotatingTextEffect) {
            this.angle += this.steps;
            if (this.angle > this.endAngle) {
                this.angle = this.startAngle;
            }
            this.rotate();
            return true;
        }
    }

    private void rotate(String text, int textColor, Font font, int currentAngle) {
        this.angle = currentAngle;
        int[] rgbData = this.originalRgbData = RotatingTextEffect.getRgbData(text, textColor, font);
        this.originalHeight = font.getHeight();
        this.originalWidth = rgbData.length / this.originalHeight;
        this.rotatedWidthHeight = (int)Math.sqrt(this.originalHeight * this.originalHeight + this.originalWidth * this.originalWidth);
        this.rotatedImage = new RgbImage(this.rotatedWidthHeight, this.rotatedWidthHeight, 0, true);
        this.rotate();
    }

    private void rotate() {
        int referenceX = this.originalWidth / 2;
        int referenceY = this.originalHeight / 2;
        int backgroundColor = 0;
        double degreeCos = Math.cos(Math.PI * (double)this.angle / 180.0);
        double degreeSin = Math.sin(Math.PI * (double)this.angle / 180.0);
        ImageUtil.rotate(this.originalRgbData, this.originalWidth, this.originalHeight, referenceX, referenceY, backgroundColor, degreeCos, degreeSin, this.rotatedImage.getRgbData(), this.rotatedImage.getWidth(), this.rotatedImage.getHeight());
    }

    public void releaseResources() {
        super.releaseResources();
        this.lastText = null;
        this.rotatedImage = null;
        this.originalRgbData = null;
    }

    public void setAngle(int angle) {
        this.releaseResources();
        this.angle = angle;
    }

    public void setStyle(Style style) {
        super.setStyle(style);
        this.lastText = null;
    }

    public void read(DataInputStream dataInputStream) throws IOException {
        super.read(dataInputStream);
        this.angle = dataInputStream.readInt();
        this.endAngle = dataInputStream.readInt();
        this.lastText = (String)Serializer.deserialize(dataInputStream);
        this.originalHeight = dataInputStream.readInt();
        if (dataInputStream.readBoolean()) {
            int n = dataInputStream.readInt();
            this.originalRgbData = new int[n];
            int n2 = 0;
            while (n2 < n) {
                this.originalRgbData[n2] = dataInputStream.readInt();
                ++n2;
            }
        }
        this.originalWidth = dataInputStream.readInt();
        this.rotatedWidthHeight = dataInputStream.readInt();
        this.startAngle = dataInputStream.readInt();
        this.steps = dataInputStream.readInt();
        this.xPos = dataInputStream.readInt();
        this.yPos = dataInputStream.readInt();
    }

    public void write(DataOutputStream dataOutputStream) throws IOException {
        super.write(dataOutputStream);
        dataOutputStream.writeInt(this.angle);
        dataOutputStream.writeInt(this.endAngle);
        Serializer.serialize(this.lastText, dataOutputStream);
        dataOutputStream.writeInt(this.originalHeight);
        if (this.originalRgbData == null) {
            dataOutputStream.writeBoolean(false);
        } else {
            dataOutputStream.writeBoolean(true);
            int n = this.originalRgbData.length;
            dataOutputStream.writeInt(n);
            int n2 = 0;
            while (n2 < n) {
                dataOutputStream.writeInt(this.originalRgbData[n2]);
                ++n2;
            }
        }
        dataOutputStream.writeInt(this.originalWidth);
        dataOutputStream.writeInt(this.rotatedWidthHeight);
        dataOutputStream.writeInt(this.startAngle);
        dataOutputStream.writeInt(this.steps);
        dataOutputStream.writeInt(this.xPos);
        dataOutputStream.writeInt(this.yPos);
    }
}

