/*
 * Decompiled with CFR 0.152.
 */
package de.enough.polish.ui.texteffects;

import de.enough.polish.io.Serializer;
import de.enough.polish.ui.Style;
import de.enough.polish.ui.TextEffect;
import de.enough.polish.util.DrawUtil;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class VerticalMirrorTextEffect
extends TextEffect {
    private static final int CLEAR_COLOR = -16776925;
    private int shadowColor;
    private int padding;
    private int steps;
    private int startTranslucency;
    private int endTranslucency;
    private int[] rgbData;
    private int rgbWidth;
    private int rgbHeight;
    private transient Graphics bufferGraphics;
    private transient Image bufferImage;
    private int clearColor;
    private String lastText;

    private void prepareRgbBuffer(int width, int height) {
        Image image;
        this.rgbWidth = width;
        this.rgbHeight = height;
        this.bufferImage = image = Image.createImage((int)width, (int)height);
        Graphics bufferG = image.getGraphics();
        bufferG.setColor(-16776925);
        bufferG.fillRect(0, 0, width + 1, height + 1);
        this.bufferGraphics = bufferG;
        int[] clearColorArray = new int[1];
        image.getRGB(clearColorArray, 0, 1, 0, 0, 1, 1);
        this.clearColor = clearColorArray[0];
    }

    public void drawString(String text, int textColor, int x, int y, int orientation, Graphics g) {
        g.drawString(text, x, y, orientation);
        Font font = g.getFont();
        int fontHeight = font.getHeight();
        if (text == this.lastText) {
            if ((orientation & 8) == 8) {
                x -= this.rgbWidth;
            } else if ((orientation & 1) == 1) {
                x -= this.rgbWidth / 2;
            }
            DrawUtil.drawRgb(this.rgbData, x, y + fontHeight + this.padding, this.rgbWidth, this.rgbHeight, true, g);
            return;
        }
        int width = font.stringWidth(text);
        int height = this.steps;
        this.prepareRgbBuffer(width, height);
        this.bufferGraphics.setFont(font);
        this.bufferGraphics.setColor(this.shadowColor);
        for (int i = 0; i < this.steps; ++i) {
            this.bufferGraphics.setClip(0, i, width, 1);
            this.bufferGraphics.drawString(text, 0, -fontHeight + i * 2 + 1, 20);
        }
        int[] translucencies = DrawUtil.getGradient(this.startTranslucency, this.endTranslucency, height);
        int[] data = new int[width * height];
        this.bufferImage.getRGB(data, 0, width, 0, 0, width, height);
        for (int row = 0; row < height; ++row) {
            int translucency = translucencies[row] << 24 | 0xFFFFFF;
            for (int column = 0; column < width; ++column) {
                int index = row * width + column;
                int color = data[index];
                data[index] = color == this.clearColor ? 0 : color & translucency;
            }
        }
        if ((orientation & 8) == 8) {
            x -= width;
        } else if ((orientation & 1) == 1) {
            x -= width / 2;
        }
        DrawUtil.drawRgb(data, x, y + fontHeight + this.padding, width, height, true, g);
        this.rgbData = data;
        this.lastText = text;
        this.bufferImage = null;
        this.bufferGraphics = null;
    }

    public void setStyle(Style style) {
        super.setStyle(style);
        this.lastText = null;
        this.shadowColor = style.getFontColor();
        Font font = style.font;
        if (font == null) {
            font = Font.getDefaultFont();
        }
        this.steps = font.getHeight();
        int startTranslucencyPercent = 90;
        this.startTranslucency = startTranslucencyPercent * 255 / 100;
        int endTranslucencyPercent = 0;
        this.endTranslucency = endTranslucencyPercent * 255 / 100;
    }

    public void releaseResources() {
        super.releaseResources();
        this.lastText = null;
        this.rgbData = null;
        this.bufferGraphics = null;
        this.bufferImage = null;
    }

    public void read(DataInputStream dataInputStream) throws IOException {
        super.read(dataInputStream);
        this.clearColor = dataInputStream.readInt();
        this.endTranslucency = dataInputStream.readInt();
        this.lastText = (String)Serializer.deserialize(dataInputStream);
        this.padding = dataInputStream.readInt();
        if (dataInputStream.readBoolean()) {
            int n = dataInputStream.readInt();
            this.rgbData = new int[n];
            int n2 = 0;
            while (n2 < n) {
                this.rgbData[n2] = dataInputStream.readInt();
                ++n2;
            }
        }
        this.rgbHeight = dataInputStream.readInt();
        this.rgbWidth = dataInputStream.readInt();
        this.shadowColor = dataInputStream.readInt();
        this.startTranslucency = dataInputStream.readInt();
        this.steps = dataInputStream.readInt();
    }

    public void write(DataOutputStream dataOutputStream) throws IOException {
        super.write(dataOutputStream);
        dataOutputStream.writeInt(this.clearColor);
        dataOutputStream.writeInt(this.endTranslucency);
        Serializer.serialize(this.lastText, dataOutputStream);
        dataOutputStream.writeInt(this.padding);
        if (this.rgbData == null) {
            dataOutputStream.writeBoolean(false);
        } else {
            dataOutputStream.writeBoolean(true);
            int n = this.rgbData.length;
            dataOutputStream.writeInt(n);
            int n2 = 0;
            while (n2 < n) {
                dataOutputStream.writeInt(this.rgbData[n2]);
                ++n2;
            }
        }
        dataOutputStream.writeInt(this.rgbHeight);
        dataOutputStream.writeInt(this.rgbWidth);
        dataOutputStream.writeInt(this.shadowColor);
        dataOutputStream.writeInt(this.startTranslucency);
        dataOutputStream.writeInt(this.steps);
    }
}

