/*
 * Decompiled with CFR 0.152.
 */
package com.sonyericsson.kx;

import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;

public class TimeStamp {
    Calendar time = Calendar.getInstance();
    static long ONE_DAY = 86400000L;

    public TimeStamp(String t) {
        TimeZone tz = this.time.getTimeZone();
        try {
            this.time.setTime(new Date(Long.parseLong(t) * 1000L + 28800000L - (long)tz.getRawOffset()));
        }
        catch (Exception e) {
            System.out.println(String.valueOf(t) + "  " + e.toString());
        }
    }

    public int getDays() {
        Calendar now = Calendar.getInstance();
        long lDiff = now.getTime().getTime() - this.time.getTime().getTime();
        if (lDiff >= 0L && lDiff < ONE_DAY) {
            return 0;
        }
        if (lDiff >= ONE_DAY) {
            return -1;
        }
        return (int)(1L + lDiff * -1L / ONE_DAY);
    }

    public int inSeconds() {
        return 0;
    }

    public String toString() {
        int nDay = this.time.get(5);
        int nMonth = this.time.get(2) + 1;
        int nYear = this.time.get(1);
        int nHour = this.time.get(11);
        int nMinute = this.time.get(12);
        StringBuffer sb = new StringBuffer();
        if (this.getDays() != 0) {
            this.appendDate(nDay, nMonth, sb);
        } else {
            this.appendTime(nHour, nMinute, sb);
        }
        return sb.toString();
    }

    private void appendTime(int nHour, int nMinute, StringBuffer sb) {
        if (nHour < 10) {
            sb.append('0');
            sb.append(nHour);
        } else {
            sb.append(nHour);
        }
        sb.append(':');
        if (nMinute < 10) {
            sb.append('0');
            sb.append(nMinute);
        } else {
            sb.append(nMinute);
        }
    }

    private void appendDate(int nDay, int nMonth, StringBuffer sb) {
        sb.append(nMonth);
        sb.append('-');
        if (nDay < 10) {
            sb.append('0');
            sb.append(nDay);
        } else {
            sb.append(nDay);
        }
    }
}

