/*
 * Decompiled with CFR 0.152.
 */
package com.sina.ui;

import com.sina.ui.ControlItem;
import com.sina.weibo.comm.G;
import com.sina.weibo.comm.Tools;
import java.io.IOException;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class LableItem
extends ControlItem {
    public static final int LEFT = 0;
    public static final int MIDDLE = 1;
    public static final int RIGHT = 2;
    String[] info;
    private int color = G.ContentColor;
    private Image image;
    private int align;
    public int line;
    private Image backimage;
    private boolean showLine;

    public LableItem(String s) {
        this(s, G.W);
    }

    public LableItem(String s, int width) {
        this.focusable = false;
        this.width = width;
        this.info = Tools.stringFormatArray(s, width, G.SHOW_FONT);
        this.height = this.info.length * G.SHOW_FONT.getHeight();
        this.line = this.height / this.info.length;
    }

    public LableItem(String s, String imagePath, int stringColor) {
        this(s);
        this.color = stringColor;
        try {
            this.image = Image.createImage((String)imagePath);
            if (this.image.getHeight() > this.height) {
                this.height = this.image.getHeight();
            }
            this.line = this.height / this.info.length;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void setback(String imagePath) {
        try {
            this.backimage = Image.createImage((String)imagePath);
            if (this.height < this.backimage.getHeight()) {
                this.height = this.backimage.getHeight();
                this.line = this.height / this.info.length;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void setContentColor(int stringColor) {
        this.color = stringColor;
    }

    public void setAlign(int x) {
        this.align = x;
    }

    public void paint(Graphics g, int clipx, int clipy) {
        int offy = this.painty;
        if (this.backimage != null) {
            int x = this.paintx;
            while (x < this.paintx + this.width) {
                int y = this.painty;
                while (y < this.painty + this.height) {
                    g.drawImage(this.backimage, x, y, 20);
                    y += this.backimage.getHeight();
                }
                x += this.backimage.getWidth();
            }
        }
        if (this.image != null) {
            g.drawImage(this.image, this.paintx, this.painty + (this.height - this.image.getHeight()) / 2, 20);
        }
        if (this.info != null) {
            g.setColor(this.color);
            if (this.line < G.SHOW_FONT.getHeight()) {
                this.line = G.SHOW_FONT.getHeight();
            }
            offy += (this.line - G.SHOW_FONT.getHeight()) / 2;
            int i = 0;
            while (i < this.info.length) {
                int offx = 0;
                if (this.align == 0) {
                    offx = this.paintx + 2;
                    if (this.image != null) {
                        offx += this.image.getWidth();
                    }
                } else if (this.align == 1) {
                    offx = this.paintx + (this.width - g.getFont().stringWidth(this.info[i])) / 2;
                    if (this.image != null) {
                        offx += this.image.getWidth() / 2;
                    }
                } else {
                    offx = this.paintx + this.width - g.getFont().stringWidth(this.info[i]);
                }
                g.drawString(this.info[i], offx, offy, 20);
                offy += this.line;
                ++i;
            }
        }
        if (this.showLine) {
            g.setColor(0xBDBDBD);
            g.drawLine(this.paintx, this.painty + this.height - 1, this.paintx + this.width, this.painty + this.height - 1);
        }
    }

    public void doEntry() {
    }

    public void setTitle(String s) {
        this.info = Tools.stringFormatArray(s, this.width, G.SHOW_FONT);
        this.height = this.info.length * G.SHOW_FONT.getHeight();
    }

    public void showLine() {
        this.showLine = true;
    }
}

