/*
 * Decompiled with CFR 0.152.
 */
package com.sina.ui;

import com.sina.ui.ControlItem;
import com.sina.ui.RollContainer;
import com.sina.ui.WeiboListener;
import com.sina.weibo.comm.G;
import com.sina.weibo.comm.Tools;
import java.io.IOException;
import java.util.Vector;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class WeiboLableItem
extends ControlItem {
    private int color = 3160910;
    private Image backimage;
    private Vector vc = new Vector();
    private int index;
    private RollContainer container;
    private int end;
    private int start;
    private WeiboListener listener;

    public WeiboLableItem(String bowen, String zhuanfa, RollContainer rc, WeiboListener l) {
        this(bowen, zhuanfa, rc, l, G.W);
    }

    public WeiboLableItem(String bowen, String zhuanfa, RollContainer rc, WeiboListener l, int width) {
        this.focusable = false;
        this.width = width;
        this.container = rc;
        this.listener = l;
        String[] infos = Tools.stringFormatArray(String.valueOf(bowen) + zhuanfa, width - 2, G.SHOW_FONT);
        this.height = infos.length * G.SYS_FONTLINE_HEIGHT + 4;
        if (zhuanfa != null && !"".equals(zhuanfa)) {
            this.analyse(zhuanfa);
            Item item = new Item();
            item.type = -1;
            this.vc.addElement(item);
            this.height += 12;
        }
        this.analyse(bowen);
    }

    public void analyse(String s) {
        StringBuffer sb = new StringBuffer();
        int type = 0;
        int j = 0;
        while (j < s.length()) {
            Item item;
            char c = s.charAt(j);
            if (c == '#') {
                if (type == 2) {
                    sb.append(c);
                    item = new Item();
                    item.type = type;
                    item.value = sb.toString();
                    item.end = j;
                    this.vc.addElement(item);
                    type = 0;
                    sb = new StringBuffer();
                } else {
                    item = new Item();
                    item.type = type;
                    item.value = sb.toString();
                    item.end = j - 1;
                    this.vc.addElement(item);
                    type = 2;
                    sb = new StringBuffer();
                    sb.append(c);
                }
            } else if (c == 'h' && type == 0) {
                if (s.length() >= j + 12) {
                    String http = s.substring(j, j + 7);
                    if ("http://".equals(http)) {
                        Item item2 = new Item();
                        item2.type = type;
                        item2.value = sb.toString();
                        item2.end = j - 1;
                        this.vc.addElement(item2);
                        type = 3;
                        sb = new StringBuffer();
                        sb.append(http);
                        j += 6;
                    } else {
                        sb.append(c);
                    }
                } else {
                    sb.append(c);
                }
            } else if (c == '@' && type == 0) {
                item = new Item();
                item.type = type;
                item.value = sb.toString();
                item.end = j - 1;
                this.vc.addElement(item);
                type = 1;
                sb = new StringBuffer();
                sb.append(c);
            } else if (type == 1) {
                if (!((c >= '\u4e00' && c <= '\u9fa5' || c >= '\uff00' && c <= '\uffff' || c >= '\u0800' && c <= '\u4e00' || c >= '\u3130' && c <= '\u318f' || c >= '\uac00' && c <= '\ud7a3' || c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c >= '0' && c <= '9') && G.atMark.indexOf(c) < 0)) {
                    item = new Item();
                    item.type = type;
                    item.value = sb.toString();
                    if ("@\u6211".equals(item.value)) {
                        item.type = 0;
                    }
                    item.end = j - 1;
                    this.vc.addElement(item);
                    type = c == '#' ? 2 : (c == '@' ? 1 : 0);
                    sb = new StringBuffer();
                    sb.append(c);
                } else {
                    sb.append(c);
                }
            } else if (type == 3) {
                if (!(c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c >= '0' && c <= '9' || G.httpMark.indexOf(c) >= 0)) {
                    item = new Item();
                    item.type = type;
                    char cc = s.charAt(j - 1);
                    if (cc == '.' || cc == ',') {
                        String ss = sb.toString();
                        item.value = ss.substring(0, ss.length() - 1);
                        item.end = j - 2;
                        this.vc.addElement(item);
                        type = 0;
                        sb = new StringBuffer();
                        sb.append(cc);
                        sb.append(c);
                    } else {
                        item.value = sb.toString();
                        item.end = j - 1;
                        this.vc.addElement(item);
                        type = c == '#' ? 2 : (c == '@' ? 1 : 0);
                        sb = new StringBuffer();
                        sb.append(c);
                    }
                } else {
                    sb.append(c);
                }
            } else {
                sb.append(c);
            }
            ++j;
        }
        if (type == 2) {
            type = 0;
        }
        Item item = new Item();
        item.type = type;
        item.value = sb.toString();
        item.end = s.length() - 1;
        this.vc.addElement(item);
    }

    public void setback(String imagePath) {
        try {
            this.backimage = Image.createImage((String)imagePath);
            if (this.height < this.backimage.getHeight()) {
                this.height = this.backimage.getHeight();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void setContentColor(int stringColor) {
        this.color = stringColor;
    }

    public void paint(Graphics g, int clipx, int clipy) {
        int offy = this.painty;
        if (this.backimage != null) {
            int x = this.paintx;
            while (x < this.paintx + this.width) {
                int y = this.painty;
                while (y < this.painty + this.height) {
                    g.drawImage(this.backimage, x, y, 20);
                    y += this.backimage.getHeight();
                }
                x += this.backimage.getWidth();
            }
        }
        if (this.vc != null) {
            g.setColor(this.color);
            offy += (G.SYS_FONTLINE_HEIGHT - G.SHOW_FONT.getHeight()) / 2;
            int offx = this.paintx + 2;
            this.end = 0;
            this.start = 0;
            int i = 0;
            while (i < this.vc.size()) {
                Item item = (Item)this.vc.elementAt(i);
                if (item.type == -1) {
                    g.setColor(0x949494);
                    g.drawLine(this.paintx, (offy += 4) + G.SYS_FONTLINE_HEIGHT, this.paintx + this.width, offy + G.SYS_FONTLINE_HEIGHT);
                    offy += 8;
                } else {
                    int j = 0;
                    while (j < item.value.length()) {
                        char c = item.value.charAt(j);
                        if (c == '\n') {
                            offx = this.paintx + 2;
                            offy += G.SYS_FONTLINE_HEIGHT;
                        } else {
                            if (offx + g.getFont().charWidth(c) > this.paintx + this.width) {
                                offx = this.paintx + 2;
                                offy += G.SYS_FONTLINE_HEIGHT;
                            }
                            if (this.painty + offy < this.container.painty) {
                                ++this.start;
                            }
                            if (offy <= this.container.getPainty() + this.container.height) {
                                ++this.end;
                            }
                            if (item.type != 0) {
                                if (this.index == i) {
                                    g.setColor(G.LinkSelectColor);
                                    g.drawLine(offx, offy + G.SYS_FONTLINE_HEIGHT - 2, offx + g.getFont().charWidth(c), offy + G.SYS_FONTLINE_HEIGHT - 2);
                                } else {
                                    g.setColor(G.LinkTxtColor);
                                }
                            } else {
                                g.setColor(this.color);
                            }
                            g.drawChar(c, offx, offy, 20);
                            offx += g.getFont().charWidth(c);
                        }
                        ++j;
                    }
                }
                ++i;
            }
        }
    }

    public void doEntry() {
        Item item = (Item)this.vc.elementAt(this.index);
        if (item.type == 1) {
            this.listener.weiboItemPerformed(item.type, item.value.substring(1));
        } else if (item.type == 2) {
            this.listener.weiboItemPerformed(item.type, item.value.substring(1, item.value.length() - 1));
        } else if (item.type == 3) {
            this.listener.weiboItemPerformed(item.type, item.value);
        }
    }

    public boolean movePre() {
        if (this.index == 0) {
            return true;
        }
        Item item1 = (Item)this.vc.elementAt(this.index - 1);
        if (item1.type >= 0 && item1.end + 1 < this.start) {
            return true;
        }
        --this.index;
        Item item = (Item)this.vc.elementAt(this.index);
        if (item.type <= 0 || item.end + 1 < this.start) {
            return this.movePre();
        }
        return false;
    }

    public boolean moveNext() {
        Item item = (Item)this.vc.elementAt(this.index);
        if (this.index == this.vc.size() - 1 || item.end > this.end) {
            return true;
        }
        ++this.index;
        item = (Item)this.vc.elementAt(this.index);
        if (item.type <= 0 || item.end > this.end) {
            return this.moveNext();
        }
        return false;
    }

    private class Item {
        public int type;
        public int end;
        public String value;

        private Item() {
        }
    }
}

