/*
 * Decompiled with CFR 0.152.
 */
package com.sina.weibo.comm;

import com.sina.weibo.ClientManager;
import com.sina.weibo.comm.G;
import com.sonyericsson.sina.widget.SinawidgetMIDlet;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.InputStream;
import java.util.Calendar;
import java.util.Random;
import java.util.Vector;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.game.GameCanvas;

public class Tools {
    public static Image loadImg;
    public static Image progressImg;
    public static Image progressItemImg;
    public static Image progressHeadImg;
    private static final String NOKIA_CLASS = "com.nokia.mid.ui.FullCanvas";
    private static final String SIEMENS_CLASS = "com.siemens.mp.lcdui.Image";
    private static final String MOTOROLA_CLASS = "com.motorola.phonebook.PhoneBookRecord";
    private static final String SOFT_KEYWORD = "SOFT";
    public static int keyCodeSoftL;
    public static int keyCodeSoftR;
    public static final byte KEY_OTHER = 0;
    public static final byte KEY_UP = 1;
    public static final byte KEY_DOWN = 2;
    public static final byte KEY_LEFT = 3;
    public static final byte KEY_RIGHT = 4;
    public static final byte KEY_SOFTLEFT = 5;
    public static final byte KEY_SOFTRIGHT = 6;
    public static final byte KEY_FIRE = 7;
    public static final String MENUBAR_OK = "\u786e\u5b9a";
    public static final String MENUBAR_CANCEL = "\u53d6\u6d88";
    public static final String MENUBAR_OPTION = "\u9009\u9879";
    public static final String MENUBAR_SELECT = "\u9009\u62e9";
    public static final String MENUBAR_BACK = "\u8fd4\u56de";
    public static final String MENUBAR_EXIT = "\u9000\u51fa";
    public static final String MENUBAR_LOGIN = "\u767b\u5f55";
    public static final String MENUBAR_SEND = "\u53d1\u8868";

    static {
        try {
            loadImg = Image.createImage((String)"/load.PNG");
            progressImg = Image.createImage((String)(String.valueOf(G.resPath) + "/progress_BG.PNG"));
            progressItemImg = Image.createImage((String)(String.valueOf(G.resPath) + "/progress.PNG"));
            progressHeadImg = Image.createImage((String)(String.valueOf(G.resPath) + "/progress_R.PNG"));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void drawMenuBar(Graphics g, String left, String right, String middle) {
        g.setClip(0, 0, G.W, G.H);
        Tools.drawTranceColor(g, 0xF2F2F3, 13882581, 0, G.H - G.MenuBarHeight, G.W, 13);
        g.setColor(11908792);
        g.fillRect(0, G.H - G.MenuBarHeight + 13, G.W, G.MenuBarHeight - 13);
        g.setClip(0, 0, G.W, G.H);
        g.setColor(G.MenuTxtColor);
        g.setFont(G.SHOW_FONT);
        if (left != null) {
            g.drawString(left, 10, G.H - (G.MenuBarHeight + G.SHOW_FONT.getHeight()) / 2, 20);
        }
        if (right != null) {
            int x = G.W - G.SHOW_FONT.stringWidth(right) - 10;
            g.drawString(right, x, G.H - (G.MenuBarHeight + G.SHOW_FONT.getHeight()) / 2, 20);
        }
        if (middle != null) {
            g.drawString(middle, (G.W - G.SHOW_FONT.stringWidth(middle)) / 2, G.H - (G.MenuBarHeight + G.SHOW_FONT.getHeight()) / 2, 20);
        }
    }

    public static void browserView(String url) {
        try {
            ClientManager.needClose = SinawidgetMIDlet.instance.platformRequest(url);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static final void drawTiledBG(Graphics g, Image img, int x, int y, int width, int height, int imgX, int imgY, int imgWidth, int imgHeight) {
        g.setClip(x, y, width, height);
        int width2 = width + x;
        int height2 = height + y;
        int tmpX = x;
        int tmpY = y;
        while (tmpY < height2) {
            int tmpX2 = imgWidth;
            int tmpY2 = imgHeight;
            if (tmpX + imgWidth > width2) {
                tmpX2 = width % imgWidth;
            }
            if (tmpY + imgHeight > height2) {
                tmpY2 = height % imgHeight;
            }
            g.setClip(tmpX, tmpY, tmpX2, tmpY2);
            g.drawImage(img, tmpX - imgX, tmpY - imgY, 20);
            if ((tmpX += imgWidth) < width2) continue;
            tmpX = x;
            tmpY += imgHeight;
        }
    }

    public static void drawTranceColor(Graphics g, int up, int down, int paintx, int painty, int width, int height) {
        int upr = up & 0xFF;
        int upm = (up & 0xFF00) >> 8;
        int upl = up >> 16;
        int downr = down & 0xFF;
        int downm = (down & 0xFF00) >> 8;
        int downl = down >> 16;
        int hh = 1;
        int cr = (downr - upr) * 1000 / height / 1000;
        int cm = (downm - upm) * 1000 / height / 1000;
        int cl = (downl - upl) * 1000 / height / 1000;
        if (cr == 0 || cm == 0 || cl == 0) {
            do {
                cr = (downr - upr) * ++hh * 1000 / height / 1000;
                cm = (downm - upm) * hh * 1000 / height / 1000;
                cl = (downl - upl) * hh * 1000 / height / 1000;
            } while (cr == 0 || cm == 0 || cl == 0);
        }
        int i = 0;
        while (i * hh < height) {
            g.setColor((upl + i * cl << 16) + (upm + i * cm << 8) + (upr + i * cr));
            if ((i + 1) * hh <= height) {
                g.fillRect(paintx, painty + i * hh, width, hh);
            } else {
                g.fillRect(paintx, painty + i * hh, width, height - i * hh);
            }
            ++i;
        }
    }

    public static void drawTranceColor(Graphics g, int up, int middle, int down, int upFeild, int downFeild, int paintx, int painty, int width, int height) {
        int upr = up & 0xFF;
        int upm = (up & 0xFF00) >> 8;
        int upl = up >> 16;
        int middler = middle & 0xFF;
        int middlem = (middle & 0xFF00) >> 8;
        int middlel = middle >> 16;
        int downr = down & 0xFF;
        int downm = (down & 0xFF00) >> 8;
        int downl = down >> 16;
        int h = height * upFeild / (upFeild + downFeild);
        int hh = 1;
        int cr = (middler - upr) * 1000 / h / 1000;
        int cm = (middlem - upm) * 1000 / h / 1000;
        int cl = (middlel - upl) * 1000 / h / 1000;
        if (cr == 0 || cm == 0 || cl == 0) {
            do {
                cr = (middler - upr) * ++hh * 1000 / h / 1000;
                cm = (middlem - upm) * hh * 1000 / h / 1000;
                cl = (middlel - upl) * hh * 1000 / h / 1000;
            } while (cr == 0 || cm == 0 || cl == 0);
        }
        int i = 0;
        while (i * hh <= h) {
            g.setColor((upl + i * cl << 16) + (upm + i * cm << 8) + (upr + i * cr));
            g.fillRect(paintx, painty + i * hh, width, hh);
            ++i;
        }
        int h1 = height * downFeild / (upFeild + downFeild);
        hh = 1;
        int c1r = (downr - middler) * 1000 / h1 / 1000;
        int c1m = (downm - middlem) * 1000 / h1 / 1000;
        int c1l = (downl - middlel) * 1000 / h1 / 1000;
        if (c1r == 0 || c1m == 0 || c1l == 0) {
            do {
                c1r = (downr - middler) * ++hh * 1000 / h1 / 1000;
                c1m = (downm - middlem) * hh * 1000 / h1 / 1000;
                c1l = (downl - middlel) * hh * 1000 / h1 / 1000;
            } while (c1r == 0 || c1m == 0 || c1l == 0);
        }
        int i2 = 0;
        while (i2 * hh < h1) {
            g.setColor((middlel + i2 * c1l << 16) + (middlem + i2 * c1m << 8) + (middler + i2 * c1r));
            if (h + (i2 + 1) * hh <= height) {
                g.fillRect(paintx, painty + h + i2 * hh, width, hh);
            } else {
                g.fillRect(paintx, painty + h + i2 * hh, width, height - i2 * hh - h);
            }
            ++i2;
        }
    }

    public static int FP_Sqrt(int n) {
        return (int)Tools.try_sqrt(1L, n);
    }

    static boolean good_enough(long guess, int x) {
        long i = guess * guess;
        if (i == (long)x) {
            return true;
        }
        if (i > (long)x) {
            long min = (guess - 1L) * (guess - 1L);
            if (min > (long)x) {
                return false;
            }
            return i - (long)x <= (long)x - min;
        }
        if (i < (long)x) {
            long max = (guess + 1L) * (guess + 1L);
            if (max < (long)x) {
                return false;
            }
            return (long)x - i <= max - (long)x;
        }
        return false;
    }

    static long try_sqrt(long guess, int x) {
        if (Tools.good_enough(guess, x)) {
            return guess;
        }
        long g = (guess + (long)x / guess) / 2L;
        if (g == guess) {
            ++g;
        }
        return Tools.try_sqrt(g, x);
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void detectSoftkeys(GameCanvas canvas) {
        block18: {
            int i;
            boolean bFound;
            block17: {
                keyCodeSoftL = 0;
                keyCodeSoftR = 0;
                try {
                    Class.forName(NOKIA_CLASS);
                    keyCodeSoftL = -6;
                    keyCodeSoftR = -7;
                    return;
                }
                catch (ClassNotFoundException ignore1) {
                    try {
                        Class.forName(SIEMENS_CLASS);
                        keyCodeSoftL = -1;
                        keyCodeSoftR = -4;
                        return;
                    }
                    catch (ClassNotFoundException ignore2) {
                        try {
                            Class.forName(MOTOROLA_CLASS);
                            int sign = canvas.getKeyName(-21).toUpperCase().indexOf(SOFT_KEYWORD) >= 0 ? -1 : 1;
                            keyCodeSoftL = sign * 21;
                            keyCodeSoftR = sign * 22;
                            return;
                        }
                        catch (ClassNotFoundException ignore3) {
                            bFound = false;
                            try {
                                if (canvas.getKeyName(21).toUpperCase().indexOf(SOFT_KEYWORD) >= 0) {
                                    keyCodeSoftL = 21;
                                    keyCodeSoftR = 22;
                                    bFound = true;
                                }
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                            try {
                                if (canvas.getKeyName(-6).toUpperCase().indexOf(SOFT_KEYWORD) >= 0) {
                                    keyCodeSoftL = -6;
                                    keyCodeSoftR = -7;
                                    bFound = true;
                                }
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                            i = -127;
                            if (!true) break block17;
                            if (bFound) return;
                            if (i >= 127) break block18;
                        }
                    }
                }
            }
            do {
                block19: {
                    try {
                        String keyName = canvas.getKeyName(i);
                        if (keyName.toUpperCase().indexOf(SOFT_KEYWORD) < 0) break block19;
                        if (keyName.indexOf("1") >= 0) {
                            keyCodeSoftL = i;
                        }
                        if (keyName.indexOf("2") >= 0) {
                            keyCodeSoftR = i;
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                ++i;
                if (bFound) return;
            } while (i < 127);
        }
    }

    public static void drawLoadingProgress(Graphics g, int progress, String s) {
        g.setClip(0, G.H - 25, G.W, 25);
        Tools.drawMenuBar(g, null, MENUBAR_CANCEL, null);
        g.setFont(G.SHOW_FONT);
        int offx = 10;
        g.drawString(s, offx, G.H - 22, 20);
        offx += g.getFont().stringWidth(s);
        int i = 0;
        while (i < progress) {
            g.drawChar('.', offx, G.H - 22, 20);
            offx += g.getFont().charWidth('.');
            ++i;
        }
    }

    public static void drawProgressing(Graphics g, int progress, String str1, String str2) {
        g.setClip(0, 25, G.W, G.H - 48);
        int offy = (G.H - loadImg.getHeight()) / 2 - 25;
        g.drawImage(loadImg, (G.W - loadImg.getWidth()) / 2, offy, 20);
        int offx = (G.W - progressImg.getWidth()) / 2;
        g.drawImage(progressImg, offx, offy += loadImg.getHeight() + 5, 20);
        int x = 0;
        while (x < 2 * progress) {
            g.drawImage(progressItemImg, offx + 5 + x, offy, 20);
            x += progressItemImg.getWidth();
        }
        g.drawImage(progressHeadImg, offx + 5 + x, offy, 20);
        g.drawString(str1, (G.W - G.SHOW_FONT.stringWidth(str1)) / 2, offy += progressImg.getHeight() + 5, 20);
        g.drawString(str2, (G.W - G.SHOW_FONT.stringWidth(str2)) / 2, offy + 2 + G.SHOW_FONT.getHeight(), 20);
        Tools.drawMenuBar(g, null, MENUBAR_CANCEL, null);
    }

    public static void drawListRollBar(Graphics g, int offy, int itemheight, int offitem, int displaynum, int shownum, int maxnum, int offx) {
        int showheight = itemheight * maxnum;
        int startoff = offitem * showheight / displaynum;
        if (offitem > 0 && startoff == 0) {
            startoff = 4;
        }
        int lenoff = shownum * showheight / displaynum;
        if (offitem + shownum == displaynum) {
            startoff = showheight - lenoff;
        }
        Tools.drawRollBar(g, offy, showheight, startoff, lenoff, offx);
    }

    public static void drawRollBar(Graphics g, int offy, int barH, int startoff, int len, int x) {
        int offx = G.W - x - 4;
        g.setClip(offx, offy, 4, barH);
        g.setColor(140, 140, 140);
        g.drawLine(offx + 2, offy, offx + 2, offy + barH);
        if (startoff < 0) {
            startoff = 0;
        }
        if (startoff + len > barH) {
            startoff = barH - len;
        }
        g.fillRect(offx, startoff += offy, 4, len);
    }

    public static final void drawAlert(Graphics g, String message) {
        g.setClip(0, 0, G.W, G.H);
        String[] messages = Tools.stringFormatArray(message, G.W - 80, G.SHOW_FONT);
        g.setColor(G.MenuListBorder);
        g.fillRoundRect(30, G.H / 2 - 50, G.W - 60, 100, 10, 10);
        g.setColor(G.MenuListBack);
        g.fillRoundRect(32, G.H / 2 - 48, G.W - 64, 96, 10, 10);
        int offy = G.H / 2 - 50 + 10;
        g.setColor(G.AlertTxtColor);
        int i = 0;
        while (i < messages.length) {
            g.drawString(messages[i], (G.W - g.getFont().stringWidth(messages[i])) / 2, offy, 20);
            offy += G.SYS_FONTLINE_HEIGHT;
            ++i;
        }
    }

    public static final void drawGuanyu(Graphics g, String message) {
        g.setClip(0, 0, G.W, G.H);
        String[] messages = Tools.stringFormatArray(message, G.W - 20, G.SHOW_FONT);
        int h = 100;
        if (messages.length > 4) {
            h = messages.length * 23;
        }
        g.setColor(G.MenuListBorder);
        g.fillRoundRect(5, (G.H - 10 - h) / 2, G.W - 10, h, 10, 10);
        g.setColor(G.MenuListBack);
        g.fillRoundRect(7, (G.H - 10 - h) / 2 - 2, G.W - 14, h - 4, 10, 10);
        int offy = (G.H - 10 - h) / 2 + 10;
        g.setColor(G.AlertTxtColor);
        int i = 0;
        while (i < messages.length) {
            g.drawString(messages[i], (G.W - g.getFont().stringWidth(messages[i])) / 2, offy, 20);
            offy += G.SYS_FONTLINE_HEIGHT;
            ++i;
        }
    }

    public static byte[] readBytesFromStream(DataInputStream dis) {
        try {
            int j;
            ByteArrayOutputStream bytearrayoutputstream = new ByteArrayOutputStream();
            while ((j = dis.read()) != -1) {
                bytearrayoutputstream.write(j);
            }
            byte[] receivedData = bytearrayoutputstream.toByteArray();
            bytearrayoutputstream.close();
            return receivedData;
        }
        catch (Exception e) {
            return null;
        }
    }

    public static String[] stringFormatArray(String info, int width, Font font) {
        info = Tools.replaceString(info, "\r\n", "\n");
        Vector<String> ShowStrVc = new Vector<String>();
        while (true) {
            int tmpint;
            if ((tmpint = Tools.changLine(info, width, font)) == 0) break;
            String tmpStr = info.charAt(tmpint - 1) == '\n' ? info.substring(0, tmpint - 1) : info.substring(0, tmpint);
            ShowStrVc.addElement(tmpStr);
            info = info.substring(tmpint, info.length());
        }
        ShowStrVc.addElement(info);
        Object[] list = new String[ShowStrVc.size()];
        ShowStrVc.copyInto(list);
        return list;
    }

    public static int[][] getCharsInLine(char[] info, int width, Font font) {
        Vector<Integer> charNumVc = new Vector<Integer>();
        Vector<Integer> charStartVc = new Vector<Integer>();
        int len = 0;
        int wd = 0;
        int i = 0;
        while (i < info.length) {
            if (info[i] == '\n' || i == info.length - 1) {
                charStartVc.addElement(new Integer(i - len));
                charNumVc.addElement(new Integer(len));
                wd = 0;
                len = 0;
            } else if ((wd += font.charWidth(info[i])) > width) {
                charStartVc.addElement(new Integer(i - len));
                charNumVc.addElement(new Integer(len));
                wd = font.charWidth(info[i]);
                len = 1;
            } else {
                len = (byte)(len + 1);
            }
            ++i;
        }
        int[][] tmp = new int[charStartVc.size()][2];
        int i2 = 0;
        while (i2 < charStartVc.size() && i2 < charNumVc.size()) {
            tmp[i2][0] = (Integer)charStartVc.elementAt(i2);
            tmp[i2][1] = (Integer)charNumVc.elementAt(i2);
            ++i2;
        }
        return tmp;
    }

    private static int changLine(String str, int linewd, Font font) {
        int len = 0;
        int wd = 0;
        int i = 0;
        while (i < str.length()) {
            if (str.charAt(i) == '\n') {
                if (i == 0) {
                    return len + 1;
                }
                return len + 2;
            }
            if ((wd += font.charWidth(str.charAt(i))) > linewd) {
                return len + 1;
            }
            len = i++;
        }
        return 0;
    }

    private static final String replaceString(String a, String b, String c) {
        if (a == null) {
            return "";
        }
        StringBuffer buffer = new StringBuffer();
        int tmp = 0;
        int length = b.length();
        while ((tmp = a.indexOf(b)) != -1) {
            buffer.append(a.substring(0, tmp));
            buffer.append(c);
            a = a.substring(tmp + length);
        }
        buffer.append(a);
        return buffer.toString();
    }

    public static byte keyCompare(int keyCode) {
        if (keyCode == G.keyCodeData[0] || keyCode == 53) {
            return 7;
        }
        if (keyCode == G.keyCodeData[1]) {
            return 5;
        }
        if (keyCode == G.keyCodeData[2]) {
            return 6;
        }
        if (keyCode == G.keyCodeData[3] || keyCode == 50) {
            return 1;
        }
        if (keyCode == G.keyCodeData[4] || keyCode == 56) {
            return 2;
        }
        if (keyCode == G.keyCodeData[5] || keyCode == 52) {
            return 3;
        }
        if (keyCode == G.keyCodeData[6] || keyCode == 54) {
            return 4;
        }
        return 0;
    }

    public static String getTimeStr() {
        Calendar calendar = Calendar.getInstance();
        StringBuffer stringbuffer = new StringBuffer();
        String hour = String.valueOf(calendar.get(11));
        if (hour.length() < 2) {
            stringbuffer.append("0");
        }
        stringbuffer.append(hour);
        stringbuffer.append(":");
        String min = String.valueOf(calendar.get(12));
        if (min.length() < 2) {
            stringbuffer.append("0");
        }
        stringbuffer.append(min);
        return stringbuffer.toString();
    }

    public static String getDateStr() {
        Calendar calendar = Calendar.getInstance();
        StringBuffer stringbuffer = new StringBuffer();
        String year = String.valueOf(calendar.get(1));
        stringbuffer.append(year);
        stringbuffer.append("\u5e74");
        String month = String.valueOf(calendar.get(2) + 1);
        stringbuffer.append(month);
        stringbuffer.append("\u6708");
        String day = String.valueOf(calendar.get(5));
        stringbuffer.append(day);
        stringbuffer.append("\u65e5");
        return stringbuffer.toString();
    }

    public static Image createThumbnail(Image image) {
        int sourceWidth = image.getWidth();
        int sourceHeight = image.getHeight();
        int thumbWidth = 128;
        int thumbHeight = -1;
        if (thumbHeight == -1) {
            thumbHeight = thumbWidth * sourceHeight / sourceWidth;
        }
        Image thumb = Image.createImage((int)thumbWidth, (int)thumbHeight);
        Graphics g = thumb.getGraphics();
        int y = 0;
        while (y < thumbHeight) {
            int x = 0;
            while (x < thumbWidth) {
                g.setClip(x, y, 1, 1);
                int dx = x * sourceWidth / thumbWidth;
                int dy = y * sourceHeight / thumbHeight;
                g.drawImage(image, x - dx, y - dy, 20);
                ++x;
            }
            ++y;
        }
        Image immutableThumb = Image.createImage((Image)thumb);
        return immutableThumb;
    }

    public static void drawImageEx(Graphics g, Image img, int x, int y, int width, int height, int imgX, int imgY) {
        g.setClip(x, y, width, height);
        g.drawImage(img, x - imgX, y - imgY, 20);
    }

    public String loadFile(String fileName) {
        String strReturn = "";
        byte[] wordBy = new byte[1024];
        Vector<byte[]> vc = new Vector<byte[]>();
        InputStream in = null;
        try {
            in = this.getClass().getResourceAsStream(fileName);
            while (in.read(wordBy) != -1) {
                vc.addElement(wordBy);
                wordBy = new byte[1024];
            }
            byte[] b = new byte[1024 * vc.size()];
            int i = 0;
            while (i < vc.size()) {
                byte[] temp = (byte[])vc.elementAt(i);
                int j = 0;
                while (j < temp.length) {
                    b[i * 1024 + j] = temp[j];
                    ++j;
                }
                ++i;
            }
            in.close();
            byte[] b1 = new byte[b.length];
            int j = 0;
            int i2 = 0;
            while (i2 < b.length) {
                if (b[i2] != 13 && b[i2] != 0) {
                    b1[j] = b[i2];
                    ++j;
                }
                ++i2;
            }
            strReturn = new String(b1);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return strReturn.trim();
    }

    public static final int random(int n) {
        Random random = new Random();
        return (random.nextInt() << 1 >>> 1) % n;
    }

    public static String[] slip(String title, String mark) {
        Vector<String> vc = new Vector<String>();
        while (title.indexOf(mark) > 0) {
            vc.addElement(title.substring(0, title.indexOf(mark)));
            title = title.substring(title.indexOf(mark) + mark.length());
        }
        vc.addElement(title);
        Object[] s = new String[vc.size()];
        vc.copyInto(s);
        return s;
    }

    public static String unicodeToUtf8(byte[] resource, int offset1, int offset2) {
        String strReturn = "";
        StringBuffer stringbuffer = new StringBuffer("");
        int j = offset1;
        while (j < offset2) {
            int l;
            int k;
            if ((k = resource[j++]) < 0) {
                k += 256;
            }
            if (j >= offset2) break;
            if ((l = resource[j++]) < 0) {
                l += 256;
            }
            char c = (char)(k + (l << 8));
            stringbuffer.append(c);
        }
        strReturn = stringbuffer.toString();
        return strReturn;
    }

    public static String replace(String s, String mark, String newchar) {
        int i = -1;
        StringBuffer sb = new StringBuffer();
        while ((i = s.indexOf(mark)) > 0) {
            sb.append(s.substring(0, i));
            sb.append(newchar);
            s = s.substring(i + mark.length());
        }
        sb.append(s);
        return sb.toString();
    }

    public static void drawArrow(Graphics g, int bottom, int offx, int lenth, boolean left) {
        int i = 0;
        while (i < lenth) {
            if (left) {
                g.drawLine(offx + i, bottom - lenth - 1 - i, offx + i, bottom - lenth - 1 + i);
            } else {
                g.drawLine(offx + lenth - i, bottom - lenth - 1 - i, offx + lenth - i, bottom - lenth - 1 + i);
            }
            ++i;
        }
    }
}

