/*
 * Decompiled with CFR 0.152.
 */
package com.sina.weibo.data;

import com.sina.http.HttpEngine;
import com.sina.http.HttpListener;
import com.sina.http.URLEncoder;
import com.sina.parser.xml.XMLDataBlock;
import com.sina.parser.xml.XMLDataListener;
import com.sina.weibo.ClientManager;
import com.sina.weibo.comm.G;
import com.sina.weibo.data.Account;
import java.io.IOException;
import java.util.Vector;
import javax.microedition.lcdui.Image;

public class SearchAccountListModel
implements XMLDataListener,
HttpListener {
    public Vector account = new Vector();
    private ClientManager cm;
    public int pagesize = 20;
    public int count;
    public boolean loadHead;
    private int loadHeadIndex;
    public boolean loading;
    public int pageId = 1;
    public boolean loadList;
    public String key;

    public SearchAccountListModel(ClientManager cm, String key) {
        this.cm = cm;
        this.key = key;
        this.getAcount(0);
    }

    public void getAcount(int index) {
        StringBuffer send = new StringBuffer();
        send.append(G.serverPath);
        send.append("searchuser.php?");
        send.append("sid=");
        send.append(this.cm.currentAccount.sessionID);
        send.append("&gsid=");
        send.append(this.cm.currentAccount.gsid);
        send.append("&page=");
        send.append(index);
        send.append("&pagesize=");
        send.append(this.pagesize);
        send.append("&keyword=");
        send.append(URLEncoder.encode(this.key, "UTF-8"));
        this.cm.httpEngine.HttpConnect(0, 0, send.toString(), null, this, HttpEngine.HIGH);
        this.loadList = true;
        this.loadHead = false;
        this.cm.setWait(true);
    }

    public boolean blockArrived(XMLDataBlock data) {
        block26: {
            if (data.getTagName().equals("rss")) break block26;
            return false;
        }
        try {
            this.account.removeAllElements();
            Vector childvc = data.getChildBlocks();
            if (childvc != null) {
                int i = 0;
                while (i < childvc.size()) {
                    XMLDataBlock itemdata = (XMLDataBlock)childvc.elementAt(i);
                    if (itemdata.getTagName().equals("info")) {
                        Account item = new Account();
                        Vector child2 = itemdata.getChildBlocks();
                        if (child2 != null) {
                            int j = 0;
                            while (j < child2.size()) {
                                XMLDataBlock cc = (XMLDataBlock)child2.elementAt(j);
                                if (cc.getTagName().equals("nick")) {
                                    item.nick = cc.getText();
                                } else if (cc.getTagName().equals("uid")) {
                                    item.uid = cc.getText();
                                } else if (cc.getTagName().equals("num")) {
                                    item.fensishu = "\u7c89\u4e1d:" + cc.getText();
                                } else if (cc.getTagName().equals("portrait")) {
                                    item.headUrl = cc.getText();
                                } else if (cc.getTagName().equals("gender")) {
                                    item.sex = "0".equals(cc.getText()) ? "\u7537" : "\u5973";
                                } else if (cc.getTagName().equals("relation")) {
                                    item.relation = Integer.parseInt(cc.getText());
                                }
                                cc.close();
                                ++j;
                            }
                        }
                        this.account.addElement(item);
                    } else if (itemdata.getTagName().equals("count")) {
                        try {
                            this.count = Integer.parseInt(itemdata.getText());
                        }
                        catch (RuntimeException e) {
                            this.count = 0;
                        }
                    } else if (itemdata.getTagName().equals("sid")) {
                        this.cm.currentAccount.sessionID = itemdata.getText();
                    }
                    ++i;
                }
            }
            data.close();
            this.loadHead = true;
            this.loadHeadIndex = 0;
            this.cm.updateView(20, 0);
            if (this.account.size() == 0) {
                this.cm.showAlert("\u6ca1\u6709\u641c\u7d22\u5230\u76f8\u5173\u7528\u6237\uff01");
            }
            this.cm.setWait(false);
            System.gc();
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    public void handleHttpError(int httpid, String errostr) {
        this.cm.showAlert("\u7f51\u7edc\u8fde\u63a5\u5931\u8d25\uff01\u8bf7\u5c1d\u8bd5\u5728\u5e10\u6237\u9875\u91cd\u7f6e\u7f51\u7edc\u3002");
        this.cm.setWait(false);
    }

    public boolean receiveHttpResponse(int httpid, int type, byte[] dis) {
        block7: {
            if (httpid == 0) {
                return this.cm.xmlEngine.receiveHttpResponse(dis, this);
            }
            if (this.loadHead) break block7;
            this.loading = false;
            return true;
        }
        try {
            Account b = (Account)this.account.elementAt(this.loadHeadIndex);
            b.headIMG = Image.createImage((byte[])dis, (int)0, (int)dis.length);
            int i = this.loadHeadIndex + 1;
            while (i < this.account.size()) {
                Account b1 = (Account)this.account.elementAt(i);
                if (b1.headUrl.equals(b.headUrl)) {
                    b1.headIMG = b.headIMG;
                }
                ++i;
            }
            this.cm.updateView(20, 1);
            ++this.loadHeadIndex;
            if (this.loadHeadIndex == this.account.size()) {
                this.loadHead = false;
                this.loadHeadIndex = 0;
            }
            this.loading = false;
            return true;
        }
        catch (IOException e) {
            return false;
        }
    }

    public void loadNextHead() {
        this.loading = true;
        if (((Account)this.account.elementAt((int)this.loadHeadIndex)).headIMG == null) {
            this.cm.httpEngine.HttpConnect(2, 0, ((Account)this.account.elementAt((int)this.loadHeadIndex)).headUrl, null, this, HttpEngine.HIGH);
        } else {
            ++this.loadHeadIndex;
            if (this.loadHeadIndex >= this.account.size()) {
                this.loadHead = false;
                this.loadHeadIndex = 0;
            }
            this.loading = false;
        }
    }
}

