/*
 * Decompiled with CFR 0.152.
 */
package com.sina.weibo.view;

import com.sina.ui.AlertListener;
import com.sina.ui.BackItem;
import com.sina.ui.ControlItem;
import com.sina.ui.ImageItem;
import com.sina.ui.ListItem;
import com.sina.ui.ListListener;
import com.sina.ui.ListRollContainer;
import com.sina.ui.MenuItem;
import com.sina.weibo.ClientManager;
import com.sina.weibo.comm.G;
import com.sina.weibo.comm.Tools;
import com.sina.weibo.data.Account;
import com.sina.weibo.data.AccountListModel;
import com.sina.weibo.view.AbstractView;

public class AccountView
extends AbstractView
implements ListListener,
AlertListener {
    private String[] menuItems = new String[]{"\u6253\u5f00", "\u5220\u9664", "\u91cd\u7f6e\u7f51\u7edc"};
    private AccountListModel alm;
    private BackItem li;

    public AccountView(ClientManager cm, AccountListModel alm) {
        super(cm);
        this.viewID = 7;
        this.alm = alm;
        this.init();
    }

    public void keyPressed(int keyCode) {
        if (this.menu.isOpen) {
            this.menuKeyPressed(keyCode);
            return;
        }
        byte keyType = Tools.keyCompare(keyCode);
        switch (keyType) {
            case 3: 
            case 5: 
            case 7: {
                super.keyPressed(keyCode);
                break;
            }
            case 6: {
                this.cm.quit();
                break;
            }
            case 1: {
                if (!this.list.movePre()) break;
                this.list.gotFocus((byte)1);
                break;
            }
            case 2: {
                if (!this.list.moveNext()) break;
                this.list.gotFocus((byte)0);
                break;
            }
            case 4: {
                if (this.list.getSelectedID() <= 0) break;
                this.list.doEntry();
            }
        }
    }

    public void destroy() {
    }

    public void doMenuItem(int id) {
        switch (id) {
            case 0: {
                this.list.doEntry();
                break;
            }
            case 1: {
                this.cm.showDialog("", "\u662f\u5426\u5220\u9664\u6b64\u8d26\u6237\uff1f", this);
                break;
            }
            case 2: {
                this.cm.initProxy();
                break;
            }
        }
        this.closeMenuList();
    }

    private void init() {
        this.li = new BackItem("\u5fae\u535a");
        this.li.setPaintx(0);
        this.li.setPainty(0);
        this.li.setWidth(G.W);
        this.lrc.addItem(this.li);
        this.lrc.setBackColor(0xD1D1D1);
        this.list = new ListRollContainer(G.W, G.H - this.li.getHeight() - G.MenuBarHeight);
        this.list.setPainty(this.li.getHeight());
        this.list.setBackColor(0xD1D1D1);
        this.lrc.addItem(this.list);
        this.menu.setRight("\u9000\u51fa");
        this.update(0);
    }

    public void update(int type) {
        ImageItem lable;
        this.list.removeAll();
        if (this.alm != null && this.alm.account != null && this.alm.account.size() > 0) {
            lable = new ImageItem("/acc.png");
            lable.showLine();
            lable.setWidth(G.W);
            lable.setalign(1);
            this.list.addItem(lable);
            int i = 0;
            while (i < this.alm.account.size()) {
                Account account = (Account)this.alm.account.elementAt(i);
                ListItem li = new ListItem(account.nick, i, (ListListener)this, this.list, 2);
                li.showLine();
                li.showRight();
                this.list.addItem(li);
                ++i;
            }
        }
        lable = new ImageItem("/add.png");
        lable.showLine();
        lable.setWidth(G.W);
        lable.setalign(1);
        this.list.addItem(lable);
        ListItem res = new ListItem("\u6ce8\u518c\u65b0\u7528\u6237", -1, (ListListener)this, this.list, 2);
        res.showLine();
        res.showRight();
        this.list.addItem(res);
        ListItem add = new ListItem("\u6dfb\u52a0\u5df2\u6709\u8d26\u53f7", -2, (ListListener)this, this.list, 2);
        add.showLine();
        add.showRight();
        this.list.addItem(add);
        ListItem defaut = new ListItem("\u6e38\u5ba2\u767b\u9646", -99, (ListListener)this, this.list, 2);
        defaut.showLine();
        defaut.showRight();
        this.list.addItem(defaut);
        this.list.gotFocus((byte)1);
    }

    public void tick(long time) {
        if (this.list.getHeight() != G.H - this.li.getHeight() - G.MenuBarHeight) {
            this.list.setHeight(G.H - this.li.getHeight() - G.MenuBarHeight);
            this.render();
        }
        if (this.list.getWidth() != G.W) {
            this.list.setWidth(G.W);
            this.li.setWidth(G.W);
            int i = 0;
            while (i < this.list.getItemNumber()) {
                ((ControlItem)this.list.getItem(i)).setWidth(G.W);
                ++i;
            }
            this.render();
        }
    }

    public void listitemPressed(int id) {
        if (id >= 0) {
            this.cm.changeStageWithId(this.viewID, 3, id, false);
        } else if (id == -1) {
            this.cm.changeStageWithId(this.viewID, 2, id, false);
        } else if (id == -2) {
            this.cm.changeStageWithId(this.viewID, 1, id, false);
        } else if (id == -99) {
            try {
                this.cm.changeStageWithId(this.viewID, 10, id, false);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    protected void showMenu() {
        this.menu.clear();
        int i = 0;
        while (i < this.menuItems.length) {
            if (!(this.alm.account.size() == 0 && i == 1 || this.list.getSelectedID() > this.alm.account.size() && i == 1)) {
                MenuItem menuitem = new MenuItem(this.menuItems[i], i, this);
                this.menu.addItem(menuitem);
            }
            ++i;
        }
        this.openMenuList();
    }

    public void alertKeyPressed(int keyCode, String name) {
        byte keyType = Tools.keyCompare(keyCode);
        switch (keyType) {
            case 5: 
            case 7: {
                try {
                    this.alm.delete(((ListItem)this.list.getFocusItem()).getID());
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            case 6: {
                this.cm.closeAlert();
            }
        }
    }
}

