/*
 * Decompiled with CFR 0.152.
 */
package com.funambol.push;

import com.funambol.storage.Serializable;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class PushConfig
implements Serializable {
    private int push = 0;
    private int polling = 0;
    private boolean queuePush = false;
    private String deviceId = "";
    private int ctpRetry = 5;
    private int ctpMaxRetry = 900;
    private int ctpCmdTimeout = 60;
    private int ctpConnTimeout = 0;
    private int ctpReady = 300;
    private byte[] ctpNonce = new byte[0];
    private int ctpNotifyTimeout = 180;
    private String ctpServer = "";
    private int ctpPort = 4745;
    private String ctpUsername = "";
    private String ctpPassword = "";

    public void serialize(DataOutputStream dout) throws IOException {
        dout.writeInt(this.push);
        dout.writeInt(this.polling);
        dout.writeBoolean(this.queuePush);
        dout.writeUTF(this.deviceId);
        dout.writeInt(this.ctpRetry);
        dout.writeInt(this.ctpMaxRetry);
        dout.writeInt(this.ctpCmdTimeout);
        dout.writeInt(this.ctpConnTimeout);
        dout.writeInt(this.ctpPort);
        dout.writeInt(this.ctpReady);
        dout.writeInt(this.ctpNonce.length);
        dout.write(this.ctpNonce, 0, this.ctpNonce.length);
        dout.writeInt(this.ctpNotifyTimeout);
        dout.writeUTF(this.ctpUsername);
        dout.writeUTF(this.ctpPassword);
    }

    public void deserialize(DataInputStream in) throws IOException {
        this.push = in.readInt();
        this.polling = in.readInt();
        this.queuePush = in.readBoolean();
        this.deviceId = in.readUTF();
        this.ctpRetry = in.readInt();
        this.ctpMaxRetry = in.readInt();
        this.ctpCmdTimeout = in.readInt();
        this.ctpConnTimeout = in.readInt();
        this.ctpPort = in.readInt();
        this.ctpReady = in.readInt();
        int ctpNonceLen = in.readInt();
        this.ctpNonce = new byte[ctpNonceLen];
        in.read(this.ctpNonce, 0, ctpNonceLen);
        this.ctpNotifyTimeout = in.readInt();
        this.ctpUsername = in.readUTF();
        this.ctpPassword = in.readUTF();
    }

    public boolean getQueuePush() {
        return this.queuePush;
    }

    public void setQueuePush(boolean v) {
        this.queuePush = v;
    }

    public int getCtpRetry() {
        return this.ctpRetry;
    }

    public void setCtpRetry(int v) {
        this.ctpRetry = v;
    }

    public int getCtpMaxRetry() {
        return this.ctpMaxRetry;
    }

    public void setCtpMaxRetry(int v) {
        this.ctpMaxRetry = v;
    }

    public int getCtpCmdTimeout() {
        return this.ctpCmdTimeout;
    }

    public void setCtpCmdTimeout(int v) {
        this.ctpCmdTimeout = v;
    }

    public int getCtpConnTimeout() {
        return this.ctpConnTimeout;
    }

    public void setCtpConnTimeout(int v) {
        this.ctpConnTimeout = v;
    }

    public int getCtpPort() {
        return this.ctpPort;
    }

    public void setCtpPort(int v) {
        this.ctpPort = v;
    }

    public int getCtpReady() {
        return this.ctpReady;
    }

    public void setCtpReady(int v) {
        this.ctpReady = v;
    }

    public byte[] getCtpNonce() {
        return this.ctpNonce;
    }

    public void setCtpNonce(byte[] ctpNonce) {
        this.ctpNonce = ctpNonce;
    }

    public int getCtpNotifyTimeout() {
        return this.ctpNotifyTimeout;
    }

    public void setCtpNotifyTimeout(int v) {
        this.ctpNotifyTimeout = v;
    }

    public String getCtpUsername() {
        return this.ctpUsername;
    }

    public void setCtpUsername(String username) {
        this.ctpUsername = username;
    }

    public String getCtpPassword() {
        return this.ctpPassword;
    }

    public void setCtpPassword(String password) {
        this.ctpPassword = password;
    }

    public String getDeviceId() {
        return this.deviceId;
    }

    public void setDeviceId(String deviceId) {
        this.deviceId = deviceId;
    }

    public String getCtpServer() {
        return this.ctpServer;
    }

    public void setCtpServer(String server) {
        this.ctpServer = server;
    }

    public String toString() {
        StringBuffer out = new StringBuffer();
        out.append("CTP Server: " + this.getCtpServer() + "\n");
        out.append("CTP Port: " + this.getCtpPort() + "\n");
        out.append("CTP Username: " + this.getCtpUsername() + "\n");
        out.append("CTP Notify Timeout: " + this.getCtpNotifyTimeout() + "\n");
        out.append("CTP Cmd Timeout: " + this.getCtpCmdTimeout() + "\n");
        out.append("CTP HB Timeout: " + this.getCtpReady() + "\n");
        return out.toString();
    }
}

