/*
 * Decompiled with CFR 0.152.
 */
package com.funambol.storage;

import com.funambol.storage.ObjectMap;
import com.funambol.storage.ObjectStore;
import com.funambol.storage.Serializable;
import com.funambol.util.Log;
import java.io.IOException;
import javax.microedition.rms.RecordStoreException;

public class NamedObjectStore {
    private ObjectStore objs = new ObjectStore();
    private ObjectMap objmap = new ObjectMap(this.objs);

    public boolean open(String name) throws RecordStoreException, IOException {
        if (this.objs.open(name)) {
            this.objmap.load();
            return true;
        }
        return false;
    }

    public void close() throws RecordStoreException {
        this.objs.close();
    }

    public boolean create(String name) throws RecordStoreException, IOException {
        if (this.objs.create(name)) {
            if (this.objs.size() > 0) {
                this.objmap.load();
            } else {
                this.objmap.init();
            }
            return true;
        }
        return false;
    }

    public boolean store(String name, Serializable obj) throws RecordStoreException, IOException {
        int index = this.objmap.lookup(name);
        if (index > 0) {
            this.objs.store(index, obj);
            return false;
        }
        index = this.objs.store(obj);
        this.objmap.add(name, index);
        return true;
    }

    public Serializable retrieve(String name, Serializable obj) throws RecordStoreException, IOException {
        int index = this.objmap.lookup(name);
        if (index == 0) {
            throw new RecordStoreException("Object not found: " + name);
        }
        return this.objs.retrieve(index, obj);
    }

    public Serializable retrieve(int index, Serializable obj) throws RecordStoreException, IOException {
        return this.objs.retrieve(index, obj);
    }

    public String[] names() {
        return this.objmap.list();
    }

    public int lookup(String name) {
        int index = this.objmap.lookup(name);
        if (index == 0) {
            return 0;
        }
        return index;
    }

    public Serializable getFirstObject(Serializable obj) throws RecordStoreException, IOException {
        int index = this.objs.getFirstIndex();
        if (index == 0) {
            return null;
        }
        if (index == 1 && (index = this.objs.getNextIndex()) == 0) {
            return null;
        }
        return this.objs.retrieve(index, obj);
    }

    public Serializable getNextObject(Serializable obj) throws RecordStoreException, IOException {
        int index = this.objs.getNextIndex();
        if (index == 0) {
            return null;
        }
        if (index == 1 && (index = this.objs.getNextIndex()) == 0) {
            return null;
        }
        return this.objs.retrieve(index, obj);
    }

    public boolean remove(String name) throws RecordStoreException, IOException {
        int index = this.objmap.lookup(name);
        if (index == 0) {
            Log.error("NamedObjStore.remove(): " + name + " not found");
            return false;
        }
        this.objs.remove(index);
        this.objmap.del(name);
        return true;
    }

    public int size() {
        int ret = this.objs.size();
        if (ret == -1) {
            return -1;
        }
        return ret - 1;
    }

    public int getAvaliableStorage() {
        return this.objs.getAvaliableStorage();
    }
}

