/*
 * Decompiled with CFR 0.152.
 */
package com.funambol.storage;

import com.funambol.storage.StringKeyValueStore;
import com.funambol.util.Log;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.microedition.io.Connector;
import javax.microedition.io.file.FileConnection;

public class StringKeyValueFileStore
implements StringKeyValueStore {
    protected Hashtable store = new Hashtable();
    protected String fileName;
    private static final int LF = 10;
    private static final char SEPARATOR = '=';

    public StringKeyValueFileStore(String fileName) {
        this.fileName = fileName;
    }

    public String put(String key, String value) {
        return this.store.put(key, value);
    }

    public String get(String key) {
        return (String)this.store.get(key);
    }

    public Enumeration keys() {
        return this.store.keys();
    }

    public boolean contains(String key) {
        return this.store.get(key) != null;
    }

    public String remove(String key) {
        return (String)this.store.remove(key);
    }

    public void save() throws IOException {
        try {
            OutputStream os;
            FileConnection fc = (FileConnection)Connector.open((String)this.fileName, (int)3);
            if (!fc.exists()) {
                fc.create();
                os = fc.openOutputStream();
            } else {
                fc.truncate(0L);
                os = fc.openOutputStream();
            }
            Enumeration keys = this.store.keys();
            while (keys.hasMoreElements()) {
                String key = (String)keys.nextElement();
                String value = this.get(key);
                os.write(key.getBytes());
                os.write(61);
                os.write(value.getBytes());
                os.write(10);
            }
            os.close();
            fc.close();
        }
        catch (Exception e) {
            Log.error("Cannot save cache file");
            throw new IOException(e.toString());
        }
    }

    public void load() throws IOException {
        try {
            FileConnection fc = (FileConnection)Connector.open((String)this.fileName, (int)1);
            if (!fc.exists()) {
                throw new IOException("File not found");
            }
            InputStream is = fc.openInputStream();
            StringBuffer currentLine = new StringBuffer();
            for (long i = 0L; i < fc.fileSize(); ++i) {
                char b = (char)is.read();
                if (b == '\n') {
                    String line = currentLine.toString().trim();
                    int pos = line.indexOf(61);
                    if (pos <= 0) {
                        throw new IOException("Malformed String Store file");
                    }
                    String key = line.substring(0, pos);
                    String value = line.substring(pos + 1, line.length());
                    this.put(key, value);
                    currentLine = new StringBuffer();
                    continue;
                }
                currentLine.append(b);
            }
            is.close();
            fc.close();
        }
        catch (Exception e) {
            Log.error("Cannot load cache file");
            throw new IOException(e.toString());
        }
    }

    public void reset() throws IOException {
        try {
            FileConnection fc = (FileConnection)Connector.open((String)this.fileName, (int)3);
            if (fc.exists()) {
                fc.truncate(0L);
            }
            fc.close();
        }
        catch (Exception e) {
            throw new IOException(e.toString());
        }
        this.store = new Hashtable();
    }
}

