/*
 * Decompiled with CFR 0.152.
 */
package com.funambol.syncml.client;

import com.funambol.storage.StringKeyValueStore;
import com.funambol.syncml.client.ChangesTracker;
import com.funambol.syncml.client.TrackableSyncSource;
import com.funambol.syncml.client.TrackerException;
import com.funambol.syncml.protocol.SyncMLStatus;
import com.funambol.syncml.spds.SyncItem;
import com.funambol.util.Base64;
import com.funambol.util.Log;
import com.funambol.util.MD5;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;

public class CacheTracker
implements ChangesTracker {
    private Hashtable newItems;
    private Hashtable deletedItems;
    private Hashtable updatedItems;
    private TrackableSyncSource ss;
    private StringKeyValueStore status;

    public CacheTracker(StringKeyValueStore stringKeyValueStore) {
        this.ss = this.ss;
        this.status = stringKeyValueStore;
    }

    public void setSyncSource(TrackableSyncSource trackableSyncSource) {
        this.ss = trackableSyncSource;
    }

    public void reset() throws TrackerException {
    }

    public void begin() throws TrackerException {
        String string;
        Object object;
        Object object2;
        Log.trace("[CacheTracker.begin]");
        Enumeration enumeration = this.ss.getAllItemsKeys();
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        this.newItems = new Hashtable();
        this.updatedItems = new Hashtable();
        this.deletedItems = new Hashtable();
        while (enumeration.hasMoreElements()) {
            object2 = (String)enumeration.nextElement();
            object = new SyncItem((String)object2);
            object = this.ss.getItemContent((SyncItem)object);
            Log.trace("Computing fingerprint for " + ((SyncItem)object).getKey());
            string = this.computeFingerprint((SyncItem)object);
            Log.trace("Fingerpint is: " + string);
            hashtable.put(((SyncItem)object).getKey(), string);
        }
        try {
            this.status.load();
        }
        catch (Exception exception) {
            Log.debug("Cannot load tracker status, create an empty one");
            try {
                this.status.save();
            }
            catch (Exception exception2) {
                Log.error("Cannot load tracker status");
                throw new TrackerException(exception.toString());
            }
        }
        object2 = hashtable.keys();
        while (object2.hasMoreElements()) {
            String string2;
            object = (String)object2.nextElement();
            if (this.status.get((String)object) == null) {
                Log.trace("Found a new item with key: " + (String)object);
                this.newItems.put(object, hashtable.get(object));
                continue;
            }
            string = this.status.get((String)object);
            if (string.equals(string2 = (String)hashtable.get(object))) continue;
            Log.trace("Found an updated item with key: " + (String)object);
            this.updatedItems.put(object, string2);
        }
        object = this.status.keys();
        while (object.hasMoreElements()) {
            string = (String)object.nextElement();
            if (hashtable.get(string) != null) continue;
            Log.trace("Found a deleted item with key: " + string);
            this.deletedItems.put(string, this.status.get(string));
        }
    }

    public void end() throws TrackerException {
        Log.trace("[CacheTracker.end]");
        try {
            this.status.save();
        }
        catch (IOException iOException) {
            Log.error("Cannot save the cache data store");
        }
        this.newItems = null;
        this.updatedItems = null;
        this.deletedItems = null;
    }

    public Enumeration getNewItems() throws TrackerException {
        Log.trace("[CacheTracker.getNewItems]");
        if (this.newItems != null) {
            return this.newItems.keys();
        }
        return null;
    }

    public int getNewItemsCount() throws TrackerException {
        if (this.newItems != null) {
            return this.newItems.size();
        }
        return 0;
    }

    public Enumeration getUpdatedItems() throws TrackerException {
        Log.trace("[CacheTracker.getUpdatedItems]");
        if (this.updatedItems != null) {
            return this.updatedItems.keys();
        }
        return null;
    }

    public int getUpdatedItemsCount() throws TrackerException {
        if (this.updatedItems != null) {
            return this.updatedItems.size();
        }
        return 0;
    }

    public Enumeration getDeletedItems() throws TrackerException {
        Log.trace("[CacheTracker.getDeletedItems]");
        if (this.deletedItems != null) {
            return this.deletedItems.keys();
        }
        return null;
    }

    public int getDeletedItemsCount() throws TrackerException {
        if (this.deletedItems != null) {
            return this.deletedItems.size();
        }
        return 0;
    }

    public void setItemStatus(String string, int n) throws TrackerException {
        Log.trace("[CacheTracker.setItemStatus] " + string + "," + n);
        if (this.isSuccess(n)) {
            if (this.newItems.get(string) != null) {
                String string2 = (String)this.newItems.get(string);
                this.status.put(string, string2);
            } else if (this.updatedItems.get(string) != null) {
                String string3 = (String)this.updatedItems.get(string);
                this.status.put(string, string3);
            } else if (this.deletedItems.get(string) != null) {
                this.status.remove(string);
            }
        }
    }

    protected String computeFingerprint(SyncItem syncItem) {
        Log.trace("[CacheTracker.computeFingerprint]");
        byte[] byArray = syncItem.getContent();
        MD5 mD5 = new MD5();
        byte[] byArray2 = mD5.calculateMD5(byArray);
        byte[] byArray3 = Base64.encode(byArray2);
        return new String(byArray3);
    }

    protected boolean isSuccess(int n) {
        Log.trace("[CacheTracker.isSuccess] " + n);
        return SyncMLStatus.isSuccess(n);
    }

    public boolean removeItem(SyncItem syncItem) throws TrackerException {
        boolean bl = true;
        switch (syncItem.getState()) {
            case 'N': {
                String string = this.computeFingerprint(syncItem);
                this.status.put(syncItem.getKey(), string);
                break;
            }
            case 'U': {
                String string = this.computeFingerprint(syncItem);
                this.status.put(syncItem.getKey(), string);
                break;
            }
            case 'D': {
                this.status.remove(syncItem.getKey());
                break;
            }
            default: {
                Log.error("Cache Tracker cannot remove item");
                bl = false;
            }
        }
        return bl;
    }
}

