/*
 * Decompiled with CFR 0.152.
 */
package com.funambol.syncml.client;

import com.funambol.storage.StringKeyValueStore;
import com.funambol.syncml.client.ChangesTracker;
import com.funambol.syncml.client.TrackableSyncSource;
import com.funambol.syncml.spds.SourceConfig;
import com.funambol.syncml.spds.SyncException;
import com.funambol.syncml.spds.SyncItem;
import com.funambol.util.Log;
import java.util.Enumeration;

public class ConfigSyncSource
extends TrackableSyncSource {
    private StringKeyValueStore store = null;

    public ConfigSyncSource(SourceConfig sourceConfig, ChangesTracker changesTracker, StringKeyValueStore stringKeyValueStore) {
        super(sourceConfig, changesTracker);
        this.store = stringKeyValueStore;
        this.tracker = changesTracker;
        changesTracker.setSyncSource(this);
    }

    public void beginSync(int n) throws SyncException {
        super.beginSync(n);
        try {
            this.store.load();
        }
        catch (Exception exception) {
            throw new SyncException(400, "Cannot load config store " + exception.toString());
        }
    }

    public void endSync() throws SyncException {
        super.endSync();
        try {
            this.store.save();
        }
        catch (Exception exception) {
            throw new SyncException(400, "Cannot save config store " + exception.toString());
        }
    }

    protected Enumeration getAllItemsKeys() throws SyncException {
        Enumeration enumeration = this.store.keys();
        return enumeration;
    }

    public int addItem(SyncItem syncItem) throws SyncException {
        String string = syncItem.getKey();
        String string2 = new String(syncItem.getContent());
        this.store.put(string, string2);
        return 200;
    }

    public int updateItem(SyncItem syncItem) throws SyncException {
        return this.addItem(syncItem);
    }

    public int deleteItem(String string) throws SyncException {
        this.store.remove(string);
        return 200;
    }

    protected SyncItem getItemContent(SyncItem syncItem) throws SyncException {
        Log.trace("[ConfigSyncSource.getItemContent");
        String string = syncItem.getKey();
        String string2 = this.store.get(string);
        SyncItem syncItem2 = new SyncItem(syncItem);
        syncItem2.setContent(string2.getBytes());
        return syncItem2;
    }
}

