/*
 * Decompiled with CFR 0.152.
 */
package com.funambol.syncml.client;

import com.funambol.syncml.client.ChangesTracker;
import com.funambol.syncml.client.TrackableSyncSource;
import com.funambol.syncml.spds.SourceConfig;
import com.funambol.syncml.spds.SyncException;
import com.funambol.syncml.spds.SyncItem;
import com.funambol.util.Log;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Vector;
import javax.microedition.io.Connector;
import javax.microedition.io.file.FileConnection;

public class FileSyncSource
extends TrackableSyncSource {
    private String directory;
    private LargeObject outgoingLo;
    private int maxMsgSize = 32768;

    public FileSyncSource(SourceConfig sourceConfig, ChangesTracker changesTracker, String string) {
        super(sourceConfig, changesTracker);
        this.directory = string;
        this.tracker = changesTracker;
        this.outgoingLo = null;
        changesTracker.setSyncSource(this);
        sourceConfig.setEncoding("b64");
    }

    public void beginSync(int n) throws SyncException {
        super.beginSync(n);
        this.outgoingLo = null;
    }

    protected Enumeration getAllItemsKeys() throws SyncException {
        Log.trace("[FileSyncSource.getAllItemsKeys]");
        try {
            FileConnection fileConnection = (FileConnection)Connector.open((String)this.directory, (int)1);
            Enumeration enumeration = fileConnection.list();
            Vector<String> vector = new Vector<String>();
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                FileConnection fileConnection2 = (FileConnection)Connector.open((String)(this.directory + string), (int)1);
                if (!fileConnection2.isDirectory()) {
                    vector.addElement(string);
                }
                fileConnection2.close();
            }
            fileConnection.close();
            return vector.elements();
        }
        catch (Exception exception) {
            throw new SyncException(400, exception.toString());
        }
    }

    public SyncItem getNextItem() throws SyncException {
        Log.trace("[FileSyncSource.getNextItem]");
        try {
            long l;
            if (this.outgoingLo != null) {
                SyncItem syncItem = this.getNextChunk(this.outgoingLo, true);
                return syncItem;
            }
            SyncItem syncItem = super.getNextItem();
            if (syncItem != null && (l = this.mustBeSplit(syncItem)) != -1L) {
                String string = this.directory + syncItem.getKey();
                this.outgoingLo = new LargeObject(syncItem.getKey(), string);
                syncItem = this.getNextChunk(this.outgoingLo, true);
                syncItem.setLODeclaredSize(l);
            }
            return syncItem;
        }
        catch (Exception exception) {
            throw new SyncException(400, exception.toString());
        }
    }

    public SyncItem getNextNewItem() throws SyncException {
        Log.trace("[FileSyncSource.getNextNewItem]");
        try {
            long l;
            if (this.outgoingLo != null) {
                SyncItem syncItem = this.getNextChunk(this.outgoingLo, true);
                return syncItem;
            }
            SyncItem syncItem = super.getNextNewItem();
            if (syncItem != null && (l = this.mustBeSplit(syncItem)) != -1L) {
                String string = this.directory + syncItem.getKey();
                this.outgoingLo = new LargeObject(syncItem.getKey(), string);
                syncItem = this.getNextChunk(this.outgoingLo, true);
                syncItem.setLODeclaredSize(l);
            }
            return syncItem;
        }
        catch (Exception exception) {
            throw new SyncException(400, exception.toString());
        }
    }

    public SyncItem getNextUpdatedItem() throws SyncException {
        Log.trace("[FileSyncSource.getNextUpdatedItem]");
        try {
            long l;
            if (this.outgoingLo != null) {
                SyncItem syncItem = this.getNextChunk(this.outgoingLo, true);
                return syncItem;
            }
            SyncItem syncItem = super.getNextUpdatedItem();
            if (syncItem != null && (l = this.mustBeSplit(syncItem)) != -1L) {
                String string = this.directory + syncItem.getKey();
                this.outgoingLo = new LargeObject(syncItem.getKey(), string);
                syncItem = this.getNextChunk(this.outgoingLo, true);
                syncItem.setLODeclaredSize(l);
            }
            return syncItem;
        }
        catch (Exception exception) {
            throw new SyncException(400, exception.toString());
        }
    }

    private SyncItem getNextChunk(LargeObject largeObject, boolean bl) throws IOException {
        Log.trace("[FileSyncSource.getNextChunk]");
        byte[] byArray = largeObject.getNextChunk(this.maxMsgSize);
        largeObject.setChunkContent(byArray);
        SyncItem syncItem = new SyncItem(largeObject.getKey());
        if (bl) {
            syncItem.setContent(byArray);
        }
        syncItem.setChunkNumber(largeObject.getChunkNumber());
        if (!largeObject.last()) {
            syncItem.setHasMoreData();
        } else {
            this.outgoingLo = null;
        }
        return syncItem;
    }

    public int addItem(SyncItem syncItem) throws SyncException {
        return 500;
    }

    public int updateItem(SyncItem syncItem) throws SyncException {
        return 500;
    }

    public int deleteItem(String string) throws SyncException {
        return 500;
    }

    protected SyncItem getItemContent(SyncItem syncItem) throws SyncException {
        Log.debug("[FileSyncSource.getItemContent] " + syncItem.getKey());
        SyncItem syncItem2 = new SyncItem(syncItem);
        if (this.outgoingLo != null) {
            Log.trace("chunk number = " + syncItem.getChunkNumber());
            Log.trace("chunk number = " + this.outgoingLo.getChunkNumber());
            if (syncItem.getChunkNumber() == this.outgoingLo.getChunkNumber()) {
                syncItem2.setContent(this.outgoingLo.getChunkContent());
            }
        } else {
            try {
                byte[] byArray = this.readFile(syncItem.getKey());
                syncItem2.setContent(byArray);
            }
            catch (IOException iOException) {
                throw new SyncException(400, iOException.toString());
            }
        }
        return syncItem2;
    }

    private byte[] readFile(String string) throws IOException {
        FileConnection fileConnection = (FileConnection)Connector.open((String)(this.directory + string), (int)1);
        InputStream inputStream = fileConnection.openInputStream();
        int n = (int)fileConnection.fileSize();
        byte[] byArray = new byte[n];
        inputStream.read(byArray);
        inputStream.close();
        fileConnection.close();
        return byArray;
    }

    private long computeB64Size(long l) {
        long l2 = l % 3L;
        long l3 = l2 == 0L ? 4L * (l / 3L) : 4L * (l / 3L + 1L);
        return l3;
    }

    private long computeReverseB64Size(long l) {
        long l2 = l * 3L / 4L;
        for (long i = 0L; i < 3L; ++i) {
            if ((l2 + i) % 3L != 0L) continue;
            return l2 + i;
        }
        return -1L;
    }

    private long mustBeSplit(SyncItem syncItem) throws IOException {
        Log.trace("[FileSyncSource.mustBeSplit] " + syncItem.getKey());
        String string = this.directory + syncItem.getKey();
        FileConnection fileConnection = (FileConnection)Connector.open((String)string, (int)1);
        long l = this.computeB64Size((int)fileConnection.fileSize());
        fileConnection.close();
        if (l > (long)this.maxMsgSize) {
            return l;
        }
        return -1L;
    }

    private class LargeObject {
        private int offset;
        private String fileName;
        private boolean last;
        private String key;
        private int chunkNumber;
        private byte[] chunkContent;
        private FileConnection fc;
        private InputStream is;
        private boolean initialized;

        public LargeObject(String string, String string2) {
            this.key = string;
            this.fileName = string2;
            this.offset = 0;
            this.chunkNumber = -1;
            this.chunkContent = null;
            this.initialized = false;
        }

        public byte[] getNextChunk(int n) throws IOException {
            long l;
            Log.trace("[LargeObject.getNextChunk]");
            ++this.chunkNumber;
            if (!this.initialized) {
                this.fc = (FileConnection)Connector.open((String)this.fileName, (int)1);
                this.is = this.fc.openInputStream();
                this.initialized = true;
            }
            long l2 = this.fc.fileSize();
            Log.trace("fileSize = " + l2);
            Log.trace("offset = " + this.offset);
            long l3 = l2 - (long)this.offset;
            if (FileSyncSource.this.computeB64Size(l3) < (long)n) {
                this.last = true;
                l = l3;
            } else {
                this.last = false;
                l = FileSyncSource.this.computeReverseB64Size(n);
            }
            byte[] byArray = new byte[(int)l];
            Log.trace("read " + l);
            this.is.read(byArray);
            this.offset = (int)((long)this.offset + l);
            if (this.last) {
                this.is.close();
                this.fc.close();
            }
            return byArray;
        }

        public int getChunkNumber() {
            return this.chunkNumber;
        }

        public String getKey() {
            return this.key;
        }

        public boolean last() {
            return this.last;
        }

        public void setChunkContent(byte[] byArray) {
            this.chunkContent = byArray;
        }

        public byte[] getChunkContent() {
            return this.chunkContent;
        }
    }
}

