/*
 * Decompiled with CFR 0.152.
 */
package com.funambol.syncml.client;

import com.funambol.syncml.client.BaseSyncSource;
import com.funambol.syncml.client.ChangesTracker;
import com.funambol.syncml.spds.SourceConfig;
import com.funambol.syncml.spds.SyncException;
import com.funambol.syncml.spds.SyncItem;
import com.funambol.util.Log;
import java.util.Enumeration;
import java.util.Vector;

public abstract class TrackableSyncSource
extends BaseSyncSource {
    protected ChangesTracker tracker;

    public TrackableSyncSource(SourceConfig sourceConfig, ChangesTracker changesTracker) {
        super(sourceConfig);
        this.tracker = changesTracker;
        changesTracker.setSyncSource(this);
    }

    public void beginSync(int n) throws SyncException {
        this.tracker.begin();
        super.beginSync(n);
    }

    public void endSync() throws SyncException {
        super.endSync();
        this.tracker.end();
    }

    protected void initAllItems() throws SyncException {
        Log.trace("TrackableSyncSource.initAllItems");
        Vector<SyncItem> vector = new Vector<SyncItem>();
        Enumeration enumeration = this.getAllItemsKeys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            SyncItem syncItem = new SyncItem(string);
            vector.addElement(syncItem);
        }
        this.allItems = new SyncItem[vector.size()];
        for (int i = 0; i < this.allItems.length; ++i) {
            this.allItems[i] = (SyncItem)vector.elementAt(i);
        }
    }

    protected void initNewItems() throws SyncException {
        Log.trace("TrackableSyncSource.initNewItems");
        Enumeration enumeration = this.tracker.getNewItems();
        int n = this.tracker.getNewItemsCount();
        this.newItems = this.initChangedItems(enumeration, n);
    }

    protected void initUpdItems() throws SyncException {
        Log.trace("TrackableSyncSource.initUpdItems");
        Enumeration enumeration = this.tracker.getUpdatedItems();
        int n = this.tracker.getUpdatedItemsCount();
        this.updItems = this.initChangedItems(enumeration, n);
    }

    protected void initDelItems() throws SyncException {
        Log.trace("TrackableSyncSource.initDelItems");
        Enumeration enumeration = this.tracker.getDeletedItems();
        int n = this.tracker.getDeletedItemsCount();
        this.delItems = this.initChangedItems(enumeration, n);
    }

    protected SyncItem[] initChangedItems(Enumeration enumeration, int n) {
        SyncItem[] syncItemArray = new SyncItem[n];
        for (int i = 0; i < n; ++i) {
            SyncItem syncItem;
            if (!enumeration.hasMoreElements()) {
                throw new SyncException(400, "Items count mismatch");
            }
            String string = (String)enumeration.nextElement();
            syncItemArray[i] = syncItem = new SyncItem(string);
        }
        return syncItemArray;
    }

    public void setItemStatus(String string, int n) throws SyncException {
        super.setItemStatus(string, n);
        this.tracker.setItemStatus(string, n);
    }

    protected abstract Enumeration getAllItemsKeys();
}

