/*
 * Decompiled with CFR 0.152.
 */
package com.funambol.syncml.spds;

import com.funambol.storage.Serializable;
import com.funambol.syncml.spds.DeviceConfig;
import com.funambol.util.Log;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class SyncConfig
implements Serializable {
    private static final int INTERVAL = 5;
    public static final String NAME = "SyncConfig";
    protected static final int VERSION = 600;
    private long version = 600L;
    public String syncUrl = "http://<host>:<port>/funambol/ds";
    public String userName = "guest";
    public String password = "guest";
    public String userAgent = null;
    public boolean forceCookies;
    public DeviceConfig deviceConfig = new DeviceConfig();
    public String lastServerUrl = this.syncUrl;
    public boolean compress = true;

    public long getVersion() {
        return this.version;
    }

    public void serialize(DataOutputStream dataOutputStream) throws IOException {
        dataOutputStream.writeInt(600);
        dataOutputStream.writeUTF(this.syncUrl);
        dataOutputStream.writeUTF(this.userName);
        dataOutputStream.writeUTF(this.password);
        dataOutputStream.writeUTF(this.lastServerUrl);
    }

    public void deserialize(DataInputStream dataInputStream) throws IOException {
        int n = dataInputStream.readInt();
        if (n != 600) {
            Log.error("Config version mismatch: use default.");
            return;
        }
        this.version = n;
        this.syncUrl = dataInputStream.readUTF();
        this.userName = dataInputStream.readUTF();
        this.password = dataInputStream.readUTF();
        this.deviceConfig = new DeviceConfig();
        this.lastServerUrl = dataInputStream.readUTF();
    }
}

