/*
 * Decompiled with CFR 0.152.
 */
package com.funambol.updater;

import com.funambol.updater.UpdaterConfig;
import com.funambol.updater.UpdaterListener;
import com.funambol.util.HttpTransportAgent;
import com.funambol.util.Log;
import com.funambol.util.TransportAgent;
import java.util.Date;

public class Updater {
    private UpdaterConfig config;
    private String currentVersion;
    private String component;
    private TransportAgent userTA = null;
    private UpdaterListener listener = null;

    public Updater(UpdaterConfig config, String currentVersion, String component) {
        this.config = config;
        this.currentVersion = currentVersion;
        this.component = component;
    }

    public Updater(UpdaterConfig config, String currentVersion, TransportAgent userTA) {
        this.config = config;
        this.currentVersion = currentVersion;
        this.userTA = userTA;
    }

    public void setListener(UpdaterListener listener) {
        this.listener = listener;
    }

    public void check() {
        this.checkUpdateFromServer();
        if (this.updateIsReportable() && this.isNewVersionAvailable()) {
            Log.info("[Updater] - available update");
            if (this.listener != null) {
                if (this.config.isMandatory()) {
                    Log.info("[Updater] - Mandatory update is available");
                    this.listener.mandatoryUpdateAvailable(this.config.getAvailableVersion());
                } else {
                    if (!this.config.isOptional()) {
                        Log.error("[Updater] - Unknwon update type, assume it is optional");
                    }
                    Log.info("[Updater] - Optional update is available");
                    this.listener.optionalUpdateAvailable(this.config.getAvailableVersion());
                }
            }
        }
    }

    private boolean isNewVersionAvailable() {
        String VER_SEP = ".";
        boolean possibleUpdate = false;
        String version = this.currentVersion;
        Log.info("[Updater] - current version : " + this.currentVersion);
        String fversion = this.config.getAvailableVersion();
        if (fversion == null || " ".equals(fversion)) {
            fversion = this.currentVersion;
        }
        Log.info("[Updater] - available version : " + fversion);
        int vpos = 0;
        int vfpos = 0;
        do {
            int fval;
            vpos = version.indexOf(".", 0);
            vfpos = fversion.indexOf(".", 0);
            if (vpos < 0 && version.length() > 0) {
                vpos = version.length();
            }
            if (vfpos < 0 && fversion.length() > 0) {
                vfpos = fversion.length();
            }
            if (vpos <= 0 || vfpos <= 0) continue;
            int val = Integer.parseInt(version.substring(0, vpos));
            if (val < (fval = Integer.parseInt(fversion.substring(0, vfpos)))) {
                Log.debug("[Updater] - Current version is old");
                possibleUpdate = true;
                break;
            }
            if (val > fval) {
                Log.debug("[Updater] - Current version isn't old");
                break;
            }
            if (vpos < version.length()) {
                version = version.substring(vpos + 1);
            } else {
                vpos = -1;
            }
            if (vfpos < fversion.length()) {
                fversion = fversion.substring(vfpos + 1);
                continue;
            }
            vfpos = -1;
        } while (vpos > 0 && vfpos > 0);
        return possibleUpdate;
    }

    private String getValueTag(String string, String tag) {
        int index = string.indexOf(tag);
        if (index < 0) {
            return null;
        }
        String tmp = string.substring(index);
        int end = tmp.indexOf("\n");
        if (end < 0 && (end = tmp.indexOf("\r")) < 0) {
            return null;
        }
        String value = tmp.substring(tag.length(), end);
        return value;
    }

    private boolean isTimeToRefresh() {
        long now = System.currentTimeMillis();
        boolean refresh = false;
        long lastCheck = this.config.getLastCheck();
        Log.info("[Updater] - isTimeToRefresh - Now Date is: " + new Date(now) + " Last Check Date was " + new Date(lastCheck));
        if (now - lastCheck >= this.config.getCheckInterval()) {
            Log.info("[Updater] - isTimeToRefresh - Update info need to be refreshed. Last Check was " + new Date(lastCheck));
            refresh = true;
            this.config.save();
        }
        return refresh;
    }

    private void checkUpdateFromServer() {
        String VERSION_TAG = "version=";
        String URL_TAG = "url=";
        String TYPE_TAG = "type=";
        String BEGIN_TAG = "swup_begin";
        String END_TAG = "swup_end";
        String NL = "\n";
        if (this.isTimeToRefresh()) {
            StringBuffer urlParams = new StringBuffer();
            urlParams.append("/updateserver/update?component=").append(this.component);
            urlParams.append("&version=" + this.currentVersion);
            String url = this.config.getUrl() + urlParams.toString();
            Log.info("[Updater] - checkUpdateFromServer - update url: " + url);
            TransportAgent ta = this.userTA != null ? this.userTA : new HttpTransportAgent(url, false, false);
            try {
                String downloadUrl;
                String type;
                String updateProperties = ta.sendMessage("");
                String version = this.getValueTag(updateProperties, "version=");
                if (version != null) {
                    if (!version.equals(this.config.getAvailableVersion())) {
                        this.config.setSkip(false);
                    }
                    this.config.setAvailableVersion(version);
                }
                if ((type = this.getValueTag(updateProperties, "type=")) != null) {
                    this.config.setType(type);
                }
                if ((downloadUrl = this.getValueTag(updateProperties, "url=")) != null) {
                    this.config.setDownloadUrl(downloadUrl);
                }
                this.config.setLastCheck(System.currentTimeMillis());
                this.config.save();
                Log.info("[Updater] - availableVersion :" + this.config.getAvailableVersion());
                Log.info("[Updater] - updateType :" + this.config.getType());
                Log.info("[Updater] - updateURL :" + this.config.getUrl());
                Log.info("[Updater] - lastUpdateCheck :" + this.config.getLastCheck());
            }
            catch (Throwable t) {
                Log.error("[Updater] - checkUpdateFromServer - " + t.toString());
            }
        } else {
            Log.info("[Updater] - No refresh update info from server needs");
        }
    }

    private boolean updateIsReportable() {
        if (this.config.getSkip()) {
            return false;
        }
        long now = System.currentTimeMillis();
        Log.info("[Updater] - now: " + new Date(now));
        Date next = new Date(this.config.getLastReminder() + this.config.getReminderInterval());
        Log.info("[Updater] - next update remind: " + next);
        return this.config.getLastReminder() + this.config.getReminderInterval() <= now;
    }

    public void setLastReminder(long time) {
        this.config.setLastReminder(time);
        this.config.save();
    }

    public void setSkip() {
        this.config.setSkip(true);
        this.config.save();
    }

    public boolean isUpdateAvailable() {
        String availableVersion = this.config.getAvailableVersion();
        return availableVersion != null && this.isNewVersionAvailable();
    }
}

