/*
 * Decompiled with CFR 0.152.
 */
package com.funambol.util;

import com.funambol.storage.DataAccessException;
import com.funambol.util.Appender;
import com.funambol.util.MailDateFormatter;
import com.funambol.util.RMSAppender;
import java.util.Date;

public class Log {
    public static final int DISABLED = -1;
    public static final int ERROR = 0;
    public static final int INFO = 1;
    public static final int DEBUG = 2;
    public static final int TRACE = 3;
    private static final int PROFILING = -2;
    private static Appender out;
    private static int level;
    private static long initialTimeStamp;

    private Log() {
    }

    public static void initLog(Appender object, int level) {
        Log.setLogLevel(level);
        out = object;
        if (level > -1) {
            Log.writeLogMessage(level, "INITLOG", "---------");
        }
    }

    public static void initLog(Appender object) {
        out = object;
        out.initLogFile();
    }

    public static void deleteLog() {
        out.deleteLogFile();
    }

    public static void setLogLevel(int newlevel) {
        level = newlevel;
        if (level != -1 && out instanceof RMSAppender) {
            if (newlevel == 2) {
                RMSAppender.setDefaultLogFileSize(10240);
            } else {
                RMSAppender.setDefaultLogFileSize(5120);
            }
        }
    }

    public static int getLogLevel() {
        return level;
    }

    public static void error(String msg) {
        Log.writeLogMessage(0, "ERROR", msg);
    }

    public static void error(Object obj, String msg) {
        String message = "[" + obj.getClass().getName() + "] " + msg;
        Log.writeLogMessage(0, "ERROR", message);
    }

    public static void info(String msg) {
        Log.writeLogMessage(1, "INFO", msg);
    }

    public static void info(Object obj, String msg) {
        Log.writeLogMessage(1, "INFO", msg);
    }

    public static void debug(String msg) {
        Log.writeLogMessage(2, "DEBUG", msg);
    }

    public static void debug(Object obj, String msg) {
        String message = "[" + obj.getClass().getName() + "] " + msg;
        Log.writeLogMessage(2, "DEBUG", message);
    }

    public static void trace(String msg) {
        Log.writeLogMessage(3, "TRACE", msg);
    }

    public static void trace(Object obj, String msg) {
        String message = "[" + obj.getClass().getName() + "] " + msg;
        Log.writeLogMessage(3, "TRACE", message);
    }

    public static void memoryStats(String msg) {
        long available = Runtime.getRuntime().freeMemory();
        Runtime.getRuntime().gc();
        Log.writeLogMessage(-2, "PROFILING-MEMORY", msg + ":" + available + " [bytes]");
    }

    public static void memoryStats(Object obj, String msg) {
        Runtime.getRuntime().gc();
        long available = Runtime.getRuntime().freeMemory();
        Log.writeLogMessage(-2, "PROFILING-MEMORY", obj.getClass().getName() + "::" + msg + ":" + available + " [bytes]");
    }

    public static void timeStats(String msg) {
        long time = System.currentTimeMillis();
        if (initialTimeStamp == -1L) {
            Log.writeLogMessage(-2, "PROFILING-TIME", msg + ": 0 [msec]");
            initialTimeStamp = time;
        } else {
            long currentTime = time - initialTimeStamp;
            Log.writeLogMessage(-2, "PROFILING-TIME", msg + ": " + currentTime + "[msec]");
        }
    }

    public static void timeStats(Object obj, String msg) {
        long time = System.currentTimeMillis();
        if (initialTimeStamp == -1L) {
            Log.writeLogMessage(-2, "PROFILING-TIME", obj.getClass().getName() + "::" + msg + ": 0 [msec]");
            initialTimeStamp = time;
        } else {
            long currentTime = time - initialTimeStamp;
            Log.writeLogMessage(-2, "PROFILING-TIME", obj.getClass().getName() + "::" + msg + ":" + currentTime + " [msec]");
        }
    }

    public static void stats(String msg) {
        Log.memoryStats(msg);
        Log.timeStats(msg);
    }

    public static void stats(Object obj, String msg) {
        Log.memoryStats(obj, msg);
        Log.timeStats(obj, msg);
    }

    private static void writeLogMessage(int msgLevel, String levelMsg, String msg) {
        if (level >= msgLevel) {
            try {
                if (out != null) {
                    out.writeLogMessage(levelMsg, msg);
                } else {
                    System.out.print(MailDateFormatter.dateToUTC(new Date()));
                    System.out.print(" [" + levelMsg + "] ");
                    System.out.println(msg);
                }
            }
            catch (DataAccessException ex) {
                ex.printStackTrace();
            }
        }
    }

    static {
        level = 1;
        initialTimeStamp = -1L;
    }
}

