/*
 * Decompiled with CFR 0.152.
 */
package com.funambol.util;

import com.funambol.util.Log;
import java.util.Stack;

public class Queue {
    private Stack tasks = new Stack();
    private long defaultTimeout = 100L;

    public synchronized int size() {
        return this.tasks.size();
    }

    public synchronized void add(Object runnable) {
        this.tasks.push(runnable);
        this.notifyAll();
    }

    public synchronized Object remove() {
        Object runnable;
        while ((runnable = this.removeNoWait()) == null) {
            try {
                this.wait(this.defaultTimeout);
                continue;
            }
            catch (InterruptedException e) {
                e.printStackTrace();
                Log.error(this, "InterruptedException  in remove() method");
                continue;
            }
            break;
        }
        return runnable;
    }

    public synchronized Object removeNoWait() {
        if (!this.tasks.empty()) {
            return this.tasks.pop();
        }
        return null;
    }
}

