/*
 * Decompiled with CFR 0.152.
 */
package com.funambol.util;

import com.funambol.util.Appender;
import com.funambol.util.ConnectionManager;
import com.funambol.util.MailDateFormatter;
import java.io.OutputStream;
import java.util.Date;
import javax.microedition.io.SocketConnection;

public class SocketAppender
implements Appender {
    private String serverUrl = "socket://localhost:7456";
    private SocketConnection sc;
    private OutputStream os;

    public SocketAppender(String url) {
        System.out.println("Setting URL to: " + url);
        if (url != null) {
            this.serverUrl = "socket://" + url;
        }
        this.sc = null;
        this.os = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeLogMessage(String level, String msg) {
        block5: {
            String levelMsg = " [" + level + "] ";
            try {
                if (this.sc == null || this.os == null) break block5;
                OutputStream outputStream = this.os;
                synchronized (outputStream) {
                    this.os.write(MailDateFormatter.dateToUTC(new Date()).getBytes());
                    this.os.write(levelMsg.getBytes());
                    this.os.write(msg.getBytes());
                    this.os.write("\r\n".getBytes());
                    this.os.flush();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void initLogFile() {
        try {
            this.sc = (SocketConnection)ConnectionManager.getInstance().open(this.serverUrl);
            this.sc.setSocketOption((byte)1, 5);
            this.os = this.sc.openOutputStream();
        }
        catch (Exception e) {
            System.out.println("Cannot open socket at: " + this.serverUrl);
            e.printStackTrace();
        }
    }

    public void openLogFile() {
    }

    public void closeLogFile() {
        try {
            if (this.os != null) {
                this.os.close();
            }
            if (this.sc != null) {
                this.sc.close();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void deleteLogFile() {
    }
}

