/*
 * Decompiled with CFR 0.152.
 */
package com.funambol.util;

import com.funambol.util.ChunkedString;
import com.funambol.util.Entities;
import com.funambol.util.Log;
import com.funambol.util.StringUtil;
import com.funambol.util.XmlException;
import java.util.Hashtable;
import java.util.Vector;

public class XmlUtil {
    private XmlUtil() {
    }

    public static String escapeXml(String str) {
        if (str == null) {
            return null;
        }
        return Entities.XML.escape(str);
    }

    public static String unescapeXml(String str) {
        if (str == null) {
            return null;
        }
        return Entities.XML.unescape(str);
    }

    public static int getTag(ChunkedString xml, String tag) {
        String startTag = null;
        String endTag = null;
        int ret = -1;
        startTag = "<" + tag + ">";
        endTag = "</" + tag + ">";
        ret = xml.indexOf(startTag);
        if (ret != -1 && xml.indexOf(endTag, ret) != -1) {
            return ret;
        }
        startTag = "<" + tag + " ";
        ret = xml.indexOf(startTag);
        if (ret != -1 && xml.indexOf(endTag, ret) != -1) {
            return ret;
        }
        ret = xml.indexOf("<" + tag + "/>");
        if (ret != -1) {
            return ret;
        }
        return -1;
    }

    public static Hashtable getTagAttributes(ChunkedString xml, String tag) {
        int space;
        String startTag = null;
        Object endTag = null;
        int tagPos = 0;
        int endPos = 0;
        Hashtable<String, String> ret = new Hashtable<String, String>();
        startTag = "<" + tag + " ";
        tagPos = xml.indexOf(startTag);
        endPos = xml.indexOf(">", tagPos);
        if (tagPos != -1 && endPos != -1 && (space = xml.indexOf(" ")) != -1) {
            ChunkedString[] attrlist = xml.substring(space, endPos).split(",");
            int l = attrlist.length;
            for (int i = 0; i < l; ++i) {
                ChunkedString[] attr = attrlist[i].split("=");
                if (attr.length <= 1) continue;
                String val = StringUtil.trim(attr[1].toString().trim(), '\"');
                ret.put(attr[0].toString().trim(), val);
            }
        }
        return ret;
    }

    public static ChunkedString getTagValue(ChunkedString xml, String tag) throws XmlException {
        String startTag = "<" + tag + ">";
        String endTag = "</" + tag + ">";
        try {
            int stidx = xml.indexOf(startTag);
            if (stidx == -1) {
                startTag = "<" + tag + " ";
                stidx = xml.indexOf(startTag);
                if (stidx == -1) {
                    throw new XmlException("getTagValue: can't find tag: " + tag);
                }
                if ((stidx = xml.indexOf(">", stidx)) == -1) {
                    throw new XmlException("getTagValue: unclosed tag: " + tag);
                }
                ++stidx;
            } else {
                stidx += startTag.length();
            }
            int endidx = xml.indexOf(endTag, stidx);
            if (endidx == -1) {
                throw new XmlException("getTagValue: can't find tag end: " + tag);
            }
            return xml.substring(stidx, endidx);
        }
        catch (StringIndexOutOfBoundsException e) {
            Log.error("StringIndexOutofBound in getTagValue");
            throw new XmlException("Error parsing xml, tag: " + tag);
        }
    }

    public static Vector getTagValues(Vector xmlInput, String tag) throws XmlException {
        Vector<ChunkedString> xmlReturn = new Vector<ChunkedString>();
        String plainTag = "<" + tag + ">";
        String attrTag = "<" + tag + " ";
        String endTag = "</" + tag + ">";
        int endIdx = 0;
        int l = xmlInput.size();
        for (int j = 0; j < l; ++j) {
            ChunkedString xmlInputTag = (ChunkedString)xmlInput.elementAt(j);
            while (xmlInputTag.indexOf(plainTag) != -1 || xmlInputTag.indexOf(attrTag) != -1) {
                xmlReturn.addElement(XmlUtil.getTagValue(xmlInputTag, tag));
                endIdx = xmlInputTag.indexOf(endTag) + endTag.length();
                if (endIdx == -1) {
                    Log.error("getTagValues: can't find '" + endTag + "'");
                    throw new XmlException("getTagValues: parse exception.");
                }
                xmlInputTag = xmlInputTag.substring(endIdx);
            }
        }
        return xmlReturn;
    }

    public static Vector getTagValues(ChunkedString xmlInput, String tag) throws XmlException {
        Vector<ChunkedString> tmp = new Vector<ChunkedString>(1);
        tmp.addElement(xmlInput);
        return XmlUtil.getTagValues(tmp, tag);
    }

    public static void addElement(StringBuffer out, String tag) {
        out.append("<").append(tag).append("/>");
    }

    public static void addElement(StringBuffer out, String tag, String content) {
        out.append("<").append(tag).append(">").append(content).append("</").append(tag).append(">");
    }

    public static void addElementNewLine(StringBuffer out, String tag, String content, boolean escape) {
        if (content == null) {
            content = "";
            escape = false;
        }
        if (escape) {
            content = XmlUtil.escapeXml(content);
        }
        out.append("<").append(tag).append(">").append(content).append("</").append(tag).append(">\n");
    }

    public static void addElementWithTagAttr(StringBuffer out, String tag, String content, String[] attr) {
        out.append("<").append(tag);
        for (int i = 0; i < attr.length; ++i) {
            out.append(" ").append(attr[i]);
        }
        out.append(">").append(content).append("</").append(tag).append(">");
    }

    public static void addElementNewLineWithTagAttr(StringBuffer out, String tag, String content, boolean escape, String[] attr) {
        if (content == null) {
            content = "";
            escape = false;
        }
        if (escape) {
            content = XmlUtil.escapeXml(content);
        }
        out.append("<").append(tag);
        for (int i = 0; i < attr.length; ++i) {
            out.append(" ").append(attr[i]);
        }
        out.append(">").append(content).append("</").append(tag).append(">\n");
    }

    public static String createOpenTag(String tagname) {
        return "<" + tagname + ">";
    }

    public static String createOpenTagNewLine(String tagname) {
        return "<" + tagname + ">\n";
    }

    public static String createCloseTag(String tagname) {
        return "</" + tagname + ">";
    }

    public static String createCloseTagNewLine(String tagname) {
        return "</" + tagname + ">\n";
    }
}

