/*
 * Decompiled with CFR 0.152.
 */
package com.telefonica.copiagenda;

import com.telefonica.copiagenda.Locale;
import com.telefonica.copiagenda.controllers.DataController;
import com.telefonica.copiagenda.controllers.DataHandler;
import com.telefonica.copiagenda.datasync.source.CopiAgendaSyncRegister;
import com.telefonica.copiagenda.ui.ConfigurationView;
import com.telefonica.copiagenda.ui.ConfirmationView;
import com.telefonica.copiagenda.ui.InformationView;
import com.telefonica.copiagenda.ui.LogViewer;
import com.telefonica.copiagenda.ui.MainView;
import com.telefonica.copiagenda.ui.ProgressView;
import com.telefonica.copiagenda.ui.RegisterView;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.util.Date;
import javax.microedition.io.ConnectionNotFoundException;
import javax.microedition.io.Connector;
import javax.microedition.io.PushRegistry;
import javax.microedition.lcdui.Alert;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.midlet.MIDlet;
import javax.microedition.pim.PIMException;
import javax.wireless.messaging.BinaryMessage;
import javax.wireless.messaging.Message;
import javax.wireless.messaging.MessageConnection;
import javax.wireless.messaging.TextMessage;

public class CopiagendaApplication
extends MIDlet
implements CommandListener {
    private boolean midletPaused = false;
    private Command exitCommand;
    private Command backCommand;
    private Command continueCommand;
    private Command cancelCommand = null;
    private Command acceptCommand = null;
    private Command synchronizeCmd;
    private MainView iMainView = null;
    private ConfirmationView iConfirmationView = null;
    private ProgressView iProgressView = null;
    private DataController iDataController;
    private InformationView iInformationView = null;
    private RegisterView iRegisterView = null;
    private CopiAgendaSyncRegister iSyncRegister = null;
    private ConfigurationView iConfigurationView;
    private Command exitConfirmationCommand = null;
    private Command iUpdateCommand = null;
    private String[] iLatestVersion = null;
    public int iSyncMode = 0;
    private Command iDontUpdateCommand = null;
    private MessageConnection smsconn = null;
    private int iContactCount = 0;
    private boolean iPushActivated = false;
    private Command iRejectCommand = null;

    private void initialize() throws PIMException {
        this.switchDisplayable(null, (Displayable)this.getProgressView());
        this.iSyncRegister = new CopiAgendaSyncRegister();
        this.iDataController = new DataHandler(this.iProgressView, this.iSyncRegister);
        this.iDataController.initSyncFramework(this);
        this.iContactCount = this.iDataController.getItemCount();
    }

    public int getItemCount() {
        return this.iContactCount;
    }

    private MainView getMainView(int aType) {
        if (this.iMainView == null) {
            this.iMainView = new MainView(this, this.iSyncRegister);
        }
        this.iMainView.removeCommand(this.backCommand);
        this.iMainView.removeCommand(this.exitCommand);
        this.iMainView.construct(aType);
        switch (aType) {
            case 0: {
                this.iMainView.addCommand(this.getExitCommand());
                break;
            }
            case 1: {
                this.iMainView.addCommand(this.getBackCommand());
            }
        }
        this.iMainView.setCommandListener(this);
        return this.iMainView;
    }

    public void startMIDlet() {
        if (this.iPushActivated) {
            this.sanActionAccepted();
        } else if (this.dataUpToDate()) {
            this.switchDisplayable(null, (Displayable)this.getMainView(0));
        }
    }

    private boolean dataUpToDate() {
        int[] mods = this.iDataController.modificationCount();
        int total = mods[0] + mods[1] + mods[2];
        LogViewer.debug("REMIND: " + total + " | " + Integer.parseInt(this.getAppProperty("ReminderTrigger")));
        if (total >= Integer.parseInt(this.getAppProperty("ReminderTrigger"))) {
            this.switchDisplayable(null, (Displayable)this.getInformationView(3, mods));
            return false;
        }
        return true;
    }

    public void resumeMIDlet() {
        this.midletPaused = false;
    }

    public void switchDisplayable(Alert alert, Displayable nextDisplayable) {
        Display display = this.getDisplay();
        if (alert == null) {
            display.setCurrent(nextDisplayable);
        } else {
            display.setCurrent(alert, nextDisplayable);
        }
    }

    private void sync() {
        this.iProgressView.setLabel(Locale.get("PROGRESSVIEW_SYNCHRONIZING"));
        this.switchDisplayable(null, (Displayable)this.iProgressView);
        this.iProgressView.setValue(0);
        Thread sync = new Thread(){

            public void run() {
                String result = null;
                String completedMessage = null;
                switch (CopiagendaApplication.this.iSyncMode) {
                    case 0: {
                        completedMessage = Locale.get("COPY_COMPLETE");
                        result = CopiagendaApplication.this.iDataController.backupContacts();
                        break;
                    }
                    case 1: {
                        completedMessage = Locale.get("RESTORE_COMPLETE");
                        result = CopiagendaApplication.this.iDataController.restoreContacts();
                        break;
                    }
                    case 2: {
                        completedMessage = Locale.get("SYNCHRONIZATION_COMPLETE");
                        result = CopiagendaApplication.this.iDataController.bidirectionalSync();
                    }
                }
                if (result == null) {
                    CopiagendaApplication.this.iMainView.updateLastSynchronizationTime();
                    CopiagendaApplication.this.switchDisplayable(null, (Displayable)CopiagendaApplication.this.getConfirmationView(4, completedMessage));
                } else {
                    CopiagendaApplication.this.switchDisplayable(null, (Displayable)CopiagendaApplication.this.getConfirmationView(3, Locale.get("SYNCHRONIZATION_ERROR_DETECTED")));
                }
                CopiagendaApplication.this.iContactCount = CopiagendaApplication.this.iDataController.getItemCount();
            }
        };
        sync.start();
    }

    private void initSync() {
        Thread syncInit = new Thread(){

            public void run() {
                if (CopiagendaApplication.this.iLatestVersion == null) {
                    CopiagendaApplication.this.switchDisplayable(null, (Displayable)CopiagendaApplication.this.iProgressView);
                    CopiagendaApplication.access$402(CopiagendaApplication.this, CopiagendaApplication.this.iDataController.latestVersion());
                }
                if (!CopiagendaApplication.this.isLatestVersion()) {
                    return;
                }
                if (!CopiagendaApplication.this.iDataController.isSIMRegistered()) {
                    CopiagendaApplication.this.displayTerms();
                    return;
                }
                if (CopiagendaApplication.this.iMainView == null) {
                    CopiagendaApplication.this.getMainView(0);
                }
                CopiagendaApplication.this.switchDisplayable(CopiagendaApplication.this.getConfirmationView(CopiagendaApplication.this.iSyncMode, null), (Displayable)CopiagendaApplication.this.iMainView);
            }
        };
        syncInit.start();
    }

    private boolean isLatestVersion() {
        boolean isLatest = true;
        if (this.iLatestVersion != null) {
            int current = (int)(Float.parseFloat(this.getAppProperty("MIDlet-Version")) * 100.0f);
            int latest = Integer.parseInt(this.iLatestVersion[0]);
            LogViewer.debug("LatestVersion: " + latest + " | Current: " + current);
            if (latest > current && this.getAppProperty("updateEnabled").equals("true")) {
                isLatest = false;
                this.switchDisplayable(null, (Displayable)this.getConfirmationView(5, null));
            }
        } else {
            isLatest = false;
            this.switchDisplayable(null, (Displayable)this.getConfirmationView(3, Locale.get("CLIENT_INFORMATION_NOT_AVAILABLE")));
        }
        return isLatest;
    }

    public void commandAction(Command command, Displayable displayable) {
        if (command == this.exitCommand) {
            this.switchDisplayable(null, (Displayable)this.getConfirmationView(6, null));
        } else if (command == this.exitConfirmationCommand) {
            this.exitMIDlet();
        } else if (command == this.synchronizeCmd) {
            this.iSyncMode = 2;
            this.initSync();
        } else if (displayable == this.iInformationView && this.iInformationView.iType == 3) {
            this.switchDisplayable(null, (Displayable)this.getMainView(0));
        } else if (displayable == this.iConfirmationView && this.iConfirmationView.iType == 7) {
            this.exitMIDlet();
        } else if (displayable == this.iRegisterView && command == this.backCommand) {
            this.switchDisplayable(null, (Displayable)this.getMainView(1));
        } else if (command == this.backCommand) {
            if (this.iMainView == null) {
                this.switchDisplayable(null, (Displayable)this.iInformationView);
                return;
            }
            if (displayable == this.iInformationView && this.iInformationView.iType == 2 || displayable == this.iRegisterView) {
                this.switchDisplayable(null, (Displayable)this.iMainView);
                return;
            }
            if (this.iMainView.iViewType == 1 && displayable != this.iConfigurationView) {
                this.getMainView(0);
            }
            if (displayable == this.iConfigurationView) {
                this.iConfigurationView.save();
            }
            this.switchDisplayable(null, (Displayable)this.iMainView);
        } else if (displayable == this.iConfirmationView) {
            this.confirmationAction(command);
        } else if (displayable == this.iProgressView) {
            this.iDataController.cancelOperation();
        } else if (displayable == this.iInformationView) {
            if (this.iInformationView.iType == 0) {
                boolean accepted = command == this.acceptCommand;
                this.iDataController.termsDisplayed(accepted);
                if (accepted) {
                    this.switchDisplayable(null, (Displayable)this.iProgressView);
                    this.sync();
                } else {
                    if (this.iMainView == null) {
                        this.getMainView(0);
                    }
                    this.switchDisplayable(null, (Displayable)this.iMainView);
                }
            } else if (command == this.continueCommand) {
                this.switchDisplayable(null, (Displayable)this.getMainView(0));
            } else {
                this.confirmationAction(command);
            }
        }
    }

    private void sanActionAccepted() {
        Thread sync = new Thread(){

            public void run() {
                try {
                    CopiagendaApplication.this.initialize();
                    CopiagendaApplication.this.initSync();
                }
                catch (PIMException ex) {
                    ex.printStackTrace();
                    CopiagendaApplication.this.switchDisplayable(null, (Displayable)CopiagendaApplication.this.getConfirmationView(7, ex.getMessage()));
                }
            }
        };
        sync.start();
    }

    private void scheduleMIDlet() throws ClassNotFoundException, ConnectionNotFoundException, SecurityException {
        int alarmMode;
        long lastSync = this.iSyncRegister.getLastSyncTime();
        if (lastSync > 0L && (alarmMode = this.iSyncRegister.getAlarmMode()) == 0) {
            long alarmDelta = this.iSyncRegister.getAlarmDelta();
            long ms_day = 86400000L;
            long nextStart = System.currentTimeMillis() + alarmDelta * ms_day;
            String cn = ((Object)((Object)this)).getClass().getName();
            LogViewer.debug("Register: " + new Date(nextStart));
            long t = PushRegistry.registerAlarm((String)cn, (long)nextStart);
            LogViewer.debug("Registered: " + new Date(t).toString());
        }
    }

    public void viewAction() {
        int selected = this.iMainView.getSelected();
        if (this.iMainView.iViewType == 0) {
            this.mainViewAction(selected);
        } else {
            this.advancedOptionsViewAction(selected);
        }
    }

    private void mainViewAction(int aSelectedItem) {
        LogViewer.debug("Selected: " + aSelectedItem);
        switch (aSelectedItem) {
            case 0: {
                this.iSyncMode = 0;
                this.initSync();
                break;
            }
            case 1: {
                this.iSyncMode = 1;
                this.initSync();
                break;
            }
            case 2: {
                this.switchDisplayable(null, (Displayable)this.getMainView(1));
                break;
            }
            case 3: {
                this.switchDisplayable(null, (Displayable)this.getInformationView(1, null));
            }
        }
    }

    private void confirmationAction(Command command) {
        if (command == this.continueCommand && (this.iConfirmationView.iType == 4 || this.iConfirmationView.iType == 3)) {
            this.switchDisplayable(null, (Displayable)this.getMainView(0));
        } else if (command == this.continueCommand) {
            this.switchDisplayable(null, (Displayable)this.iProgressView);
            this.sync();
        } else if (command == this.cancelCommand || command == this.iDontUpdateCommand) {
            this.switchDisplayable(null, (Displayable)this.iMainView);
        } else if (command == this.iUpdateCommand) {
            this.performUpdate();
        }
    }

    private ProgressView getProgressView() {
        if (this.iProgressView == null) {
            this.iProgressView = new ProgressView(this.getAppProperty("MIDlet-Name"));
            this.iProgressView.addCommand(this.getCancelCommand());
            this.iProgressView.setCommandListener(this);
        }
        return this.iProgressView;
    }

    private Command getCancelCommand() {
        if (this.cancelCommand == null) {
            this.cancelCommand = new Command(Locale.get("CANCEL_COMMAND"), 3, 0);
        }
        return this.cancelCommand;
    }

    private InformationView getInformationView(int aType, int[] aMods) {
        if (this.iInformationView == null) {
            this.iInformationView = new InformationView(this);
        }
        this.iInformationView.construct(aType, aMods);
        this.iInformationView.removeCommand(this.exitCommand);
        this.iInformationView.removeCommand(this.acceptCommand);
        this.iInformationView.removeCommand(this.backCommand);
        this.iInformationView.removeCommand(this.continueCommand);
        this.iInformationView.removeCommand(this.iRejectCommand);
        this.iInformationView.removeCommand(this.synchronizeCmd);
        switch (aType) {
            case 0: {
                this.iInformationView.addCommand(this.getAcceptCommand());
                this.iInformationView.addCommand(this.getRejectCommand());
                break;
            }
            case 3: {
                this.iInformationView.addCommand(this.getSynchronizeCommand());
                this.iInformationView.addCommand(this.getBackCommand());
                break;
            }
            case 1: 
            case 2: {
                this.iInformationView.addCommand(this.getBackCommand());
            }
        }
        this.iInformationView.setCommandListener(this);
        return this.iInformationView;
    }

    private Command getSynchronizeCommand() {
        if (this.synchronizeCmd == null) {
            this.synchronizeCmd = new Command(Locale.get("SYNCHRONIZE_COMMAND"), 4, 0);
        }
        return this.synchronizeCmd;
    }

    private Command getAcceptCommand() {
        if (this.acceptCommand == null) {
            this.acceptCommand = new Command(Locale.get("ACCEPT_COMMAND"), 4, 0);
        }
        return this.acceptCommand;
    }

    public void advancedOptionsViewAction(int aSelecedItem) {
        switch (aSelecedItem) {
            case 0: {
                this.iSyncMode = 2;
                this.initSync();
                break;
            }
            case 1: {
                this.switchDisplayable(null, (Displayable)this.getRegisterView());
                break;
            }
            case 2: {
                this.switchDisplayable(null, (Displayable)this.getConfigurationView());
                break;
            }
            case 3: {
                this.switchDisplayable(null, (Displayable)this.getInformationView(2, null));
            }
        }
    }

    private ConfigurationView getConfigurationView() {
        if (this.iConfigurationView == null) {
            this.iConfigurationView = new ConfigurationView(this.iSyncRegister);
            this.iConfigurationView.addCommand(this.getBackCommand());
            this.iConfigurationView.setCommandListener(this);
        }
        this.iConfigurationView.updateUI();
        return this.iConfigurationView;
    }

    private void handlePushActivation() {
        String[] connections = PushRegistry.listConnections((boolean)true);
        LogViewer.debug("handlePushActivation");
        if (connections != null && connections.length > 0) {
            String address = "sms://:" + this.getAppProperty("SMS-Port");
            LogViewer.debug("Connections: " + connections.length);
            for (int i = 0; i < connections.length; ++i) {
                if (!connections[i].equals(address)) continue;
                if (!this.iPushActivated) {
                    this.iPushActivated = true;
                    this.read(connections[i]);
                }
                LogViewer.debug("Found: " + connections[i]);
            }
        }
    }

    private Command getExitCommand() {
        if (this.exitCommand == null) {
            this.exitCommand = new Command(Locale.get("EXIT_COMMAND"), 7, 0);
        }
        return this.exitCommand;
    }

    private Command getExitConfirmationCommand() {
        if (this.exitConfirmationCommand == null) {
            this.exitConfirmationCommand = new Command(Locale.get("EXIT_COMMAND"), 4, 0);
        }
        return this.exitConfirmationCommand;
    }

    private Command getBackCommand() {
        if (this.backCommand == null) {
            this.backCommand = new Command(Locale.get("BACK_COMMAND"), 2, 0);
        }
        return this.backCommand;
    }

    private Command getContinueCommand() {
        if (this.continueCommand == null) {
            this.continueCommand = new Command(Locale.get("CONTINUE_COMMAND"), 4, 0);
        }
        return this.continueCommand;
    }

    private ConfirmationView getConfirmationView(int aType, String aMessage) {
        if (this.iConfirmationView == null) {
            this.iConfirmationView = new ConfirmationView();
        }
        this.iConfirmationView.removeCommand(this.acceptCommand);
        this.iConfirmationView.removeCommand(this.backCommand);
        this.iConfirmationView.removeCommand(this.cancelCommand);
        this.iConfirmationView.removeCommand(this.continueCommand);
        this.iConfirmationView.removeCommand(this.exitConfirmationCommand);
        this.iConfirmationView.removeCommand(this.iUpdateCommand);
        this.iConfirmationView.removeCommand(this.iDontUpdateCommand);
        switch (aType) {
            case 0: 
            case 1: 
            case 2: {
                this.iConfirmationView.addCommand(this.getContinueCommand());
                this.iConfirmationView.addCommand(this.getCancelCommand());
                break;
            }
            case 3: 
            case 4: {
                this.iConfirmationView.addCommand(this.getContinueCommand());
                break;
            }
            case 6: {
                this.iConfirmationView.addCommand(this.getExitConfirmationCommand());
                this.iConfirmationView.addCommand(this.getBackCommand());
                break;
            }
            case 5: {
                this.iConfirmationView.addCommand(this.getUpdateCommand());
                this.iConfirmationView.addCommand(this.getDontUpdateCommand());
                break;
            }
            case 7: {
                this.iConfirmationView.addCommand(this.getAcceptCommand());
            }
        }
        this.iConfirmationView.construct(aType, aMessage);
        this.iConfirmationView.setCommandListener(this);
        return this.iConfirmationView;
    }

    private RegisterView getRegisterView() {
        if (this.iRegisterView == null) {
            this.iRegisterView = new RegisterView(this.iSyncRegister);
        }
        this.iRegisterView.updateUI();
        this.iRegisterView.addCommand(this.getBackCommand());
        this.iRegisterView.setCommandListener(this);
        return this.iRegisterView;
    }

    public Display getDisplay() {
        return Display.getDisplay((MIDlet)this);
    }

    public void exitMIDlet() {
        this.switchDisplayable(null, null);
        this.destroyApp(true);
        this.notifyDestroyed();
    }

    public void startApp() {
        if (this.midletPaused) {
            this.resumeMIDlet();
        } else {
            Locale.initialize();
            LogViewer.initialize();
            LogViewer.debug("Starting");
            this.switchDisplayable(null, (Displayable)this.getProgressView());
            Thread pushActivate = new Thread(){

                public void run() {
                    CopiagendaApplication.this.handlePushActivation();
                    if (!CopiagendaApplication.this.iPushActivated) {
                        try {
                            CopiagendaApplication.this.initialize();
                        }
                        catch (PIMException ex) {
                            ex.printStackTrace();
                            CopiagendaApplication.this.switchDisplayable(null, (Displayable)CopiagendaApplication.this.getConfirmationView(7, ex.getMessage()));
                            return;
                        }
                    }
                    CopiagendaApplication.this.startMIDlet();
                }
            };
            pushActivate.start();
        }
        this.midletPaused = false;
    }

    public void pauseApp() {
        this.midletPaused = true;
    }

    public void destroyApp(boolean unconditional) {
        try {
            if (this.iSyncRegister != null) {
                this.iSyncRegister.save();
                this.scheduleMIDlet();
            }
        }
        catch (ClassNotFoundException ex) {
            ex.printStackTrace();
        }
        catch (ConnectionNotFoundException ex) {
            ex.printStackTrace();
        }
        catch (SecurityException ex) {
            ex.printStackTrace();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private Command getUpdateCommand() {
        if (this.iUpdateCommand == null) {
            this.iUpdateCommand = new Command(Locale.get("UPDATE_COMMAND_YES"), 4, 0);
        }
        return this.iUpdateCommand;
    }

    private Command getDontUpdateCommand() {
        if (this.iDontUpdateCommand == null) {
            this.iDontUpdateCommand = new Command(Locale.get("UPDATE_COMMAND_NO"), 2, 0);
        }
        return this.iDontUpdateCommand;
    }

    private void performUpdate() {
        LogViewer.debug("Update");
        if (this.openLink(this.iLatestVersion[1])) {
            this.exitMIDlet();
            return;
        }
        this.switchDisplayable(null, (Displayable)this.iMainView);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void read(String address) {
        try {
            this.smsconn = (MessageConnection)Connector.open((String)address);
            Message msg = this.smsconn.receive();
            if (msg != null && (msg instanceof TextMessage || msg instanceof BinaryMessage)) {
                this.iPushActivated = true;
                this.iSyncMode = 2;
            }
        }
        catch (InterruptedIOException ex) {
        }
        catch (IOException ex) {
        }
        catch (SecurityException ex) {
        }
        finally {
            if (this.smsconn != null) {
                try {
                    this.smsconn.setMessageListener(null);
                    this.smsconn.close();
                }
                catch (IOException ex) {
                    ex.printStackTrace();
                }
                this.smsconn = null;
            }
        }
    }

    public void displayTerms() {
        this.switchDisplayable(null, (Displayable)this.getInformationView(0, null));
    }

    private Command getRejectCommand() {
        if (this.iRejectCommand == null) {
            this.iRejectCommand = new Command(Locale.get("REJECT_COMMAND"), 3, 1);
        }
        return this.iRejectCommand;
    }

    public boolean openLink(String aUrl) {
        boolean midletMustBeClosed = false;
        try {
            midletMustBeClosed = this.platformRequest(aUrl);
        }
        catch (ConnectionNotFoundException ex) {
            ex.printStackTrace();
        }
        catch (SecurityException ex) {
            ex.printStackTrace();
        }
        return midletMustBeClosed;
    }

    static /* synthetic */ String[] access$402(CopiagendaApplication x0, String[] x1) {
        x0.iLatestVersion = x1;
        return x1;
    }
}

