/*
 * Decompiled with CFR 0.152.
 */
package com.telefonica.copiagenda;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Calendar;
import java.util.Date;
import java.util.Hashtable;

public class Locale {
    private static Locale sInstance;
    private static Hashtable iLocaleStrings;
    private static String iLocale;
    private static String[] DAYS_EN;
    private static String[] DAYS_ES;
    private static String[] MONTHS_EN;
    private static String[] MONTHS_ES;

    public static synchronized Locale getInstance() {
        if (sInstance == null) {
            throw new IllegalStateException();
        }
        return sInstance;
    }

    public static synchronized void initialize() {
        if (sInstance != null) {
            throw new IllegalStateException();
        }
        sInstance = new Locale();
    }

    public void parseLocales() {
        InputStreamReader sReader = null;
        boolean done = false;
        InputStream is = iLocale.startsWith("es") || iLocale.startsWith("ES") ? this.getClass().getResourceAsStream("/loc/es.loc") : this.getClass().getResourceAsStream("/loc/en.loc");
        try {
            sReader = new InputStreamReader(is, "UTF-8");
            StringBuffer line = new StringBuffer();
            while (!done) {
                int bytesRead = sReader.read();
                if (bytesRead != -1) {
                    if ((char)bytesRead == '\n') {
                        String s = line.toString().trim();
                        if (!s.startsWith("#") && s.length() > 2) {
                            String key = s.substring(0, s.indexOf(32)).trim().toLowerCase();
                            String value = s.substring(s.indexOf(32) + 1).trim();
                            iLocaleStrings.put(key, value);
                        }
                        line.setLength(0);
                        continue;
                    }
                    line.append((char)bytesRead);
                    continue;
                }
                done = true;
            }
        }
        catch (IOException ioe) {
            throw new RuntimeException("File not found");
        }
        finally {
            try {
                if (sReader != null) {
                    sReader.close();
                    sReader = null;
                }
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
            }
        }
    }

    public static String get(String aKey) {
        String value = (String)iLocaleStrings.get(aKey.toLowerCase());
        if (value == null) {
            throw new RuntimeException("LOCALE FAIL: " + aKey);
        }
        return value;
    }

    private Locale() {
        iLocale = System.getProperty("microedition.locale");
        iLocaleStrings = new Hashtable();
        this.parseLocales();
    }

    public static final String getLocalizedDate(long aDateToLocalize) {
        Calendar calendarTime = Calendar.getInstance();
        calendarTime.setTime(new Date(aDateToLocalize));
        if (iLocale.startsWith("es") || iLocale.startsWith("ES")) {
            StringBuffer date = new StringBuffer();
            int day = calendarTime.get(7);
            switch (day) {
                case 1: {
                    date.append(DAYS_ES[0]);
                    break;
                }
                case 2: {
                    date.append(DAYS_ES[1]);
                    break;
                }
                case 3: {
                    date.append(DAYS_ES[2]);
                    break;
                }
                case 4: {
                    date.append(DAYS_ES[3]);
                    break;
                }
                case 5: {
                    date.append(DAYS_ES[4]);
                    break;
                }
                case 6: {
                    date.append(DAYS_ES[5]);
                    break;
                }
                case 7: {
                    date.append(DAYS_ES[6]);
                }
            }
            date.append(" ");
            date.append(calendarTime.get(5));
            date.append(" ");
            int month = calendarTime.get(2);
            switch (month) {
                case 0: {
                    date.append(MONTHS_ES[0]);
                    break;
                }
                case 1: {
                    date.append(MONTHS_ES[1]);
                    break;
                }
                case 2: {
                    date.append(MONTHS_ES[2]);
                    break;
                }
                case 3: {
                    date.append(MONTHS_ES[3]);
                    break;
                }
                case 4: {
                    date.append(MONTHS_ES[4]);
                    break;
                }
                case 5: {
                    date.append(MONTHS_ES[5]);
                    break;
                }
                case 6: {
                    date.append(MONTHS_ES[6]);
                    break;
                }
                case 7: {
                    date.append(MONTHS_ES[7]);
                    break;
                }
                case 8: {
                    date.append(MONTHS_ES[8]);
                    break;
                }
                case 9: {
                    date.append(MONTHS_ES[9]);
                    break;
                }
                case 10: {
                    date.append(MONTHS_ES[10]);
                    break;
                }
                case 11: {
                    date.append(MONTHS_ES[11]);
                }
            }
            date.append(" ");
            int hour = calendarTime.get(11);
            if (hour < 10) {
                date.append("0");
            }
            date.append(hour);
            date.append(":");
            int minute = calendarTime.get(12);
            if (minute < 10) {
                date.append("0");
            }
            date.append(minute);
            return date.toString();
        }
        String timeString = calendarTime.getTime().toString();
        timeString = timeString.substring(0, timeString.indexOf(":") + 3);
        return timeString;
    }

    static {
        DAYS_EN = new String[]{"Sun", "Mon", "Tue", "Wed", "Thu", "Sat"};
        DAYS_ES = new String[]{"Dom", "Lun", "Mar", "Mie", "Jue", "Vie", "Sab"};
        MONTHS_EN = new String[]{"Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec"};
        MONTHS_ES = new String[]{"Ene", "Feb", "Mar", "Abr", "May", "Jun", "Jul", "Ago", "Sep", "Oct", "Nov", "Dic"};
    }
}

