/*
 * Decompiled with CFR 0.152.
 */
package com.telefonica.copiagenda.datasync.source;

import com.funambol.syncml.spds.SyncItem;
import com.funambol.util.Base64;
import com.funambol.util.MD5;
import com.telefonica.copiagenda.ui.LogViewer;
import java.util.Vector;
import javax.microedition.rms.RecordEnumeration;
import javax.microedition.rms.RecordStore;
import javax.microedition.rms.RecordStoreException;
import javax.microedition.rms.RecordStoreFullException;
import javax.microedition.rms.RecordStoreNotFoundException;

public class ChangeTracker {
    private RecordStore iRms = null;
    private final String RECORD_STORE;

    public ChangeTracker() {
        this.RECORD_STORE = "CopiAgendaContacts";
    }

    public boolean isUpdated(String aUid, SyncItem aItem) {
        boolean updated = false;
        try {
            this.iRms = RecordStore.openRecordStore((String)"CopiAgendaContacts", (boolean)true);
            String sub = null;
            RecordEnumeration e = this.iRms.enumerateRecords(null, null, false);
            while (e.hasNextElement()) {
                int index;
                String tmp = null;
                tmp = new String(e.nextRecord());
                sub = tmp.substring(0, index = tmp.indexOf("#"));
                if (!sub.equals(aUid)) continue;
                LogViewer.debug("Checking MD5 of " + sub);
                sub = tmp.substring(index + 1, tmp.lastIndexOf(35));
                String md5 = this.computeFingerprint(aItem);
                LogViewer.debug("compare " + sub + " | " + md5);
                if (md5.equals(sub)) continue;
                LogViewer.debug("Doesn't match");
                updated = true;
                break;
            }
            this.iRms.closeRecordStore();
        }
        catch (RecordStoreFullException ex) {
            ex.printStackTrace();
        }
        catch (RecordStoreNotFoundException ex) {
            ex.printStackTrace();
        }
        catch (RecordStoreException ex) {
            ex.printStackTrace();
        }
        return updated;
    }

    private String computeFingerprint(SyncItem item) {
        byte[] data = item.getContent();
        MD5 md5 = new MD5();
        byte[] fp = md5.calculateMD5(data);
        byte[] fpB64 = Base64.encode(fp);
        return new String(fpB64);
    }

    public boolean isAdded(String aUID) {
        boolean found = false;
        try {
            this.iRms = RecordStore.openRecordStore((String)"CopiAgendaContacts", (boolean)true);
            String sub = null;
            RecordEnumeration e = this.iRms.enumerateRecords(null, null, false);
            int index = 0;
            while (e.hasNextElement()) {
                String tmp = null;
                tmp = new String(e.nextRecord());
                sub = tmp.substring(0, index = tmp.indexOf("#"));
                if (!sub.equals(aUID)) continue;
                LogViewer.debug("is added to cache, uid: " + sub);
                found = true;
                break;
            }
            this.iRms.closeRecordStore();
            this.iRms = null;
        }
        catch (RecordStoreFullException ex) {
            ex.printStackTrace();
        }
        catch (RecordStoreNotFoundException ex) {
            ex.printStackTrace();
        }
        catch (RecordStoreException ex) {
            ex.printStackTrace();
        }
        return found;
    }

    public Vector getDeletedItems(Vector aContactUIDs) {
        Vector<String> deleted = new Vector<String>();
        try {
            this.iRms = RecordStore.openRecordStore((String)"CopiAgendaContacts", (boolean)true);
            String sub = null;
            RecordEnumeration e = this.iRms.enumerateRecords(null, null, false);
            int index = 0;
            while (e.hasNextElement()) {
                String tmp = null;
                tmp = new String(e.nextRecord());
                sub = tmp.substring(0, index = tmp.indexOf("#"));
                if (aContactUIDs.contains(sub)) continue;
                LogViewer.debug("found deleted, uid: " + sub);
                deleted.addElement(sub);
            }
            this.iRms.closeRecordStore();
        }
        catch (RecordStoreFullException ex) {
            ex.printStackTrace();
        }
        catch (RecordStoreNotFoundException ex) {
            ex.printStackTrace();
        }
        catch (RecordStoreException ex) {
            ex.printStackTrace();
        }
        return deleted;
    }

    public void addItem(SyncItem aItem) {
        try {
            this.iRms = RecordStore.openRecordStore((String)"CopiAgendaContacts", (boolean)true);
            RecordEnumeration e = this.iRms.enumerateRecords(null, null, false);
            int next = 0;
            String data = aItem.getKey();
            boolean isAlreadyAdded = false;
            while (e.hasNextElement()) {
                next = e.nextRecordId();
                String tmp = new String(this.iRms.getRecord(next));
                if (!(tmp = tmp.substring(0, tmp.indexOf("#"))).equals(data)) continue;
                isAlreadyAdded = true;
                LogViewer.debug("addItem, already cached: " + tmp);
                break;
            }
            data = data + "#";
            data = data + this.computeFingerprint(aItem);
            data = data + "#";
            if (isAlreadyAdded) {
                LogViewer.debug("Update: " + data);
                this.iRms.setRecord(next, data.getBytes(), 0, data.getBytes().length);
            } else {
                LogViewer.debug("Add: " + data);
                this.iRms.addRecord(data.getBytes(), 0, data.getBytes().length);
            }
            this.iRms.closeRecordStore();
        }
        catch (RecordStoreFullException ex) {
            ex.printStackTrace();
        }
        catch (RecordStoreNotFoundException ex) {
            ex.printStackTrace();
        }
        catch (RecordStoreException ex) {
            ex.printStackTrace();
        }
    }

    public int getRecordCount() {
        int recordCount = 0;
        try {
            this.iRms = RecordStore.openRecordStore((String)"CopiAgendaContacts", (boolean)true);
            recordCount = this.iRms.getNumRecords();
            this.iRms.closeRecordStore();
        }
        catch (RecordStoreFullException ex) {
            ex.printStackTrace();
        }
        catch (RecordStoreNotFoundException ex) {
            ex.printStackTrace();
        }
        catch (RecordStoreException ex) {
            ex.printStackTrace();
        }
        return recordCount;
    }

    public void deleteContact(String aUID) {
        try {
            this.iRms = RecordStore.openRecordStore((String)"CopiAgendaContacts", (boolean)true);
            RecordEnumeration e = this.iRms.enumerateRecords(null, null, false);
            int index = 0;
            while (e.hasNextElement()) {
                index = e.nextRecordId();
                String tmp = new String(this.iRms.getRecord(index));
                if (!(tmp = tmp.substring(0, tmp.indexOf("#"))).equals(aUID)) continue;
                LogViewer.debug("delete contact #" + aUID + " , found from cache");
                this.iRms.deleteRecord(index);
                break;
            }
            this.iRms.closeRecordStore();
            this.iRms = null;
        }
        catch (RecordStoreFullException ex) {
            ex.printStackTrace();
        }
        catch (RecordStoreNotFoundException ex) {
            ex.printStackTrace();
        }
        catch (RecordStoreException ex) {
            ex.printStackTrace();
        }
    }

    public void removeAll() {
        try {
            this.iRms = RecordStore.openRecordStore((String)"CopiAgendaContacts", (boolean)true);
            RecordEnumeration e = this.iRms.enumerateRecords(null, null, true);
            while (e.hasNextElement()) {
                int id = e.nextRecordId();
                this.iRms.deleteRecord(id);
            }
            this.iRms.closeRecordStore();
            this.iRms = null;
        }
        catch (RecordStoreFullException ex) {
            ex.printStackTrace();
        }
        catch (RecordStoreNotFoundException ex) {
            ex.printStackTrace();
        }
        catch (RecordStoreException ex) {
            ex.printStackTrace();
        }
    }
}

