/*
 * Decompiled with CFR 0.152.
 */
package com.telefonica.copiagenda.datasync.source;

import com.funambol.syncml.spds.SyncItem;
import com.telefonica.copiagenda.Locale;
import com.telefonica.copiagenda.datasync.MessageListener;
import com.telefonica.copiagenda.datasync.source.ChangeTracker;
import com.telefonica.copiagenda.datasync.source.CopiAgendaSyncRegister;
import com.telefonica.copiagenda.ui.LogViewer;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.microedition.pim.Contact;
import javax.microedition.pim.ContactList;
import javax.microedition.pim.PIM;
import javax.microedition.pim.PIMException;
import javax.microedition.pim.PIMItem;
import javax.microedition.pim.PIMList;

public class ContactsManager {
    private MessageListener iMessageListener;
    private final String VCARD_TYPE;
    private final String VCARD_CHARACTER_ENCODING;
    private final String SYNCITEM_TYPE;
    private SyncItem[] allContactsList;
    private SyncItem[] deletedContactsList;
    private SyncItem[] updatedContactsList;
    private SyncItem[] newContactsList;
    private PIMList pimList = null;
    private ChangeTracker iChangeTracker = null;
    private CopiAgendaSyncRegister iSyncRegister = null;
    private Hashtable iItemStatusTable = null;
    private int iSessionStatus = -1;

    public ContactsManager(MessageListener aMessageListener, CopiAgendaSyncRegister aRegister) {
        this.VCARD_TYPE = "VCARD/2.1";
        this.VCARD_CHARACTER_ENCODING = "UTF-8";
        this.SYNCITEM_TYPE = "text/x-vcard";
        this.iMessageListener = aMessageListener;
        this.iChangeTracker = new ChangeTracker();
        this.iSyncRegister = aRegister;
        String[] supportedSerialFormats = PIM.getInstance().supportedSerialFormats(1);
        for (int i = 0; i < supportedSerialFormats.length; ++i) {
            LogViewer.debug("Supported: " + supportedSerialFormats[i]);
        }
        this.iItemStatusTable = new Hashtable();
    }

    public boolean openContactList() {
        if (this.pimList == null) {
            try {
                this.pimList = PIM.getInstance().openPIMList(1, 3);
            }
            catch (PIMException e) {
                this.iMessageListener.ErrorMessage("Error in contact list open ");
            }
            catch (SecurityException e) {
                this.iMessageListener.ErrorMessage(Locale.get("PIMLIST_PERMISSION_DENIED"));
            }
        }
        return this.pimList != null;
    }

    public int[] getModificationCount() {
        Contact tmp;
        LogViewer.debug("getModificationCount");
        int[] modifications = new int[3];
        if (this.iChangeTracker.getRecordCount() == 0) {
            LogViewer.debug("0|" + modifications[0] + " 1|" + modifications[1] + " 2|" + modifications[2]);
            return modifications;
        }
        Vector contacts = this.loadContacts();
        Enumeration iterator = contacts.elements();
        String UID = null;
        while (iterator.hasMoreElements()) {
            tmp = (Contact)iterator.nextElement();
            UID = tmp.getString(117, 0);
            if (!this.iChangeTracker.isAdded(UID)) {
                modifications[0] = modifications[0] + 1;
                continue;
            }
            if (!this.iChangeTracker.isUpdated(UID, this.syncItemFromContact(tmp))) continue;
            modifications[1] = modifications[1] + 1;
        }
        Vector<String> contactUIDs = new Vector<String>();
        iterator = contacts.elements();
        while (iterator.hasMoreElements()) {
            tmp = (Contact)iterator.nextElement();
            contactUIDs.addElement(tmp.getString(117, 0));
        }
        Vector deleted = this.iChangeTracker.getDeletedItems(contactUIDs);
        modifications[2] = deleted.size();
        return modifications;
    }

    public int clearContacts() throws PIMException {
        Vector contacts = this.loadContacts();
        Enumeration iterator = contacts.elements();
        int count = 0;
        while (iterator.hasMoreElements()) {
            Contact con = (Contact)iterator.nextElement();
            this.removeContact(con);
            ++count;
        }
        return count;
    }

    public void removeContact(Contact remove) throws PIMException {
        if (this.pimList == null) {
            this.iMessageListener.ErrorMessage("Cannot open contact list");
            throw new PIMException("pim list open failed");
        }
        ((ContactList)this.pimList).removeContact(remove);
        this.iSyncRegister.itemDeleted(true);
    }

    public Contact addContact(Contact contact) throws PIMException {
        Contact newContact = null;
        if (this.pimList == null) {
            this.iMessageListener.ErrorMessage("Cannot open contact list");
            throw new PIMException("pimList open failed");
        }
        newContact = ((ContactList)this.pimList).importContact(contact);
        try {
            newContact.commit();
            LogViewer.debug("Commit completed for #: " + newContact.getString(117, 0));
        }
        catch (PIMException e) {
            this.iMessageListener.ErrorMessage("Cannot commit contact: " + e.getMessage());
            throw e;
        }
        return newContact;
    }

    public void addContact(SyncItem newItem, boolean update) throws PIMException {
        Contact contact = this.contactFromSyncItem(newItem);
        Contact newContact = this.addContact(contact);
        String uid = newContact.getString(117, 0);
        newItem.setKey(uid);
        this.iChangeTracker.addItem(this.syncItemFromContact(newContact));
        if (update) {
            this.iSyncRegister.itemAdded(true);
        }
    }

    public void deleteContact(String itemUID, boolean update) throws PIMException {
        LogViewer.debug("deleteContact: " + itemUID);
        Vector contacts = this.loadContacts();
        Enumeration iterator = contacts.elements();
        int index = 0;
        Contact tmp = null;
        while (iterator.hasMoreElements()) {
            tmp = (Contact)iterator.nextElement();
            if (tmp.getString(117, 0).equals(itemUID)) {
                ((ContactList)this.pimList).removeContact(tmp);
                this.iChangeTracker.deleteContact(itemUID);
                if (update) {
                    this.iSyncRegister.itemDeleted(true);
                }
            }
            ++index;
        }
    }

    public void updateContact(SyncItem updItem) throws PIMException {
        LogViewer.debug("updateContact");
        try {
            LogViewer.debug("Original: " + updItem.getKey());
            this.deleteContact(updItem.getKey(), false);
            this.addContact(updItem, false);
            LogViewer.debug("Modified: " + updItem.getKey());
            this.iSyncRegister.itemUpdated(true);
        }
        catch (PIMException ex) {
            ex.printStackTrace();
        }
    }

    public SyncItem getItemWithContent(SyncItem item) {
        LogViewer.debug("getItemWithContent: " + item.getKey());
        return item;
    }

    public SyncItem[] getAllContacts() {
        Vector contacts = this.loadContacts();
        this.allContactsList = new SyncItem[contacts.size()];
        Enumeration iterator = contacts.elements();
        int index = 0;
        while (iterator.hasMoreElements()) {
            this.allContactsList[index] = this.syncItemFromContact((Contact)iterator.nextElement());
            ++index;
        }
        return this.allContactsList;
    }

    public int getContactCount() {
        Enumeration e = null;
        this.openContactList();
        try {
            e = this.pimList.items();
        }
        catch (PIMException ex) {
            ex.printStackTrace();
        }
        catch (SecurityException se) {
            se.printStackTrace();
        }
        catch (NullPointerException ne) {
            ne.printStackTrace();
        }
        int count = e != null && e.hasMoreElements() ? 1 : 0;
        return count;
    }

    public SyncItem[] getDeletedContacts() {
        Vector contacts = this.loadContacts();
        Vector<String> contactUIDs = new Vector<String>();
        Enumeration iterator = contacts.elements();
        while (iterator.hasMoreElements()) {
            Contact tmp = (Contact)iterator.nextElement();
            contactUIDs.addElement(tmp.getString(117, 0));
        }
        Vector deleted = this.iChangeTracker.getDeletedItems(contactUIDs);
        int count = deleted.size();
        this.deletedContactsList = new SyncItem[count];
        for (int i = 0; i < count; ++i) {
            this.deletedContactsList[i] = this.syncItemFromUID((String)deleted.elementAt(i));
            this.deletedContactsList[i].setState('D');
        }
        LogViewer.debug("DELETED CONTACTS: " + this.deletedContactsList.length);
        return this.deletedContactsList;
    }

    public SyncItem[] getNewContacts() {
        Vector contacts = this.loadContacts();
        LogViewer.debug("getNewContacts");
        SyncItem[] temp = new SyncItem[contacts.size()];
        Enumeration iterator = contacts.elements();
        int count = 0;
        String UID = null;
        while (iterator.hasMoreElements()) {
            Contact tmp = (Contact)iterator.nextElement();
            UID = tmp.getString(117, 0);
            if (this.iChangeTracker.isAdded(UID)) continue;
            temp[count] = this.syncItemFromContact(tmp);
            ++count;
        }
        this.newContactsList = new SyncItem[count];
        for (int i = 0; i < count; ++i) {
            this.newContactsList[i] = temp[i];
            this.newContactsList[i].setState('N');
        }
        LogViewer.debug("NEW CONTACTS: " + this.newContactsList.length);
        return this.newContactsList;
    }

    public SyncItem[] getUpdatedContacts() {
        Vector contacts = this.loadContacts();
        LogViewer.debug("getUpdatedContacts");
        SyncItem[] temp = new SyncItem[contacts.size()];
        Enumeration iterator = contacts.elements();
        int count = 0;
        while (iterator.hasMoreElements()) {
            String uid = null;
            Contact tmp = (Contact)iterator.nextElement();
            uid = tmp.getString(117, 0);
            if (!this.iChangeTracker.isUpdated(uid, this.syncItemFromContact(tmp))) continue;
            temp[count] = this.syncItemFromContact(tmp);
            ++count;
        }
        this.updatedContactsList = new SyncItem[count];
        for (int i = 0; i < count; ++i) {
            this.updatedContactsList[i] = temp[i];
            this.updatedContactsList[i].setState('U');
        }
        LogViewer.debug("UPDATED CONTACTS: " + this.updatedContactsList.length);
        return this.updatedContactsList;
    }

    private SyncItem syncItemFromContact(Contact contact) {
        String itemUID = contact.getString(117, 0);
        LogViewer.debug("UID: " + itemUID);
        SyncItem newItem = new SyncItem(itemUID);
        newItem.setType("text/x-vcard");
        newItem.setContent(this.getVCardFromContact(contact));
        return newItem;
    }

    private SyncItem syncItemFromUID(String aUID) {
        SyncItem newItem = new SyncItem(aUID);
        newItem.setType("text/x-vcard");
        newItem.setState('D');
        return newItem;
    }

    private Contact contactFromSyncItem(SyncItem item) {
        String vcard = new String(item.getContent());
        if (vcard.indexOf("CDATA") > 0) {
            String endTag = "END:VCARD";
            String startTag = "BEGIN:VCARD";
            vcard = vcard.substring(vcard.indexOf(startTag), vcard.indexOf(endTag) + endTag.length());
        }
        if (vcard.indexOf("NICKNAME") > 0) {
            int index = vcard.indexOf("NICKNAME");
            String newVcard = vcard.substring(0, index);
            newVcard = newVcard + "X-";
            vcard = newVcard = newVcard + vcard.substring(index);
        }
        LogViewer.debug("VCARD: " + vcard);
        LogViewer.debug("SyncItem: " + item.getKey() + " | state: " + item.getState());
        return this.contactFromVCard(vcard);
    }

    private Contact contactFromVCard(String vCard) {
        ByteArrayInputStream inputStrem = new ByteArrayInputStream(vCard.getBytes());
        try {
            PIMItem[] items = PIM.getInstance().fromSerialFormat((InputStream)inputStrem, "UTF-8");
            if (items.length > 0) {
                LogViewer.debug("PIMitems: " + items.length);
                return (Contact)items[0];
            }
            this.iMessageListener.ErrorMessage("Cannot convert vcard to contact");
        }
        catch (Exception e) {
            this.iMessageListener.ErrorMessage("when converting vcard to contact");
        }
        return null;
    }

    private byte[] getVCardFromContact(Contact contact) {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        try {
            PIM.getInstance().toSerialFormat((PIMItem)contact, (OutputStream)outputStream, "UTF-8", "VCARD/2.1");
        }
        catch (Exception e) {
            this.iMessageListener.ErrorMessage("Error in getting vcard from a contact");
        }
        return outputStream.toByteArray();
    }

    private Vector loadContacts() {
        Vector<Contact> contactsVector = new Vector<Contact>();
        ContactList contactList = null;
        Enumeration list = null;
        this.openContactList();
        contactList = (ContactList)this.pimList;
        try {
            list = contactList.items();
        }
        catch (Exception e) {
            this.iMessageListener.ErrorMessage("cannot get contact items");
            return contactsVector;
        }
        Contact contact = null;
        while (list.hasMoreElements()) {
            contact = (Contact)list.nextElement();
            contactsVector.addElement(contact);
        }
        return contactsVector;
    }

    public void clearStatus() {
        this.iItemStatusTable.clear();
        this.iSessionStatus = 149;
    }

    public void updateStatus() {
        LogViewer.debug("updateStatus: items " + this.iItemStatusTable.size());
        if (this.iItemStatusTable.size() <= 1) {
            this.acceptAll();
            return;
        }
        Enumeration e = this.iItemStatusTable.keys();
        while (e != null && e.hasMoreElements()) {
            String key = null;
            key = (String)e.nextElement();
            LogViewer.debug("updateStatus: " + key);
            int status = (Integer)this.iItemStatusTable.get(key);
            LogViewer.debug("updateStatus: " + key + " | " + status);
            switch (status) {
                case 200: 
                case 201: 
                case 207: 
                case 208: 
                case 209: 
                case 210: 
                case 418: 
                case 419: {
                    this.checkAllContacts(key, status);
                    this.checkNewContacts(key, status);
                    this.checkUpdatedContacts(key, status);
                    this.checkDeletedContacts(key, status);
                }
            }
        }
    }

    void setItemStatus(String aKey, int aStatus) {
        LogViewer.debug("ContactsManager:setItemStatus: key: " + aKey + " | status: " + aStatus);
        if (aKey == null) {
            this.iItemStatusTable.put("Overall", new Integer(aStatus));
        } else {
            this.iItemStatusTable.put(aKey, new Integer(aStatus));
        }
    }

    private void checkAllContacts(String aKey, int aStatus) {
        int count = this.allContactsList != null ? this.allContactsList.length : 0;
        for (int i = 0; i < count; ++i) {
            if (!this.allContactsList[i].getKey().equals(aKey)) continue;
            this.iChangeTracker.addItem(this.allContactsList[i]);
            if (aStatus == 201 || aStatus == 209) {
                this.iSyncRegister.itemAdded(false);
                break;
            }
            if (aStatus != 207 && aStatus != 208) break;
            this.iSyncRegister.itemUpdated(false);
            break;
        }
    }

    private void checkNewContacts(String aKey, int aStatus) {
        int count = this.newContactsList != null ? this.newContactsList.length : 0;
        for (int i = 0; i < count; ++i) {
            if (!this.newContactsList[i].getKey().equals(aKey)) continue;
            this.iChangeTracker.addItem(this.newContactsList[i]);
            if (aStatus != 201 && aStatus != 209) break;
            this.iSyncRegister.itemAdded(false);
            break;
        }
    }

    private void checkUpdatedContacts(String aKey, int aStatus) {
        int count = this.updatedContactsList != null ? this.updatedContactsList.length : 0;
        for (int i = 0; i < count; ++i) {
            if (!this.updatedContactsList[i].getKey().equals(aKey)) continue;
            this.iChangeTracker.addItem(this.updatedContactsList[i]);
            if (aStatus != 200 && aStatus != 207 && aStatus != 208) break;
            this.iSyncRegister.itemUpdated(false);
            break;
        }
    }

    private void checkDeletedContacts(String key, int status) {
        int count = this.deletedContactsList != null ? this.deletedContactsList.length : 0;
        for (int i = 0; i < count; ++i) {
            if (!this.deletedContactsList[i].getKey().equals(key)) continue;
            this.iChangeTracker.deleteContact(this.deletedContactsList[i].getKey());
            if (status != 200 && status != 210) break;
            this.iSyncRegister.itemDeleted(false);
            break;
        }
    }

    private void acceptAll() {
        Integer status = (Integer)this.iItemStatusTable.get("Overall");
        int statusCode = status != null ? status : 0;
        LogViewer.debug("overallStatus: " + statusCode);
        if (statusCode == 0 && this.iSessionStatus == 128) {
            statusCode = 200;
        } else if (this.iSessionStatus != 128) {
            this.iChangeTracker.removeAll();
            this.iSyncRegister.resetCounters();
            this.iSyncRegister.updateLastSync(0L, 201);
            return;
        }
        switch (statusCode) {
            case 200: 
            case 201: 
            case 207: 
            case 208: 
            case 209: 
            case 210: 
            case 418: 
            case 419: {
                int i;
                int count = this.allContactsList != null ? this.allContactsList.length : 0;
                for (i = 0; i < count; ++i) {
                    LogViewer.debug("acceptAll, allContacts item added " + this.allContactsList[i].getKey());
                    this.iChangeTracker.addItem(this.allContactsList[i]);
                    this.iSyncRegister.itemAdded(false);
                }
                count = this.newContactsList != null ? this.newContactsList.length : 0;
                for (i = 0; i < count; ++i) {
                    LogViewer.debug("acceptAll, newContacts item added " + this.newContactsList[i].getKey());
                    this.iChangeTracker.addItem(this.newContactsList[i]);
                    this.iSyncRegister.itemAdded(false);
                }
                count = this.updatedContactsList != null ? this.updatedContactsList.length : 0;
                for (i = 0; i < count; ++i) {
                    LogViewer.debug("acceptAll, updatedContacts item updated " + this.updatedContactsList[i].getKey());
                    this.iChangeTracker.addItem(this.updatedContactsList[i]);
                    this.iSyncRegister.itemUpdated(false);
                }
                count = this.deletedContactsList != null ? this.deletedContactsList.length : 0;
                for (i = 0; i < count; ++i) {
                    LogViewer.debug("acceptAll, deletedContacts item deleted " + this.deletedContactsList[i].getKey());
                    this.iChangeTracker.deleteContact(this.deletedContactsList[i].getKey());
                    this.iSyncRegister.itemDeleted(false);
                }
                break;
            }
        }
    }

    void setSessionStatus(int status) {
        this.iSessionStatus = status;
    }
}

