/*
 * Decompiled with CFR 0.152.
 */
package com.telefonica.copiagenda.datasync.source;

import com.funambol.syncml.client.BaseSyncSource;
import com.funambol.syncml.spds.SourceConfig;
import com.funambol.syncml.spds.SyncException;
import com.funambol.syncml.spds.SyncItem;
import com.telefonica.copiagenda.Locale;
import com.telefonica.copiagenda.datasync.ContactsSyncListener;
import com.telefonica.copiagenda.datasync.source.ContactsManager;
import com.telefonica.copiagenda.ui.LogViewer;
import java.util.Date;
import javax.microedition.pim.PIMException;

public class ContactsSource
extends BaseSyncSource {
    private ContactsManager iContactsManager = null;
    private int iLastSyncMode;
    private boolean iCancelled = false;
    public boolean lastSyncSuccesful = false;

    public ContactsSource(SourceConfig config, ContactsManager aManager) {
        super(config);
        this.iContactsManager = aManager;
    }

    public int addItem(SyncItem newItem) throws SyncException {
        this.cancel();
        try {
            this.iContactsManager.addContact(newItem, true);
        }
        catch (Exception e) {
            this.lastSyncSuccesful = false;
            LogViewer.debug("Error in contact adding");
            return 500;
        }
        return 200;
    }

    public int deleteItem(String item) throws SyncException {
        this.cancel();
        try {
            this.iContactsManager.deleteContact(item, true);
        }
        catch (Exception e) {
            this.lastSyncSuccesful = false;
            LogViewer.debug("Error in contact delete");
            return 500;
        }
        return 200;
    }

    public int updateItem(SyncItem updItem) throws SyncException {
        this.cancel();
        try {
            this.iContactsManager.updateContact(updItem);
        }
        catch (Exception e) {
            this.lastSyncSuccesful = false;
            LogViewer.debug("Error in contact update");
            return 500;
        }
        return 200;
    }

    protected SyncItem getItemContent(SyncItem item) throws SyncException {
        LogViewer.debug("getItemContent: " + item.getKey());
        this.cancel();
        return this.iContactsManager.getItemWithContent(item);
    }

    protected void initAllItems() throws SyncException {
        LogViewer.debug("initAllItems");
        this.cancel();
        this.allItems = this.iContactsManager.getAllContacts();
    }

    protected void initDelItems() throws SyncException {
        LogViewer.debug("initDelItems");
        this.cancel();
        this.delItems = this.iContactsManager.getDeletedContacts();
    }

    protected void initNewItems() throws SyncException {
        LogViewer.debug("initNewItems");
        this.cancel();
        this.newItems = this.iContactsManager.getNewContacts();
    }

    protected void initUpdItems() throws SyncException {
        LogViewer.debug("initUpdItems");
        this.cancel();
        this.updItems = this.iContactsManager.getUpdatedContacts();
    }

    public void setAllItems(SyncItem[] allItems) {
        this.allItems = allItems;
    }

    public void beginSync(int syncMode) throws SyncException {
        this.iCancelled = false;
        this.lastSyncSuccesful = true;
        super.setServerItemsNumber(-1);
        super.beginSync(syncMode);
        this.iLastSyncMode = syncMode;
        LogViewer.debug("SYNC: " + syncMode);
        LogViewer.debug("Start, Last anchor:" + new Date(super.getLastAnchor()).toString());
        switch (syncMode) {
            case 205: {
                try {
                    this.iContactsManager.clearContacts();
                }
                catch (PIMException ex) {
                    ex.printStackTrace();
                }
                this.setNextAnchor(0L);
                break;
            }
            case 202: {
                LogViewer.debug("Start, Last anchor:" + new Date(super.getLastAnchor()).toString());
                break;
            }
            case 201: {
                LogViewer.debug("Slow sync");
                ((ContactsSyncListener)this.getListener()).setTotalItems(super.getClientItemsNumber());
            }
        }
    }

    public int lastSyncMode() {
        return this.iLastSyncMode;
    }

    public void cancelSync() throws SyncException {
        LogViewer.debug("ContactsSource::cancelSync");
        this.iCancelled = true;
    }

    public void endSync() throws SyncException {
        super.endSync();
        LogViewer.debug("ContactsSource::endSync;globalStatus " + this.globalStatus);
    }

    public int getClientItemsNumber() {
        LogViewer.debug("getClientItemsNumber");
        this.cancel();
        return super.getClientItemsNumber();
    }

    public int getUpdIndex() {
        LogViewer.debug("getUpdIndex");
        this.cancel();
        return this.updIndex;
    }

    public void setUpdItems(SyncItem[] updItems) {
        LogViewer.debug("setUpdItems, " + updItems.length);
        this.updItems = updItems;
        this.cancel();
    }

    public void setDelItems(SyncItem[] delItems) {
        LogViewer.debug("setDelItems, " + delItems.length);
        this.delItems = delItems;
        this.cancel();
    }

    public void setNewItems(SyncItem[] newItems) {
        LogViewer.debug("setNewItems, " + newItems.length);
        this.newItems = newItems;
        this.cancel();
    }

    public void setServerItemsNumber(int number) {
        LogViewer.debug("setServerItemsNumber: " + number);
        super.setServerItemsNumber(number);
    }

    public int getServerItemsNumber() {
        LogViewer.debug("getServerItemsNumber: " + super.getServerItemsNumber());
        this.cancel();
        return super.getServerItemsNumber();
    }

    public void setItemStatus(String aKey, int aStatus) throws SyncException {
        super.setItemStatus(aKey, aStatus);
        this.cancel();
        LogViewer.debug("SetItemStatus: " + aKey + " | " + aStatus);
        this.iContactsManager.setItemStatus(aKey, aStatus);
    }

    private void cancel() {
        if (this.iCancelled) {
            throw new SyncException(5, Locale.get("SYNCHRONIZATION_ERROR_DETECTED"));
        }
    }

    public void sessionEnded(int status) {
        this.iContactsManager.setSessionStatus(status);
    }
}

