/*
 * Decompiled with CFR 0.152.
 */
package com.telefonica.copiagenda.ui;

import com.nokia.mid.ui.DirectGraphics;
import com.nokia.mid.ui.DirectUtils;
import com.telefonica.copiagenda.ui.CustomizedItem;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class MainMenuItem
extends CustomizedItem {
    private String iLabel;
    private Image iImage;
    public final int iIndex;
    private Display iDisplay;
    private static final int ALPHA = Integer.MIN_VALUE;
    private static final int FULL_TRANSPARENT = 0;
    private final boolean iNokiaPhone;

    public MainMenuItem(String aLabel, Image aImage, int aWidth, Display aDisplay, int aIndex, boolean aIsNokiaPhone) {
        super("");
        this.iIndex = aIndex;
        this.iImage = aImage;
        this.setMinContentHeight(this.iImage.getHeight() + 5);
        this.setMinContentWidth(aWidth);
        this.iLabel = aLabel;
        this.iDisplay = aDisplay;
        this.iNokiaPhone = aIsNokiaPhone;
    }

    public String getLabelText() {
        return this.iLabel;
    }

    protected void paint(Graphics aGraphics, int aWidth, int aHeight) {
        Font largeFont = Font.getFont((int)0, (int)0, (int)0);
        aGraphics.setFont(largeFont);
        aGraphics.setColor(this.iDisplay.getColor(1));
        int vPadding = 3;
        int hPadding = this.iImage.getWidth() / 6;
        this.drawFocus(aGraphics, aWidth, aHeight, this.iDisplay);
        aGraphics.drawImage(this.iImage, hPadding, vPadding, 20);
        int textWidth = aGraphics.getFont().stringWidth(this.iLabel);
        int textY = this.iImage.getHeight() / 2 + vPadding / 2 - aGraphics.getFont().getHeight() / 2;
        int available = this.getPreferredWidth() - this.iImage.getWidth() - hPadding;
        if (available > textWidth) {
            aGraphics.drawString(this.iLabel, this.iImage.getWidth() + hPadding * 2, textY, 20);
        } else {
            int index = this.iLabel.indexOf(32);
            aGraphics.drawString(this.iLabel.substring(0, index), this.iImage.getWidth() + hPadding * 2, textY, 20);
            aGraphics.drawString(this.iLabel.substring(index + 1), this.iImage.getWidth() + hPadding * 2, textY + aGraphics.getFont().getHeight(), 20);
        }
    }

    protected void drawFocus(Graphics aGraphics, int aWidth, int aHeight, Display aDisplay) {
        DirectGraphics directGraphics = DirectUtils.getDirectGraphics((Graphics)aGraphics);
        if (this.iFocus) {
            directGraphics.setARGBColor(aDisplay.getColor(2) + Integer.MIN_VALUE);
            aGraphics.fillRect(0, 0, aWidth, aHeight);
        } else if (!this.iNokiaPhone) {
            directGraphics.setARGBColor(aDisplay.getColor(0) + 0);
            aGraphics.fillRect(0, 0, aWidth, aHeight);
        }
        if (this.iFocus) {
            aGraphics.setColor(aDisplay.getColor(3));
        } else {
            int fore = aDisplay.getColor(1);
            if (fore == aDisplay.getColor(2)) {
                fore = aDisplay.getColor(3);
            }
            aGraphics.setColor(fore);
        }
    }
}

