/*
 * Decompiled with CFR 0.152.
 */
package com.telefonica.copiagenda.ui;

import com.telefonica.copiagenda.ui.CustomizedItem;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class MainMenuItemLCDUI
extends CustomizedItem {
    private String iLabel;
    private Image iImage;
    public final int iIndex;
    private Display iDisplay;

    public MainMenuItemLCDUI(String aLabel, Image aImage, int aWidth, Display aDisplay, int aIndex) {
        super("");
        this.iIndex = aIndex;
        this.iImage = aImage;
        this.setMinContentHeight(this.iImage.getHeight() + 5);
        this.setMinContentWidth(aWidth);
        this.iLabel = aLabel;
        this.iDisplay = aDisplay;
    }

    public String getLabelText() {
        return this.iLabel;
    }

    protected void paint(Graphics aGraphics, int aWidth, int aHeight) {
        Font largeFont = Font.getFont((int)0, (int)0, (int)0);
        aGraphics.setFont(largeFont);
        aGraphics.setColor(this.iDisplay.getColor(1));
        int vPadding = 3;
        int hPadding = this.iImage.getWidth() / 6;
        this.drawFocus(aGraphics, aWidth, aHeight, this.iDisplay);
        aGraphics.drawImage(this.iImage, hPadding, vPadding, 20);
        int textWidth = aGraphics.getFont().stringWidth(this.iLabel);
        int textY = aGraphics.getFont().getHeight() / 2;
        int available = this.getPreferredWidth() - this.iImage.getWidth() - hPadding;
        if (available > textWidth) {
            aGraphics.drawString(this.iLabel, this.iImage.getWidth() + hPadding * 2, textY, 20);
        } else {
            int index = this.iLabel.indexOf(32);
            aGraphics.drawString(this.iLabel.substring(0, index), this.iImage.getWidth() + hPadding, 0, 20);
            aGraphics.drawString(this.iLabel.substring(index + 1), this.iImage.getWidth() + hPadding, aGraphics.getFont().getHeight(), 20);
        }
    }

    protected void drawFocus(Graphics aGraphics, int aWidth, int aHeight, Display aDisplay) {
        if (this.iFocus) {
            aGraphics.setColor(aDisplay.getColor(2));
            aGraphics.fillRect(0, 0, aWidth, aHeight);
        } else {
            aGraphics.setColor(aDisplay.getColor(0));
            aGraphics.fillRect(0, 0, aWidth, aHeight);
        }
        if (this.iFocus) {
            aGraphics.setColor(aDisplay.getColor(3));
        } else {
            int fore = aDisplay.getColor(1);
            if (fore == aDisplay.getColor(2)) {
                fore = aDisplay.getColor(3);
            }
            aGraphics.setColor(fore);
        }
    }
}

