



function Audio() {
	// --------------------------------------------------------------- Variables
	 /* Indicador de audio habilitado */
	this.audio_enabled = true;
	/* Valor del audio guardado en rms */
	this.audio_stored = true;
	
	this.volume = 0;
	
};
Audio.prototype = {
		
	init: function() {
		this.volume = DEFAULT_VOLUME;
		try {
			var v = cache.load("volume");
			if(typeof(v) == 'boolean') {
				this.audio_enabled=v;
			}
			
			this.audio_stored=this.audio_enabled;
		} catch (err) {
			trace("error cargando informacin de volumen: "+err);
		}
	},
	
	playAudio: function(audioFile) {
		if(this.audio_enabled) {
			var self = this;
			var audioPlayer=player.media.getByUri(audioFile, true, 'audio/amr');
			audioPlayer.onreadystatechange = function(audioPlayer) {
				var state = audioPlayer.readyState;
				
				if(state == 1 || state == 5) {
					audioPlayer.volume = self.volume;
				}
			};
		    audioPlayer.onvolumechange = function(player) {
		    	trace(" ---> Volume changed"+player.volume);
		    	self.volume = player.volume;
		    	trace("changedVolume --> "+self.volume);
		    };

			
			audioPlayer.play();
		}
	},
	
	switchVolume: function() {
		this.audio_enabled = !this.audio_enabled;
		softMenu.switchVolumeLabel(this.audio_enabled);
	},
	
	saveVolume: function() {
		if (this.audio_stored != this.audio_enabled) {
			cache.save("volume",this.audio_enabled);
			this.audio_stored = this.audio_enabled;
		}
	}
};

var audio = new Audio();
audio.init();

/*
var volume = true;
var volume_aux=true;

try {
	var v = cache.load("volume");
	if(typeof(v) == 'boolean') {
		volume=v;
	}
	
	volume_aux=volume;
} catch (err) {
	trace("error cargando informacin de volumen: "+err);
}
*/
