/*
 * Decompiled with CFR 0.152.
 */
package com.sonyericsson.javavm;

import com.sonyericsson.javavm.ChunkInfo;
import com.sonyericsson.javavm.DBG;
import com.sonyericsson.javavm.HeapInfo;
import com.sonyericsson.javavm.IsolateInfo;
import javax.microedition.lcdui.ChoiceGroup;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Form;
import javax.microedition.lcdui.Item;
import javax.microedition.lcdui.List;
import javax.microedition.lcdui.TextField;
import javax.microedition.midlet.MIDlet;
import javax.microedition.midlet.MIDletStateChangeException;

public class DebugMidlet
extends MIDlet
implements CommandListener {
    protected Command exitCommand = new Command("Exit", 7, 5);
    protected Command mainMenuCommand = new Command("Main", 2, 1);
    protected DMMainMenu mainMenu = new DMMainMenu(this);
    protected IsolateForm isolateForm = new IsolateForm(this);
    protected ChunkListForm chunkListForm = new ChunkListForm(this);
    protected SetMemForm setMemForm = new SetMemForm(this);
    protected GetMVMForm getMVMForm = new GetMVMForm(this);
    protected SetMVMForm setMVMForm = new SetMVMForm(this);
    protected AboutForm aboutForm;
    protected MethodTraceViewForm methodTraceViewForm = new MethodTraceViewForm(this);

    public DebugMidlet() {
        this.aboutForm = new AboutForm("About", this);
        StringBuffer sb = new StringBuffer();
        sb.append("JavaVM Debug MIDlet\n");
        sb.append("This MIDlet was developed by the Java VM team.\n");
        sb.append("Contact us via:\n");
        sb.append("https://javawiki.sonyericsson.net/wiki/Java/Teams/VM");
        TextField tf1 = new TextField("About", sb.toString(), sb.length(), 131072);
        tf1.setLayout(16384);
        this.aboutForm.append((Item)tf1);
    }

    protected void destroyApp(boolean arg0) throws MIDletStateChangeException {
    }

    protected void pauseApp() {
    }

    protected void startApp() throws MIDletStateChangeException {
        Display.getDisplay((MIDlet)this).setCurrent((Displayable)this.mainMenu);
    }

    public void commandAction(Command command, Displayable displayable) {
        if (command == this.exitCommand) {
            try {
                this.destroyApp(false);
            }
            catch (MIDletStateChangeException e) {
                e.printStackTrace();
            }
            this.notifyDestroyed();
        } else if (displayable == this.mainMenu) {
            this.mainMenu.commandAction(command, displayable);
        } else if (displayable == this.isolateForm) {
            this.isolateForm.commandAction(command, displayable);
        } else if (displayable == this.chunkListForm) {
            this.chunkListForm.commandAction(command, displayable);
        } else if (displayable == this.setMemForm) {
            this.setMemForm.commandAction(command, displayable);
        } else if (displayable == this.getMVMForm) {
            this.getMVMForm.commandAction(command, displayable);
        } else if (displayable == this.setMVMForm) {
            this.setMVMForm.commandAction(command, displayable);
        } else if (displayable == this.methodTraceViewForm) {
            this.methodTraceViewForm.commandAction(command, displayable);
        }
    }

    class DMMainMenu
    extends List
    implements CommandListener {
        private DebugMidlet debugMidlet;

        DMMainMenu(DebugMidlet debugMidlet2) {
            super("Main", 3);
            this.debugMidlet = debugMidlet2;
            this.append("Isolates", null);
            this.append("SetMem", null);
            this.append("ChunkList", null);
            this.append("GetMVM", null);
            this.append("SetMVM", null);
            this.append("Crash", null);
            this.append("ViewMTrace", null);
            this.append("RestartMTrace", null);
            this.addCommand(debugMidlet2.exitCommand);
            this.setCommandListener(debugMidlet2);
        }

        public void commandAction(Command command, Displayable displayable) {
            switch (this.getSelectedIndex()) {
                case 0: {
                    DebugMidlet.this.isolateForm.addInfo();
                    Display.getDisplay((MIDlet)this.debugMidlet).setCurrent((Displayable)this.debugMidlet.isolateForm);
                    break;
                }
                case 1: {
                    Display.getDisplay((MIDlet)this.debugMidlet).setCurrent((Displayable)this.debugMidlet.setMemForm);
                    break;
                }
                case 2: {
                    DebugMidlet.this.chunkListForm.addInfo();
                    Display.getDisplay((MIDlet)this.debugMidlet).setCurrent((Displayable)this.debugMidlet.chunkListForm);
                    break;
                }
                case 3: {
                    DebugMidlet.this.getMVMForm.addInfo();
                    Display.getDisplay((MIDlet)this.debugMidlet).setCurrent((Displayable)this.debugMidlet.getMVMForm);
                    break;
                }
                case 4: {
                    Display.getDisplay((MIDlet)this.debugMidlet).setCurrent((Displayable)this.debugMidlet.setMVMForm);
                    break;
                }
                case 5: {
                    DBG.crash();
                    break;
                }
                case 6: {
                    DebugMidlet.this.methodTraceViewForm.addInfo();
                    Display.getDisplay((MIDlet)this.debugMidlet).setCurrent((Displayable)this.debugMidlet.methodTraceViewForm);
                    break;
                }
                case 7: {
                    DBG.traceRestart();
                    break;
                }
                case 8: {
                    Display.getDisplay((MIDlet)this.debugMidlet).setCurrent((Displayable)this.debugMidlet.aboutForm);
                    break;
                }
            }
        }
    }

    abstract class OutputForm
    extends Form
    implements CommandListener {
        protected DebugMidlet debugMidlet;
        protected Command resetCommand = new Command("Reset", 1, 1);
        protected Command refreshCommand = new Command("Refresh", 1, 1);

        OutputForm(String name, DebugMidlet debugMidlet2) {
            super(name);
            this.debugMidlet = debugMidlet2;
            this.addCommand(this.refreshCommand);
            this.addCommand(this.resetCommand);
            this.addCommand(debugMidlet2.mainMenuCommand);
            this.setCommandListener(debugMidlet2);
        }

        public void commandAction(Command command, Displayable displayable) {
            if (command == this.resetCommand) {
                this.deleteAll();
            } else if (command == this.debugMidlet.mainMenuCommand) {
                Display.getDisplay((MIDlet)this.debugMidlet).setCurrent((Displayable)this.debugMidlet.mainMenu);
            } else if (command == this.refreshCommand) {
                this.addInfo();
            }
        }

        public abstract void addInfo();
    }

    class IsolateForm
    extends OutputForm
    implements CommandListener {
        IsolateForm(DebugMidlet debugMidlet2) {
            super("Isolates", debugMidlet2);
        }

        public void addInfo() {
            StringBuffer sb = new StringBuffer();
            IsolateInfo isoInfo = new IsolateInfo();
            DBG.fillIsolateInfo((IsolateInfo)isoInfo);
            sb = new StringBuffer();
            sb.append("MidletCounter=");
            sb.append(isoInfo.midletCounter);
            sb.append(", SemcletCounter=");
            sb.append(isoInfo.semcletCounter);
            sb.append(", DebugCounter=");
            sb.append(isoInfo.debugCounter);
            sb.append(", ProfilingCounter=");
            sb.append(isoInfo.profilingCounter);
            sb.append(", CompilerCounter=");
            sb.append(isoInfo.compilerCounter);
            TextField tf1 = new TextField("Isolates", sb.toString(), sb.length(), 131072);
            tf1.setLayout(16384);
            this.append((Item)tf1);
        }
    }

    class ChunkListForm
    extends OutputForm
    implements CommandListener {
        ChunkListForm(DebugMidlet debugMidlet2) {
            super("ChunkList", debugMidlet2);
        }

        public void addInfo() {
            StringBuffer sb = new StringBuffer();
            HeapInfo heapInfo = new HeapInfo();
            DBG.fillHeapInfo((HeapInfo)heapInfo);
            sb = new StringBuffer();
            sb.append("ChunkDefaultSize=");
            sb.append(heapInfo.chunkDefaultSize);
            sb.append(", ChunkTryExpansion=");
            sb.append(heapInfo.chunkTryExpansion);
            sb.append(", PreventGCDuringAlloc=");
            sb.append(heapInfo.preventGcDuringAlloc);
            sb.append("\n");
            int j = 0;
            while (j < heapInfo.counter) {
                ChunkInfo ci = heapInfo.chunkInfos[j];
                sb.append("\n");
                sb.append("Base=0x");
                sb.append(Integer.toHexString(ci.base).toUpperCase());
                sb.append(" Size=");
                sb.append(ci.size);
                sb.append(" Seq=");
                sb.append(ci.sequence);
                sb.append(" Lock=");
                sb.append(ci.isLocked);
                ++j;
            }
            System.out.println(sb.toString());
            TextField tf1 = new TextField("ChunkList", sb.toString(), sb.length(), 131072);
            tf1.setLayout(16384);
            this.debugMidlet.chunkListForm.append((Item)tf1);
        }
    }

    class GetMVMForm
    extends Form
    implements CommandListener {
        private DebugMidlet debugMidlet;
        private Command resetCommand = new Command("Reset", 1, 1);
        private Command refreshCommand = new Command("Refresh", 1, 1);

        GetMVMForm(DebugMidlet debugMidlet2) {
            super("GetMVM");
            this.debugMidlet = debugMidlet2;
            this.addCommand(this.refreshCommand);
            this.addCommand(this.resetCommand);
            this.addCommand(debugMidlet2.mainMenuCommand);
            this.setCommandListener(debugMidlet2);
        }

        public void commandAction(Command command, Displayable displayable) {
            if (command == this.resetCommand) {
                this.deleteAll();
            } else if (command == this.debugMidlet.mainMenuCommand) {
                Display.getDisplay((MIDlet)this.debugMidlet).setCurrent((Displayable)this.debugMidlet.mainMenu);
            } else if (command == this.refreshCommand) {
                this.addInfo();
            }
        }

        public void addInfo() {
            StringBuffer sb = new StringBuffer();
            sb = new StringBuffer();
            sb.append("max isolates=");
            sb.append(DBG.getMVMProperties((int)1));
            sb.append("\nmax midlets=");
            sb.append(DBG.getMVMProperties((int)2));
            sb.append("\nmax semclets=");
            sb.append(DBG.getMVMProperties((int)3));
            sb.append("\nmax debugs=");
            sb.append(DBG.getMVMProperties((int)4));
            sb.append("\nmax compilers=");
            sb.append(DBG.getMVMProperties((int)5));
            sb.append("\nmax profilings=");
            sb.append(DBG.getMVMProperties((int)6));
            TextField tf1 = new TextField("MVM properties", sb.toString(), sb.length(), 131072);
            tf1.setLayout(16384);
            this.append((Item)tf1);
        }
    }

    class SetMemForm
    extends Form
    implements CommandListener {
        private DebugMidlet debugMidlet;
        private TextField chunkSizeField = new TextField("DefaultChunkSize", null, 15, 2);
        private TextField expansionField = new TextField("ChunkTryExpansion", null, 5, 2);
        private ChoiceGroup gcAllocChoice = new ChoiceGroup("preventGcDuringAlloc", 1);
        private ChoiceGroup addChunkInAdvanceCG = new ChoiceGroup("addChunkInAdvance", 1);
        private Command setCommand = new Command("Set", 1, 1);

        SetMemForm(DebugMidlet debugMidlet2) {
            super("SetMem");
            this.debugMidlet = debugMidlet2;
            this.gcAllocChoice.append("On", null);
            this.gcAllocChoice.append("Off", null);
            this.addChunkInAdvanceCG.append("On", null);
            this.addChunkInAdvanceCG.append("Off", null);
            this.append((Item)this.chunkSizeField);
            this.append((Item)this.expansionField);
            this.append((Item)this.gcAllocChoice);
            this.append((Item)this.addChunkInAdvanceCG);
            HeapInfo heapInfo = new HeapInfo();
            DBG.fillHeapInfo((HeapInfo)heapInfo);
            this.chunkSizeField.setString(Integer.toString(heapInfo.chunkDefaultSize));
            this.expansionField.setString(Integer.toString(heapInfo.chunkTryExpansion));
            if (heapInfo.preventGcDuringAlloc) {
                this.gcAllocChoice.setSelectedIndex(0, true);
            } else {
                this.gcAllocChoice.setSelectedIndex(1, true);
            }
            if (heapInfo.addChunkInAdvance) {
                this.addChunkInAdvanceCG.setSelectedIndex(0, true);
            } else {
                this.addChunkInAdvanceCG.setSelectedIndex(1, true);
            }
            this.addCommand(this.setCommand);
            this.addCommand(debugMidlet2.mainMenuCommand);
            this.setCommandListener(debugMidlet2);
        }

        public void commandAction(Command command, Displayable displayable) {
            if (command == this.debugMidlet.mainMenuCommand) {
                Display.getDisplay((MIDlet)this.debugMidlet).setCurrent((Displayable)this.debugMidlet.mainMenu);
            } else if (command == this.setCommand) {
                String chunkSizeStr = this.chunkSizeField.getString();
                String expansionStr = this.expansionField.getString();
                if (chunkSizeStr != null && expansionStr != null && chunkSizeStr.trim().length() > 0 && expansionStr.trim().length() > 0) {
                    int chunkSize = Integer.parseInt(chunkSizeStr);
                    int expansion = Integer.parseInt(expansionStr);
                    if (chunkSize >= 0 && expansion >= 0) {
                        boolean doGCAlloc = this.gcAllocChoice.getSelectedIndex() == 0;
                        boolean doAddChunkInAdvance = this.addChunkInAdvanceCG.getSelectedIndex() == 0;
                        DBG.setMem((int)chunkSize, (int)expansion, (boolean)doGCAlloc, (boolean)doAddChunkInAdvance);
                    }
                }
            }
        }
    }

    class SetMVMForm
    extends Form
    implements CommandListener {
        private DebugMidlet debugMidlet;
        private ChoiceGroup mvmProperties = new ChoiceGroup("Property", 1);
        private TextField valueField = new TextField("Value", null, 5, 2);
        private Command setCommand = new Command("Set", 1, 1);
        private int[] propertyTypes = new int[]{1, 2, 3, 4, 5, 6};

        SetMVMForm(DebugMidlet debugMidlet2) {
            super("SetMVM");
            this.debugMidlet = debugMidlet2;
            this.mvmProperties.append("MVM_MAX_INSTANCES", null);
            this.mvmProperties.append("MVM_MAX_MIDLETS", null);
            this.mvmProperties.append("MVM_MAX_SEMCLETS", null);
            this.mvmProperties.append("MVM_MAX_DEBUGS", null);
            this.mvmProperties.append("MVM_MAX_PROFILINGS", null);
            this.mvmProperties.append("MVM_MAX_COMPILERS", null);
            this.append((Item)this.mvmProperties);
            this.append((Item)this.valueField);
            this.addCommand(this.setCommand);
            this.addCommand(debugMidlet2.mainMenuCommand);
            this.setCommandListener(debugMidlet2);
        }

        public void commandAction(Command command, Displayable displayable) {
            String valueStr;
            if (command == this.debugMidlet.mainMenuCommand) {
                Display.getDisplay((MIDlet)this.debugMidlet).setCurrent((Displayable)this.debugMidlet.mainMenu);
            } else if (command == this.setCommand && (valueStr = this.valueField.getString()) != null && valueStr.trim().length() > 0) {
                int value = Integer.parseInt(valueStr);
                int propIndex = this.mvmProperties.getSelectedIndex();
                if (value >= 0 && propIndex > 0 && propIndex < this.propertyTypes.length) {
                    DBG.setMVMProperties((int)this.propertyTypes[propIndex], (int)value);
                }
            }
        }
    }

    class MethodTraceViewForm
    extends OutputForm
    implements CommandListener {
        private final int NUM_TRACE_ID;

        MethodTraceViewForm(DebugMidlet debugMidlet2) {
            super("MethodTrace", debugMidlet2);
            this.NUM_TRACE_ID = 500;
        }

        public void addInfo() {
            StringBuffer sb = new StringBuffer();
            int[] methodIDList = new int[500];
            int n = DBG.traceFillList((int[])methodIDList);
            int i = 0;
            while (i < n) {
                if (i != 0) {
                    sb.append(", ");
                }
                sb.append(methodIDList[i]);
                ++i;
            }
            TextField tf1 = new TextField("Method IDs", sb.toString(), sb.length(), 131072);
            tf1.setLayout(16384);
            this.append((Item)tf1);
        }
    }

    class AboutForm
    extends Form
    implements CommandListener {
        protected DebugMidlet debugMidlet;

        public void commandAction(Command command, Displayable displayable) {
            if (command == this.debugMidlet.mainMenuCommand) {
                Display.getDisplay((MIDlet)this.debugMidlet).setCurrent((Displayable)this.debugMidlet.mainMenu);
            }
        }

        AboutForm(String name, DebugMidlet debugMidlet2) {
            super(name);
            this.debugMidlet = debugMidlet2;
            this.addCommand(debugMidlet2.mainMenuCommand);
            this.setCommandListener(debugMidlet2);
        }
    }
}

