/*
 * Decompiled with CFR 0.152.
 */
package alert;

import javax.microedition.lcdui.Alert;
import javax.microedition.lcdui.AlertType;
import javax.microedition.lcdui.ChoiceGroup;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Form;
import javax.microedition.lcdui.Gauge;
import javax.microedition.lcdui.Item;
import javax.microedition.midlet.MIDlet;

public class AlertDemo
extends MIDlet {
    private static final Command CMD_EXIT = new Command("Exit", 7, 1);
    private static final Command CMD_SHOW = new Command("Show", 1, 1);
    private static final String[] typeStrings = new String[]{"Alarm", "Confirmation", "Error", "Info", "Warning"};
    private static final String[] timeoutStrings = new String[]{"2 Seconds", "4 Seconds", "8 Seconds", "Forever"};
    private static final int SECOND = 1000;
    private Display display;
    private boolean firstTime = true;
    private Form mainForm = new Form("Alert Options");

    protected void startApp() {
        this.display = Display.getDisplay((MIDlet)this);
        this.showOption();
    }

    private void showOption() {
        if (this.firstTime) {
            ChoiceGroup choiceGroup = new ChoiceGroup("Type", 4, typeStrings, null);
            this.mainForm.append((Item)choiceGroup);
            ChoiceGroup choiceGroup2 = new ChoiceGroup("Timeout", 4, timeoutStrings, null);
            this.mainForm.append((Item)choiceGroup2);
            String[] stringArray = new String[]{"Show Indicator"};
            ChoiceGroup choiceGroup3 = new ChoiceGroup("Options", 2, stringArray, null);
            this.mainForm.append((Item)choiceGroup3);
            this.mainForm.addCommand(CMD_SHOW);
            this.mainForm.addCommand(CMD_EXIT);
            this.mainForm.setCommandListener((CommandListener)new AlertListener(choiceGroup, choiceGroup2, choiceGroup3));
            this.firstTime = false;
        }
        this.display.setCurrent((Displayable)this.mainForm);
    }

    protected void destroyApp(boolean bl) {
    }

    protected void pauseApp() {
    }

    private Gauge createIndicator(int n) {
        if (n == -2) {
            return new Gauge(null, false, -1, 2);
        }
        final int n2 = n / 1000;
        final Gauge gauge = new Gauge(null, false, n2, 0);
        new Thread(){

            public void run() {
                int n = 0;
                while (n < n2) {
                    gauge.setValue(n);
                    ++n;
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
        }.start();
        return gauge;
    }

    private class AlertListener
    implements CommandListener {
        AlertType[] alertTypes = new AlertType[]{AlertType.ALARM, AlertType.CONFIRMATION, AlertType.ERROR, AlertType.INFO, AlertType.WARNING};
        ChoiceGroup typesCG;
        int[] timeouts = new int[]{2000, 4000, 8000, -2};
        ChoiceGroup timeoutsCG;
        ChoiceGroup indicatorCG;

        public AlertListener(ChoiceGroup choiceGroup, ChoiceGroup choiceGroup2, ChoiceGroup choiceGroup3) {
            this.typesCG = choiceGroup;
            this.timeoutsCG = choiceGroup2;
            this.indicatorCG = choiceGroup3;
        }

        public void commandAction(Command command, Displayable displayable) {
            if (command == CMD_SHOW) {
                int n = this.typesCG.getSelectedIndex();
                Alert alert = new Alert("Alert");
                alert.setType(this.alertTypes[n]);
                int n2 = this.timeoutsCG.getSelectedIndex();
                alert.setTimeout(this.timeouts[n2]);
                alert.setString(typeStrings[n] + " Alert, Running " + timeoutStrings[n2]);
                boolean[] blArray = new boolean[1];
                this.indicatorCG.getSelectedFlags(blArray);
                if (blArray[0]) {
                    Gauge gauge = AlertDemo.this.createIndicator(this.timeouts[n2]);
                    alert.setIndicator(gauge);
                }
                AlertDemo.this.display.setCurrent((Displayable)alert);
            } else if (command == CMD_EXIT) {
                AlertDemo.this.destroyApp(false);
                AlertDemo.this.notifyDestroyed();
            }
        }
    }
}

