/*
 * Decompiled with CFR 0.152.
 */
package com.sonyericsson.picasaweb.service.action;

import com.sonyericsson.picasaweb.model.Entry;
import com.sonyericsson.picasaweb.service.Result;
import com.sonyericsson.picasaweb.service.ServiceException;
import com.sonyericsson.picasaweb.service.http.FeedRequest;
import com.sonyericsson.picasaweb.service.http.UrlFactory;
import com.sonyericsson.picasaweb.service.xml.AlbumParser;
import com.sonyericsson.picasaweb.service.xml.CommentParser;
import com.sonyericsson.picasaweb.service.xml.EntryParser;
import com.sonyericsson.picasaweb.service.xml.PhotoParser;
import com.sonyericsson.picasaweb.util.Attributes;
import com.sonyericsson.picasaweb.util.HttpRequest;
import com.sonyericsson.picasaweb.util.HttpUtil;
import com.sonyericsson.picasaweb.util.IOUtil;
import java.io.IOException;
import javax.microedition.io.Connection;
import javax.microedition.io.Connector;
import javax.microedition.io.file.FileConnection;

public abstract class ActionUtil {
    public static void doHttpRequest(HttpRequest request) throws ServiceException {
        int result;
        try {
            HttpUtil.doRequest(request);
            result = Result.fromHttpResponseCode(request.getResponseCode());
        }
        catch (IOException e) {
            result = 8;
        }
        if (result != 0) {
            throw new ServiceException(result);
        }
    }

    public static Entry fetchEntry(String authToken, Attributes inAttr) throws ServiceException {
        String requestUrl = null;
        EntryParser entryParser = null;
        if (authToken == null) {
            throw new ServiceException(5);
        }
        String type = inAttr.get("item:type");
        if (type == null) {
            throw new ServiceException(4);
        }
        String entryId = inAttr.get(String.valueOf(type) + ":id");
        if (entryId == null) {
            throw new ServiceException(4);
        }
        if (type.equals("album")) {
            requestUrl = UrlFactory.createGetAlbumUrl(entryId);
            entryParser = new AlbumParser(0, 1, "/entry");
        } else if (type.equals("content")) {
            requestUrl = UrlFactory.createGetPhotoUrl(entryId);
            entryParser = new PhotoParser(0, 1, "/entry");
        } else if (type.equals("comment")) {
            requestUrl = UrlFactory.createGetCommentUrl(entryId);
            entryParser = new CommentParser(0, 1, "/entry");
        } else {
            throw new ServiceException(3);
        }
        if (requestUrl == null || entryParser == null) {
            throw new ServiceException(11);
        }
        FeedRequest fr = new FeedRequest(requestUrl, authToken, entryParser);
        ActionUtil.doHttpRequest(fr);
        Entry entry = entryParser.getFirstEntry();
        if (entry == null) {
            throw new ServiceException(11);
        }
        return entry;
    }

    public static boolean hasDownloadMarker(String localUrl) {
        return IOUtil.fileExists(String.valueOf(localUrl) + ".dl");
    }

    public static void createDownloadMarker(String localUrl) {
        block6: {
            FileConnection fc = null;
            try {
                try {
                    fc = (FileConnection)Connector.open((String)(String.valueOf(localUrl) + ".dl"));
                    if (!fc.exists()) {
                        fc.create();
                    }
                }
                catch (IOException iOException) {
                    IOUtil.closeConnection(fc);
                    break block6;
                }
            }
            catch (Throwable throwable) {
                IOUtil.closeConnection(fc);
                throw throwable;
            }
            IOUtil.closeConnection((Connection)fc);
        }
    }

    public static void deleteDownloadMarker(String localUrl) {
        IOUtil.deleteFile(String.valueOf(localUrl) + ".dl");
    }

    private static String getFullDir(String baseDir, String dir) {
        String fullDir;
        block6: {
            fullDir = baseDir.endsWith("/") ? String.valueOf(baseDir) + dir : String.valueOf(baseDir) + "/" + dir;
            FileConnection fc = null;
            try {
                try {
                    fc = (FileConnection)Connector.open((String)fullDir);
                    if (!fc.exists()) {
                        fc.mkdir();
                    }
                }
                catch (IOException iOException) {
                    IOUtil.closeConnection((Connection)fc);
                    break block6;
                }
            }
            catch (Throwable throwable) {
                IOUtil.closeConnection(fc);
                throw throwable;
            }
            IOUtil.closeConnection((Connection)fc);
        }
        return fullDir;
    }

    public static String getCacheDir(String baseDir) {
        return ActionUtil.getFullDir(baseDir, "cache");
    }

    public static String getTempDir(String baseDir) {
        return ActionUtil.getFullDir(baseDir, "temp");
    }
}

