/*
 * Decompiled with CFR 0.152.
 */
package com.sonyericsson.picasaweb.service.action;

import com.sonyericsson.picasaweb.log.Log;
import com.sonyericsson.picasaweb.model.DownloadItem;
import com.sonyericsson.picasaweb.model.Resource;
import com.sonyericsson.picasaweb.model.TransferItem;
import com.sonyericsson.picasaweb.service.AuthorizationStore;
import com.sonyericsson.picasaweb.service.Result;
import com.sonyericsson.picasaweb.service.ServiceException;
import com.sonyericsson.picasaweb.service.action.Action;
import com.sonyericsson.picasaweb.service.action.ActionData;
import com.sonyericsson.picasaweb.service.action.ActionHandler;
import com.sonyericsson.picasaweb.service.action.ActionResponseListener;
import com.sonyericsson.picasaweb.service.action.ActionUtil;
import com.sonyericsson.picasaweb.service.action.DownloadJob;
import com.sonyericsson.picasaweb.service.action.DownloadJobResponseHandler;
import com.sonyericsson.picasaweb.service.job.JobManager;
import com.sonyericsson.picasaweb.util.Attributes;
import com.sonyericsson.picasaweb.util.HttpUtil;
import com.sonyericsson.picasaweb.util.IOUtil;

public class DownloadActionHandler
implements ActionHandler {
    private AuthorizationStore authStore;
    private JobManager jobManager;

    public DownloadActionHandler(AuthorizationStore authStore, JobManager jobManager) {
        this.authStore = authStore;
        this.jobManager = jobManager;
    }

    public void handleAction(Action action, ActionResponseListener responseListener) {
        ActionData mainData = action.getMainData();
        Attributes mainInAttr = mainData.getAttributes();
        String authToken = this.authStore.getUserInfo().getAuthToken();
        try {
            int transferId = 0;
            int nrItems = action.getChildDataCount();
            int nrCompletedItems = 0;
            TransferItem[] items = new DownloadItem[nrItems];
            String baseDir = mainData.getUrl();
            if (authToken == null) {
                throw new ServiceException(5);
            }
            try {
                transferId = Integer.parseInt(mainInAttr.get("transfer:id"));
            }
            catch (NumberFormatException nfe) {
                throw new ServiceException(2);
            }
            if (baseDir == null) {
                throw new ServiceException(4);
            }
            String cacheDir = ActionUtil.getCacheDir(baseDir);
            int i = 0;
            while (i < nrItems) {
                ActionData childData = action.getChildData(i);
                String url = childData.getUrl();
                String localUrl = HttpUtil.hashUrlIntoLocalUrl(url, cacheDir);
                Resource resource = new Resource(null, url, null);
                resource.setLocalURL(localUrl);
                items[i] = new DownloadItem(resource);
                int fileSize = 0;
                if (ActionUtil.hasDownloadMarker(localUrl) && (fileSize = IOUtil.getFileSize(localUrl)) > 0) {
                    Log.info("File is already downloaded: " + localUrl);
                    items[i].setState(5);
                    items[i].setTotalNrBytes(fileSize);
                    items[i].setCurrentNrBytes(fileSize);
                    ++nrCompletedItems;
                } else {
                    items[i].setState(1);
                }
                ++i;
            }
            DownloadJobResponseHandler downloadJobResponseHandler = new DownloadJobResponseHandler(action, responseListener);
            if (nrCompletedItems == nrItems) {
                downloadJobResponseHandler.transferCompleteNotify(transferId, items);
            } else {
                if (nrCompletedItems > 0) {
                    downloadJobResponseHandler.transferProgressNotify(transferId, items);
                }
                DownloadJob dj = new DownloadJob(transferId, authToken, (DownloadItem[])items);
                dj.setTransferJobListener(downloadJobResponseHandler);
                this.jobManager.addJob(dj);
            }
        }
        catch (ServiceException se) {
            int result = se.getResult();
            Attributes outAttr = new Attributes();
            outAttr.set("result", Result.toString(result), 0);
            mainData.setAttributes(outAttr);
            responseListener.actionCompleteNotify(action);
        }
    }
}

