/*
 * Decompiled with CFR 0.152.
 */
package com.sonyericsson.picasaweb.service.action;

import com.sonyericsson.picasaweb.model.Entry;
import com.sonyericsson.picasaweb.service.AuthorizationStore;
import com.sonyericsson.picasaweb.service.Result;
import com.sonyericsson.picasaweb.service.ServiceException;
import com.sonyericsson.picasaweb.service.action.Action;
import com.sonyericsson.picasaweb.service.action.ActionData;
import com.sonyericsson.picasaweb.service.action.ActionHandler;
import com.sonyericsson.picasaweb.service.action.ActionResponseListener;
import com.sonyericsson.picasaweb.service.action.ActionUtil;
import com.sonyericsson.picasaweb.service.codec.Codec;
import com.sonyericsson.picasaweb.util.Attributes;

public class GetActionHandler
implements ActionHandler {
    private AuthorizationStore authStore;

    public GetActionHandler(AuthorizationStore authStore) {
        this.authStore = authStore;
    }

    public void handleAction(Action action, ActionResponseListener responseListener) {
        int result = 0;
        ActionData actionData = action.getMainData();
        Attributes inAttr = actionData.getAttributes();
        Attributes outAttr = null;
        String baseDir = actionData.getUrl();
        String authToken = this.authStore.getUserInfo().getAuthToken();
        try {
            if (baseDir == null) {
                throw new ServiceException(4);
            }
            Entry entry = ActionUtil.fetchEntry(authToken, inAttr);
            outAttr = Codec.encode(entry);
        }
        catch (ServiceException se) {
            result = se.getResult();
            if (result == 5) {
                this.authStore.setUserInfo(null);
            }
            outAttr = new Attributes();
        }
        outAttr.set("result", Result.toString(result), 0);
        actionData.setAttributes(outAttr);
        responseListener.actionCompleteNotify(action);
    }
}

