/*
 * Decompiled with CFR 0.152.
 */
package com.sonyericsson.picasaweb.service.action;

import com.sonyericsson.picasaweb.log.Log;
import com.sonyericsson.picasaweb.service.AuthorizationStore;
import com.sonyericsson.picasaweb.service.Result;
import com.sonyericsson.picasaweb.service.ServiceException;
import com.sonyericsson.picasaweb.service.action.Action;
import com.sonyericsson.picasaweb.service.action.ActionData;
import com.sonyericsson.picasaweb.service.action.ActionHandler;
import com.sonyericsson.picasaweb.service.action.ActionResponseListener;
import com.sonyericsson.picasaweb.service.codec.Codec;
import com.sonyericsson.picasaweb.util.Attributes;
import com.sonyericsson.picasaweb.util.HttpUtil;
import com.sonyericsson.picasaweb.util.IOUtil;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.microedition.io.Connection;
import javax.microedition.io.Connector;
import javax.microedition.io.file.FileConnection;

public class InfoActionHandler
implements ActionHandler {
    private static final String ATTR_USER_NAME = "user:name";
    private static final String ATTR_USER_NICKNAME = "user:nickname";
    private static final String ATTR_AUTH_SIGN_UP_URL = "auth:sign-up-url";
    private static final String ATTR_AUTH_ENABLED = "auth:enabled";
    private static final String LOG_PREFIX = "InfoActionHandler: ";
    private AuthorizationStore authStore;

    public InfoActionHandler(AuthorizationStore authStore) {
        this.authStore = authStore;
    }

    private String copyIcon(String baseDir) throws ServiceException {
        String url = baseDir;
        FileConnection fc = null;
        InputStream is = null;
        OutputStream os = null;
        if (!url.endsWith("/")) {
            url = String.valueOf(url) + "/";
        }
        url = String.valueOf(url) + "icon.png";
        Log.trace("InfoActionHandler: copying icon to " + url);
        try {
            try {
                fc = (FileConnection)Connector.open((String)url);
                if (!fc.exists()) {
                    Log.trace("InfoActionHandler: creating icon file");
                    fc.create();
                }
                Log.trace("InfoActionHandler: opening streams");
                os = fc.openOutputStream();
                Log.trace("InfoActionHandler: created os " + os);
                is = this.getClass().getResourceAsStream("/icon.png");
                Log.trace("InfoActionHandler: created is " + is);
                int nrBytes = HttpUtil.copyStream(is, os);
                Log.trace("InfoActionHandler: data written: " + nrBytes + " bytes");
            }
            catch (IOException e) {
                Log.logException(e);
                throw new ServiceException(9);
            }
        }
        catch (Throwable throwable) {
            IOUtil.closeInputStream(is);
            IOUtil.closeOutputStream(os);
            IOUtil.closeConnection((Connection)fc);
            throw throwable;
        }
        IOUtil.closeInputStream(is);
        IOUtil.closeOutputStream(os);
        IOUtil.closeConnection((Connection)fc);
        return url;
    }

    public void handleAction(Action action, ActionResponseListener responseListener) {
        int result = 0;
        ActionData actionData = action.getMainData();
        Attributes outAttr = new Attributes();
        String baseDir = actionData.getUrl();
        try {
            if (baseDir != null && baseDir.startsWith("file://")) {
                String iconUrl = this.copyIcon(baseDir);
                actionData.setUrl(iconUrl);
            }
        }
        catch (ServiceException se) {
            result = se.getResult();
        }
        outAttr.set("result", Result.toString(result), 0);
        outAttr.set(ATTR_AUTH_ENABLED, "true");
        outAttr.set(ATTR_AUTH_SIGN_UP_URL, Codec.encodeAttribute("https://www.google.com/accounts/NewAccount"));
        outAttr.set(ATTR_USER_NICKNAME, Codec.encodeAttribute(this.authStore.getUserInfo().getNickName()));
        outAttr.set(ATTR_USER_NAME, Codec.encodeAttribute(this.authStore.getUserInfo().getName()));
        actionData.setAttributes(outAttr);
        responseListener.actionCompleteNotify(action);
    }
}

