/*
 * Decompiled with CFR 0.152.
 */
package com.sonyericsson.picasaweb.service.codec;

import com.sonyericsson.picasaweb.util.StringCodec;
import java.io.UnsupportedEncodingException;

public class AttributeCodec
implements StringCodec {
    private static AttributeCodec instance;
    private char[] chars = new char[]{'?', '&', '=', ';', '%'};

    private boolean isReservedChar(char c) {
        int i = 0;
        while (i < this.chars.length) {
            if (c == this.chars[i]) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static AttributeCodec getInstance() {
        if (instance == null) {
            instance = new AttributeCodec();
        }
        return instance;
    }

    public String decode(String s) throws UnsupportedEncodingException {
        if (s == null) {
            return null;
        }
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < s.length()) {
            char c = s.charAt(i);
            if (c == '%') {
                try {
                    char parsedChar = (char)Byte.parseByte(s.substring(i + 1, i + 3), 16);
                    if (this.isReservedChar(parsedChar)) {
                        c = parsedChar;
                        i += 2;
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            sb.append(c);
            ++i;
        }
        return sb.toString();
    }

    public String encode(String s) throws UnsupportedEncodingException {
        if (s == null) {
            return null;
        }
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < s.length()) {
            char c = s.charAt(i);
            if (this.isReservedChar(c)) {
                sb.append('%');
                sb.append(Integer.toHexString(c).toUpperCase());
            } else {
                sb.append(c);
            }
            ++i;
        }
        return sb.toString();
    }
}

