/*
 * Decompiled with CFR 0.152.
 */
package com.sonyericsson.picasaweb.service.codec;

import com.sonyericsson.picasaweb.model.Entry;
import com.sonyericsson.picasaweb.service.codec.AlbumCodec;
import com.sonyericsson.picasaweb.service.codec.CommentCodec;
import com.sonyericsson.picasaweb.service.codec.EntryCodec;
import com.sonyericsson.picasaweb.service.codec.PhotoCodec;
import com.sonyericsson.picasaweb.util.Attributes;
import java.util.Hashtable;

public abstract class Codec {
    private static Hashtable codecs;

    private static Hashtable getCodecs() {
        if (codecs == null) {
            codecs = new Hashtable();
            codecs.put("album", new AlbumCodec());
            codecs.put("content", new PhotoCodec());
            codecs.put("comment", new CommentCodec());
        }
        return codecs;
    }

    private static EntryCodec getCodec(String type) {
        return (EntryCodec)Codec.getCodecs().get(type);
    }

    public static final Entry decode(Attributes attr) {
        Entry entry = null;
        String type = attr.get("item:type");
        EntryCodec codec = null;
        if (type != null) {
            codec = Codec.getCodec(type);
        }
        if (codec != null) {
            entry = codec.createEntry();
            codec.decodeEntry(attr, entry);
        }
        return entry;
    }

    public static final Attributes encode(Entry entry) {
        Attributes attr = null;
        EntryCodec codec = Codec.getCodec(entry.getType());
        if (codec != null) {
            attr = new Attributes();
            codec.encodeEntry(entry, attr);
        }
        return attr;
    }

    public static final String encodeAttribute(String s) {
        return EntryCodec.encodeAttribute(s);
    }

    public static final String decodeAttribute(String s) {
        return EntryCodec.decodeAttribute(s);
    }
}

