/*
 * Decompiled with CFR 0.152.
 */
package com.sonyericsson.picasaweb.service.codec;

import com.sonyericsson.picasaweb.log.Log;
import com.sonyericsson.picasaweb.model.Comment;
import com.sonyericsson.picasaweb.model.Entry;
import com.sonyericsson.picasaweb.service.codec.EntryCodec;
import com.sonyericsson.picasaweb.util.Attributes;

public class CommentCodec
extends EntryCodec {
    private static final String ATTR_PHOTO_ID = "content:id";
    private static final String ATTR_TITLE = "comment:title";
    private static final String ATTR_TEXT = "comment:text";
    private static final String ATTR_AUTHOR_NAME = "comment:author-name";
    private static final String ATTR_AUTHOR_NICKNAME = "comment:author-nickname";

    protected Entry createEntry() {
        return new Comment();
    }

    protected void encodeEntry(Entry entry, Attributes attr) {
        super.encodeEntry(entry, attr);
        Comment comment = (Comment)entry;
        Log.trace("CommentCodec.encodeEntry()");
        attr.set(ATTR_TITLE, EntryCodec.encodeAttribute(comment.getTitle()));
        attr.set(ATTR_TEXT, EntryCodec.encodeAttribute(comment.getText()));
        attr.set(ATTR_AUTHOR_NAME, EntryCodec.encodeAttribute(comment.getAuthorName()));
        attr.set(ATTR_AUTHOR_NICKNAME, EntryCodec.encodeAttribute(comment.getAuthorNickName()));
        attr.set(ATTR_PHOTO_ID, comment.getPhotoId());
    }

    protected void decodeEntry(Attributes attr, Entry entry) {
        super.decodeEntry(attr, entry);
        Comment comment = (Comment)entry;
        Log.trace("CommentCodec.decodeEntry()");
        comment.setTitle(EntryCodec.decodeAttribute(attr.get(ATTR_TITLE)));
        comment.setText(EntryCodec.decodeAttribute(attr.get(ATTR_TEXT)));
        comment.setAuthorName(EntryCodec.decodeAttribute(attr.get(ATTR_AUTHOR_NAME)));
        comment.setAuthorNickName(EntryCodec.decodeAttribute(attr.get(ATTR_AUTHOR_NICKNAME)));
        comment.setPhotoId(attr.get(ATTR_PHOTO_ID));
    }
}

