/*
 * Decompiled with CFR 0.152.
 */
package com.sonyericsson.picasaweb.service.xml;

import com.sonyericsson.picasaweb.log.Log;
import com.sonyericsson.picasaweb.service.xml.XmlException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Stack;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public abstract class XmlParser {
    private Handler handler = new Handler();
    private Stack elements = new Stack();
    private boolean aborted;

    protected XmlParser() {
    }

    public void parse(InputStream is) throws IOException, XmlException {
        try {
            SAXParserFactory.newInstance().newSAXParser().parse(is, (DefaultHandler)this.handler);
        }
        catch (IOException e) {
            throw e;
        }
        catch (SAXParserAbortedException sae) {
            Log.trace("XMLParser#parse: parsing aborted by application");
        }
        catch (Throwable t) {
            throw new XmlException(t.getMessage());
        }
    }

    protected void abort() {
        this.aborted = true;
    }

    public boolean isAborted() {
        return this.aborted;
    }

    protected void startElement(String element, Attributes attributes) {
    }

    protected void characters(String element, char[] ch, int start, int length) {
    }

    protected void endElement(String element) {
    }

    protected final String getCurrentPath() {
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < this.elements.size()) {
            sb.append('/');
            sb.append((String)this.elements.elementAt(i));
            ++i;
        }
        return sb.toString();
    }

    protected final boolean isCurrentPath(String path) {
        int pos = path.length();
        int i = this.elements.size() - 1;
        while (i >= 0) {
            String element = (String)this.elements.elementAt(i);
            if ((pos = path.lastIndexOf(47, pos - 1)) < 0 || !path.regionMatches(false, pos + 1, element, 0, element.length())) {
                return false;
            }
            --i;
        }
        return pos == 0;
    }

    private class Handler
    extends DefaultHandler {
        private Handler() {
        }

        public final void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            XmlParser.this.elements.push(qName);
            XmlParser.this.startElement(qName, attributes);
            if (XmlParser.this.aborted) {
                throw new SAXParserAbortedException();
            }
        }

        public final void characters(char[] ch, int start, int length) throws SAXException {
            XmlParser.this.characters((String)XmlParser.this.elements.peek(), ch, start, length);
            if (XmlParser.this.aborted) {
                throw new SAXParserAbortedException();
            }
        }

        public final void endElement(String uri, String localName, String qName) throws SAXException {
            XmlParser.this.endElement(qName);
            XmlParser.this.elements.pop();
            if (XmlParser.this.aborted) {
                throw new SAXParserAbortedException();
            }
        }
    }

    private class SAXParserAbortedException
    extends SAXException {
        public SAXParserAbortedException() {
            super("Parsing aborted by application");
        }
    }
}

