/*
 * Decompiled with CFR 0.152.
 */
package com.sonyericsson.picasaweb.log;

import com.sonyericsson.content.InvocationPart;
import com.sonyericsson.content.MultipartInvocation;
import com.sonyericsson.content.MultipartInvocationFactory;
import com.sonyericsson.picasaweb.log.LogWriter;
import javax.microedition.content.Invocation;

public abstract class Log {
    public static final int LEVEL_NONE = 0;
    public static final int LEVEL_ERROR = 1;
    public static final int LEVEL_WARNING = 2;
    public static final int LEVEL_INFO = 3;
    public static final int LEVEL_TRACE = 4;
    private static int currentLevel = 0;
    private static LogWriter writer;

    public static void setLevel(int level) {
        currentLevel = level;
    }

    public static void setWriter(LogWriter w) {
        writer = w;
    }

    public static void logException(Exception e) {
        writer.write("Exception " + e.getClass().getName() + ": Message='" + e.getMessage() + "'\n");
        e.printStackTrace();
    }

    private static void log(Object caller, int level, String s) {
        if (currentLevel >= level) {
            if (caller != null) {
                s = String.valueOf(caller.getClass().getName()) + ": " + s;
            }
            writer.write(s);
        }
    }

    public static void error(String s) {
        Log.error(null, s);
    }

    public static void error(Object caller, String s) {
        Log.log(caller, 1, s);
    }

    public static void warning(String s) {
        Log.warning(null, s);
    }

    public static void warning(Object caller, String s) {
        Log.log(caller, 2, s);
    }

    public static void info(String s) {
        Log.info(null, s);
    }

    public static void info(Object caller, String s) {
        Log.log(caller, 3, s);
    }

    public static void trace(String s) {
        Log.trace(null, s);
    }

    public static void trace(Object caller, String s) {
        Log.log(caller, 4, s);
    }

    private static String getInvocationStatusString(int status) {
        switch (status) {
            case 2: {
                return "ACTIVE";
            }
            case 6: {
                return "CANCELLED";
            }
            case 7: {
                return "ERROR";
            }
            case 4: {
                return "HOLD";
            }
            case 1: {
                return "INIT";
            }
            case 8: {
                return "INITIATED";
            }
            case 5: {
                return "OK";
            }
            case 3: {
                return "WAITING";
            }
        }
        return "";
    }

    public static void logInvocation(String prefix, Invocation invocation, int status) {
        Log.info("-------------------------------");
        if (status >= 0) {
            Log.info("Invocation status: " + Log.getInvocationStatusString(status));
        }
        Log.info(String.valueOf(prefix) + " Action = '" + invocation.getAction() + "'");
        String url = invocation.getURL();
        if (url != null) {
            Log.info(String.valueOf(prefix) + " URL = '" + url + "'");
        }
        String[] args = invocation.getArgs();
        int i = 0;
        while (i < args.length) {
            Log.info(String.valueOf(prefix) + " Args[" + i + "] = '" + args[i] + "'");
            ++i;
        }
        MultipartInvocation mi = MultipartInvocationFactory.getInstance((Invocation)invocation);
        if (mi != null) {
            int nrParts = mi.getNumberOfInvocationParts();
            int j = 0;
            while (j < nrParts) {
                InvocationPart part = mi.getInvocationPartAt(j);
                Log.info(String.valueOf(prefix) + " Part[" + j + "]");
                url = part.getURL();
                if (url != null) {
                    Log.info(String.valueOf(prefix) + "    URL = '" + url + "'");
                }
                args = part.getArgs();
                int i2 = 0;
                while (i2 < args.length) {
                    Log.info(String.valueOf(prefix) + "    Args[" + i2 + "] = '" + args[i2] + "'");
                    ++i2;
                }
                ++j;
            }
        }
        Log.info("-------------------------------");
    }

    public static void logInvocation(String prefix, Invocation invocation) {
        Log.logInvocation(prefix, invocation, -1);
    }
}

